/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.utils.CuriosSlot;
import dlovin.inventoryhud.utils.SlotTypePreset;
import dlovin.inventoryhud.utils.WidgetAligns;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.fml.loading.FMLPaths;

public class CuriosSaveUtils {
    private static final String path = FMLPaths.CONFIGDIR.get() + "/InventoryHUD/curios.json";

    public static void saveFile(String input) {
        File file = new File(path);
        CuriosSaveUtils.saveFile(file, input);
    }

    private static void saveFile(File file, String input) {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        try {
            FileWriter fw = new FileWriter(file.getAbsoluteFile());
            BufferedWriter bw = new BufferedWriter(fw);
            bw.write(input);
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public static void saveSettings() {
        JsonObject obj = new JsonObject();
        for (Map.Entry<String, CuriosSlot> entry : InventoryHUD.getInstance().getInventoryGui().curiosRenderer.slots.entrySet()) {
            JsonObject tmpObject = new JsonObject();
            tmpObject.addProperty("x", (Number)entry.getValue().x);
            tmpObject.addProperty("y", (Number)entry.getValue().y);
            tmpObject.addProperty("halign", entry.getValue().aligns.HorAlign.name());
            tmpObject.addProperty("valign", entry.getValue().aligns.VertAlign.name());
            tmpObject.addProperty("enabled", Boolean.valueOf(entry.getValue().enabled));
            obj.add(entry.getKey(), (JsonElement)tmpObject);
        }
        CuriosSaveUtils.saveFile(obj.toString());
    }

    public static HashMap<String, CuriosSlot> loadFromFile() {
        HashMap<String, CuriosSlot> hashMap;
        File file = new File(path);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        if (!file.exists()) {
            CuriosSaveUtils.saveFile(file, CuriosSaveUtils.getDefault());
        }
        JsonParser jsonParser = new JsonParser();
        FileReader reader = new FileReader(file);
        try {
            JsonElement obj = jsonParser.parse((Reader)reader);
            JsonObject list = CuriosSaveUtils.checkTypes(obj.getAsJsonObject());
            hashMap = CuriosSaveUtils.setTypes(list);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        reader.close();
        return hashMap;
    }

    private static HashMap<String, CuriosSlot> setTypes(JsonObject obj) {
        HashMap<String, CuriosSlot> result = new HashMap<String, CuriosSlot>();
        for (Map.Entry el : obj.entrySet()) {
            int x = ((JsonElement)el.getValue()).getAsJsonObject().get("x").getAsInt();
            int y = ((JsonElement)el.getValue()).getAsJsonObject().get("y").getAsInt();
            WidgetAligns.HAlign hAlign = WidgetAligns.HAlign.valueOf(((JsonElement)el.getValue()).getAsJsonObject().get("halign").getAsString());
            WidgetAligns.VAlign vAlign = WidgetAligns.VAlign.valueOf(((JsonElement)el.getValue()).getAsJsonObject().get("valign").getAsString());
            boolean enabled = ((JsonElement)el.getValue()).getAsJsonObject().get("enabled").getAsBoolean();
            result.put((String)el.getKey(), new CuriosSlot(x, y, new WidgetAligns(hAlign, vAlign), enabled, (String)el.getKey()));
        }
        return result;
    }

    private static String getDefault() {
        JsonObject obj = new JsonObject();
        for (int i = 0; i < SlotTypePreset.values().length; ++i) {
            JsonObject tmpObject = new JsonObject();
            tmpObject.addProperty("x", (Number)0);
            tmpObject.addProperty("y", (Number)(i * 20));
            tmpObject.addProperty("halign", "LEFT");
            tmpObject.addProperty("valign", "TOP");
            tmpObject.addProperty("enabled", Boolean.valueOf(false));
            obj.add(SlotTypePreset.values()[i].getIdentifier(), (JsonElement)tmpObject);
        }
        return obj.toString();
    }

    private static JsonObject checkTypes(JsonObject obj) {
        boolean save = false;
        for (int i = 0; i < SlotTypePreset.values().length; ++i) {
            if (obj.get(SlotTypePreset.values()[i].getIdentifier()) != null) continue;
            JsonObject tmpObject = new JsonObject();
            tmpObject.addProperty("x", (Number)0);
            tmpObject.addProperty("y", (Number)(i * 20));
            tmpObject.addProperty("halign", "LEFT");
            tmpObject.addProperty("valign", "TOP");
            tmpObject.addProperty("enabled", Boolean.valueOf(false));
            obj.add(SlotTypePreset.values()[i].getIdentifier(), (JsonElement)tmpObject);
            save = true;
        }
        if (save) {
            CuriosSaveUtils.saveFile(obj.toString());
        }
        return obj;
    }
}

