/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.group;

import de.maxhenkel.voicechat.gui.group.GroupEntry;
import de.maxhenkel.voicechat.gui.widgets.ListScreenBase;
import de.maxhenkel.voicechat.gui.widgets.ListScreenListBase;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.common.ClientGroup;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.components.AbstractSelectionList;

public class GroupList
extends ListScreenListBase<GroupEntry> {
    protected final ListScreenBase parent;

    public GroupList(ListScreenBase parent, int width, int height, int x, int y, int size) {
        super(width, height, x, y, size);
        this.parent = parent;
        this.m_93488_(false);
        this.m_93496_(false);
        this.tick();
    }

    public void tick() {
        List<PlayerState> playerStates = ClientManager.getPlayerStateManager().getPlayerStates(true);
        ClientGroup group = ClientManager.getPlayerStateManager().getGroup();
        if (group == null) {
            this.m_93516_();
            this.f_93386_.m_91152_(null);
            return;
        }
        boolean changed = false;
        LinkedList<GroupEntry> toRemove = new LinkedList<GroupEntry>();
        for (GroupEntry entry : this.m_6702_()) {
            PlayerState state = ClientManager.getPlayerStateManager().getState(entry.getState().getUuid());
            if (state == null) {
                toRemove.add(entry);
                changed = true;
                continue;
            }
            entry.setState(state);
            if (this.isInGroup(state, group)) continue;
            toRemove.add(entry);
            changed = true;
        }
        for (GroupEntry entry : toRemove) {
            this.m_93502_((AbstractSelectionList.Entry)entry);
        }
        for (PlayerState state : playerStates) {
            if (!this.isInGroup(state, group) || !this.m_6702_().stream().noneMatch(groupEntry -> groupEntry.getState().getUuid().equals(state.getUuid()))) continue;
            this.m_7085_((AbstractSelectionList.Entry)new GroupEntry(this.parent, state));
            changed = true;
        }
        if (changed) {
            this.m_6702_().sort(Comparator.comparing(o -> o.getState().getName()));
        }
    }

    private boolean isInGroup(PlayerState state, ClientGroup group) {
        return state.hasGroup() && state.getGroup().getId().equals(group.getId());
    }
}

