/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.macos;

import de.maxhenkel.voicechat.com.dd.plist.NSDictionary;
import de.maxhenkel.voicechat.com.dd.plist.NSObject;
import de.maxhenkel.voicechat.com.dd.plist.PropertyListFormatException;
import de.maxhenkel.voicechat.com.dd.plist.PropertyListParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.ParseException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class MacApplication {
    private final Path appPath;
    private final Path infoPlistPath;
    private final String name;
    private final NSDictionary info;

    public MacApplication(Path appPath) throws IOException, PropertyListFormatException, ParseException, ParserConfigurationException, SAXException {
        this.appPath = appPath;
        if (!Files.isDirectory(appPath, new LinkOption[0])) {
            throw new IOException("'" + appPath + "' is not an application");
        }
        if (!appPath.toFile().getName().endsWith(".app")) {
            throw new IOException("'" + appPath + "' is not an application");
        }
        Path infoPlist = appPath.resolve("Contents").resolve("Info.plist");
        if (!Files.exists(infoPlist, new LinkOption[0])) {
            throw new IOException("No Info.plist found");
        }
        this.infoPlistPath = infoPlist;
        this.info = (NSDictionary)PropertyListParser.parse(this.infoPlistPath.toFile());
        this.name = this.info.get("CFBundleName").toString();
    }

    public String getName() {
        return this.name;
    }

    public void fixMicrophoneUsageDescription() throws IOException {
        if (!this.info.containsKey("NSMicrophoneUsageDescription")) {
            this.info.put("NSMicrophoneUsageDescription", (Object)"A Minecraft mod is requesting access to the microphone");
            PropertyListParser.saveAsXML((NSObject)this.info, this.infoPlistPath.toFile());
        }
    }

    public void removeSignature() throws IOException, InterruptedException {
        ProcessBuilder builder = new ProcessBuilder("codesign", "--verbose", "--deep", "--remove-signature", this.appPath.toFile().getAbsolutePath());
        Process process = builder.start();
        String stderr = this.captureStream(process.errorReader());
        String stdout = this.captureStream(process.inputReader());
        process.waitFor();
        if (process.exitValue() != 0) {
            StringBuilder sb = new StringBuilder();
            sb.append("Failed to execute codesign. Exit code ");
            sb.append(process.exitValue());
            sb.append(".");
            if (!stdout.isEmpty()) {
                sb.append("\n");
                sb.append(stdout);
            }
            if (!stderr.isEmpty()) {
                sb.append("\n");
                sb.append(stderr);
            }
            throw new IOException(sb.toString());
        }
    }

    public String captureStream(BufferedReader reader) throws IOException {
        String line;
        StringBuilder builder = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            builder.append(line);
            builder.append("\n");
        }
        return builder.toString();
    }
}

