/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.plugins.impl.packets;

import de.maxhenkel.voicechat.api.Position;
import de.maxhenkel.voicechat.api.packets.EntitySoundPacket;
import de.maxhenkel.voicechat.api.packets.LocationalSoundPacket;
import de.maxhenkel.voicechat.api.packets.StaticSoundPacket;
import de.maxhenkel.voicechat.plugins.impl.PositionImpl;
import de.maxhenkel.voicechat.plugins.impl.packets.EntitySoundPacketImpl;
import de.maxhenkel.voicechat.plugins.impl.packets.LocationalSoundPacketImpl;
import de.maxhenkel.voicechat.plugins.impl.packets.StaticSoundPacketImpl;
import de.maxhenkel.voicechat.voice.common.GroupSoundPacket;
import de.maxhenkel.voicechat.voice.common.LocationSoundPacket;
import de.maxhenkel.voicechat.voice.common.PlayerSoundPacket;
import de.maxhenkel.voicechat.voice.common.SoundPacket;
import java.util.UUID;

public class SoundPacketImpl
implements de.maxhenkel.voicechat.api.packets.SoundPacket {
    private final SoundPacket<?> packet;

    public SoundPacketImpl(SoundPacket<?> packet) {
        this.packet = packet;
    }

    @Override
    public UUID getSender() {
        return this.packet.getSender();
    }

    @Override
    public byte[] getOpusEncodedData() {
        return this.packet.getData();
    }

    @Override
    public long getSequenceNumber() {
        return this.packet.getSequenceNumber();
    }

    public SoundPacket<?> getPacket() {
        return this.packet;
    }

    @Override
    public EntitySoundPacket toEntitySoundPacket(UUID entityUuid, boolean whispering) {
        return new EntitySoundPacketImpl(new PlayerSoundPacket(this.packet.getSender(), this.packet.getData(), this.packet.getSequenceNumber(), whispering));
    }

    @Override
    public LocationalSoundPacket toLocationalSoundPacket(Position position) {
        if (position instanceof PositionImpl) {
            PositionImpl p = (PositionImpl)position;
            return new LocationalSoundPacketImpl(new LocationSoundPacket(this.packet.getSender(), p.getPosition(), this.packet.getData(), this.packet.getSequenceNumber()));
        }
        throw new IllegalArgumentException("position is not an instance of PositionImpl");
    }

    @Override
    public StaticSoundPacket toStaticSoundPacket() {
        return new StaticSoundPacketImpl(new GroupSoundPacket(this.packet.getSender(), this.packet.getData(), this.packet.getSequenceNumber()));
    }
}

