/*
 * Decompiled with CFR 0.152.
 */
package fuzs.pickupnotifier.client.gui.entry;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import fuzs.pickupnotifier.PickUpNotifier;
import fuzs.pickupnotifier.config.ClientConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Rarity;

public abstract class DisplayEntry {
    protected final Minecraft mc = Minecraft.m_91087_();
    public static final int ENTRY_HEIGHT = 18;
    private final int textItemMargin = 4;
    private final Rarity rarity;
    protected int displayAmount;
    protected int remainingTicks;

    protected DisplayEntry(int amount, Rarity rarity) {
        this.displayAmount = Math.min(amount, ((ClientConfig)PickUpNotifier.CONFIG.client()).behavior().maxCount);
        this.rarity = rarity;
        this.setDefaultDisplayTicks();
    }

    public boolean readyToRemove() {
        return this.remainingTicks <= 0;
    }

    public void tick() {
        if (this.remainingTicks > 0) {
            --this.remainingTicks;
        }
    }

    protected abstract Component getEntryName();

    public MutableComponent getTextComponent() {
        MutableComponent name = new TextComponent("").m_7220_(this.getEntryName());
        if (this.displayAmount <= 0) {
            return name;
        }
        if (((ClientConfig)PickUpNotifier.CONFIG.client()).display().position.isMirrored()) {
            name = new TextComponent(this.displayAmount + "x ").m_7220_((Component)name);
        } else {
            name.m_130946_(" x" + this.displayAmount);
        }
        return name.m_6270_(this.getComponentStyle());
    }

    private Style getComponentStyle() {
        if (!((ClientConfig)PickUpNotifier.CONFIG.client()).display().ignoreRarity && this.rarity != Rarity.COMMON) {
            return Style.f_131099_.m_131140_(this.rarity.f_43022_);
        }
        return Style.f_131099_.m_131140_(((ClientConfig)PickUpNotifier.CONFIG.client()).display().textColor);
    }

    public float getRemainingTicksRelative(float partialTicks) {
        float moveTime = Math.min(((ClientConfig)PickUpNotifier.CONFIG.client()).behavior().moveTime, ((ClientConfig)PickUpNotifier.CONFIG.client()).behavior().displayTime);
        return 1.0f - Mth.m_14036_((float)(((float)this.remainingTicks - partialTicks) / moveTime), (float)0.0f, (float)1.0f);
    }

    public void setDefaultDisplayTicks() {
        this.remainingTicks = ((ClientConfig)PickUpNotifier.CONFIG.client()).behavior().displayTime;
    }

    public abstract boolean mayMergeWith(DisplayEntry var1);

    public void mergeWith(DisplayEntry other) {
        this.displayAmount = Math.min(this.displayAmount + other.displayAmount, ((ClientConfig)PickUpNotifier.CONFIG.client()).behavior().maxCount);
        this.setDefaultDisplayTicks();
    }

    public int getEntryWidth() {
        int textWidth = this.mc.f_91062_.m_92852_((FormattedText)this.getTextComponent());
        return ((ClientConfig)PickUpNotifier.CONFIG.client()).display().showSprite ? textWidth + this.textItemMargin + 16 : textWidth;
    }

    public void render(PoseStack poseStack, int posX, int posY, float alpha, float scale) {
        int fadeTime;
        boolean mirrorPosition = ((ClientConfig)PickUpNotifier.CONFIG.client()).display().position.isMirrored();
        boolean withSprite = ((ClientConfig)PickUpNotifier.CONFIG.client()).display().showSprite;
        int posXSide = mirrorPosition || !withSprite ? posX : posX + 16 + this.textItemMargin;
        poseStack.m_85836_();
        poseStack.m_85841_(scale, scale, 1.0f);
        if (!this.mc.f_91066_.f_92050_) {
            int backgroundOpacity = (int)(this.mc.f_91066_.f_92122_ * (double)(1.0f - alpha) * 255.0) << 24 & 0xFF000000;
            GuiComponent.m_93172_((PoseStack)poseStack, (int)(posX - 2), (int)posY, (int)(posX + this.getEntryWidth() + 4), (int)(posY + 16), (int)backgroundOpacity);
        }
        int n = fadeTime = ((ClientConfig)PickUpNotifier.CONFIG.client()).behavior().fadeAway ? 255 - (int)(255.0f * alpha) : 255;
        if (fadeTime >= 5) {
            RenderSystem.m_69478_();
            RenderSystem.m_69453_();
            GuiComponent.m_93243_((PoseStack)poseStack, (Font)this.mc.f_91062_, (Component)this.getTextComponent(), (int)posXSide, (int)(posY + 3), (int)(0xFFFFFF + (fadeTime << 24)));
            if (withSprite) {
                int textWidth = this.mc.f_91062_.m_92852_((FormattedText)this.getTextComponent());
                this.renderSprite(poseStack, mirrorPosition ? posX + textWidth + this.textItemMargin : posX, posY, scale);
            }
            RenderSystem.m_69461_();
        }
        poseStack.m_85849_();
    }

    protected abstract void renderSprite(PoseStack var1, int var2, int var3, float var4);
}

