/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.yungsextras.module;

import com.yungnickyoung.minecraft.yungsextras.YungsExtrasCommon;
import com.yungnickyoung.minecraft.yungsextras.module.ConfiguredFeatureModule;
import com.yungnickyoung.minecraft.yungsextras.module.FeatureModule;
import com.yungnickyoung.minecraft.yungsextras.world.feature.desert.ChillzoneDesertFeature;
import com.yungnickyoung.minecraft.yungsextras.world.feature.desert.DesertGiantTorchFeature;
import com.yungnickyoung.minecraft.yungsextras.world.feature.desert.DesertObeliskFeature;
import com.yungnickyoung.minecraft.yungsextras.world.feature.desert.DesertSmallRuinsFeature;
import com.yungnickyoung.minecraft.yungsextras.world.feature.desert.DesertWellFeature;
import com.yungnickyoung.minecraft.yungsextras.world.feature.swamp.SwampArchFeature;
import com.yungnickyoung.minecraft.yungsextras.world.feature.swamp.SwampChurchFeature;
import com.yungnickyoung.minecraft.yungsextras.world.feature.swamp.SwampCubbyFeature;
import com.yungnickyoung.minecraft.yungsextras.world.feature.swamp.SwampDoubleArchFeature;
import com.yungnickyoung.minecraft.yungsextras.world.feature.swamp.SwampOgreFeature;
import com.yungnickyoung.minecraft.yungsextras.world.feature.swamp.SwampPillarFeature;
import net.minecraft.core.Holder;
import net.minecraft.data.worldgen.placement.MiscOverworldPlacements;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;

public class FeatureModuleForge {
    public static void init() {
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Feature.class, FeatureModuleForge::registerFeatures);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(FeatureModuleForge::registerConfiguredFeatures);
        MinecraftForge.EVENT_BUS.addListener(FeatureModuleForge::addFeaturesToBiomes);
    }

    private static void registerFeatures(RegistryEvent.Register<Feature<?>> event) {
        IForgeRegistry registry = event.getRegistry();
        FeatureModule.DESERT_WELL = FeatureModuleForge.register(registry, "desert_well", new DesertWellFeature());
        FeatureModule.DESERT_OBELISK = FeatureModuleForge.register(registry, "desert_obelisk", new DesertObeliskFeature());
        FeatureModule.DESERT_GIANT_TORCH = FeatureModuleForge.register(registry, "desert_giant_torch", new DesertGiantTorchFeature());
        FeatureModule.DESERT_RUINS_0 = FeatureModuleForge.register(registry, "desert_ruins_0", new DesertSmallRuinsFeature());
        FeatureModule.DESERT_CHILLZONE = FeatureModuleForge.register(registry, "desert_chillzone", new ChillzoneDesertFeature());
        FeatureModule.SWAMP_PILLAR = FeatureModuleForge.register(registry, "swamp_pillar", new SwampPillarFeature());
        FeatureModule.SWAMP_OGRE = FeatureModuleForge.register(registry, "swamp_ogre", new SwampOgreFeature());
        FeatureModule.SWAMP_CUBBY = FeatureModuleForge.register(registry, "swamp_cubby", new SwampCubbyFeature());
        FeatureModule.SWAMP_ARCH = FeatureModuleForge.register(registry, "swamp_arch", new SwampArchFeature());
        FeatureModule.SWAMP_DOUBLE_ARCH = FeatureModuleForge.register(registry, "swamp_double_arch", new SwampDoubleArchFeature());
        FeatureModule.SWAMP_CHURCH = FeatureModuleForge.register(registry, "swamp_church", new SwampChurchFeature());
    }

    private static void registerConfiguredFeatures(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ConfiguredFeatureModule.registerConfiguredFeatures();
            ConfiguredFeatureModule.registerPlacedFeatures();
        });
    }

    private static void addFeaturesToBiomes(BiomeLoadingEvent event) {
        if (!YungsExtrasCommon.CONFIG.desert.biomeBlacklist.contains(event.getName().toString()) && (event.getCategory() == Biome.BiomeCategory.DESERT || YungsExtrasCommon.CONFIG.desert.additionalBiomeWhitelist.contains(event.getName().toString()))) {
            event.getGeneration().getFeatures(GenerationStep.Decoration.SURFACE_STRUCTURES).removeIf(supplier -> ((PlacedFeature)supplier.m_203334_()).toString().equals(MiscOverworldPlacements.f_195273_.toString()));
            ConfiguredFeatureModule.NAMED_PLACED_FEATURES_BY_BIOME.get(Biome.BiomeCategory.DESERT).forEach(namedPlacedFeature -> {
                PlacedFeature placedFeature = namedPlacedFeature.placedFeature();
                event.getGeneration().getFeatures(GenerationStep.Decoration.SURFACE_STRUCTURES).add(Holder.m_205709_((Object)placedFeature));
            });
        }
        if (!YungsExtrasCommon.CONFIG.swamp.biomeBlacklist.contains(event.getName().toString()) && (event.getCategory() == Biome.BiomeCategory.SWAMP || YungsExtrasCommon.CONFIG.swamp.additionalBiomeWhitelist.contains(event.getName().toString()))) {
            ConfiguredFeatureModule.NAMED_PLACED_FEATURES_BY_BIOME.get(Biome.BiomeCategory.SWAMP).forEach(namedPlacedFeature -> {
                PlacedFeature placedFeature = namedPlacedFeature.placedFeature();
                event.getGeneration().getFeatures(GenerationStep.Decoration.SURFACE_STRUCTURES).add(Holder.m_205709_((Object)placedFeature));
            });
        }
    }

    private static <FC extends FeatureConfiguration> Feature<FC> register(IForgeRegistry<Feature<?>> registry, String name, Feature<FC> feature) {
        feature.setRegistryName(new ResourceLocation("yungsextras", name));
        registry.register(feature);
        return feature;
    }
}

