/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.item;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.silentchaos512.lib.network.internal.LeftClickItemPacket;
import net.silentchaos512.lib.network.internal.SilentLibNetwork;

public interface ILeftClickItem {
    default public InteractionResultHolder<ItemStack> onItemLeftClickSL(Level world, Player player, InteractionHand hand) {
        return new InteractionResultHolder(InteractionResult.PASS, (Object)player.m_21120_(hand));
    }

    default public InteractionResultHolder<ItemStack> onItemLeftClickBlockSL(Level world, Player player, InteractionHand hand) {
        return this.onItemLeftClickSL(world, player, hand);
    }

    public static final class EventHandler {
        private static EventHandler INSTANCE;

        private EventHandler() {
        }

        public static void init() {
            if (INSTANCE != null) {
                return;
            }
            INSTANCE = new EventHandler();
            MinecraftForge.EVENT_BUS.addListener(EventHandler::onLeftClickBlock);
            MinecraftForge.EVENT_BUS.addListener(EventHandler::onLeftClickEmpty);
        }

        private static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
            InteractionResultHolder<ItemStack> result;
            ItemStack stack = event.getItemStack();
            if (!stack.m_41619_() && stack.m_41720_() instanceof ILeftClickItem && (result = ((ILeftClickItem)stack.m_41720_()).onItemLeftClickBlockSL(event.getWorld(), event.getPlayer(), event.getHand())).m_19089_() == InteractionResult.SUCCESS) {
                SilentLibNetwork.channel.sendToServer((Object)new LeftClickItemPacket(ClickType.BLOCK, event.getHand()));
            }
        }

        private static void onLeftClickEmpty(PlayerInteractEvent.LeftClickEmpty event) {
            InteractionResultHolder<ItemStack> result;
            ItemStack stack = event.getItemStack();
            if (!stack.m_41619_() && stack.m_41720_() instanceof ILeftClickItem && (result = ((ILeftClickItem)stack.m_41720_()).onItemLeftClickSL(event.getWorld(), event.getPlayer(), event.getHand())).m_19089_() == InteractionResult.SUCCESS) {
                SilentLibNetwork.channel.sendToServer((Object)new LeftClickItemPacket(ClickType.EMPTY, event.getHand()));
            }
        }
    }

    public static enum ClickType {
        EMPTY,
        BLOCK;

    }
}

