/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.util;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class TextRenderUtils {
    private TextRenderUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static Font getFontRenderer() {
        return Minecraft.m_91087_().f_91062_;
    }

    private static void render(PoseStack matrix, Font fontRenderer, FormattedCharSequence text, float x, float y, int color, boolean shadow) {
        if (shadow) {
            fontRenderer.m_92744_(matrix, text, x, y, color);
        } else {
            fontRenderer.m_92877_(matrix, text, x, y, color);
        }
    }

    public static void renderScaled(PoseStack matrix, Font fontRenderer, FormattedCharSequence text, int x, int y, float scale, int color, boolean shadow) {
        matrix.m_85836_();
        matrix.m_85841_(scale, scale, scale);
        TextRenderUtils.render(matrix, fontRenderer, text, (float)x / scale, (float)y / scale, color, shadow);
        matrix.m_85849_();
    }

    public static void renderSplit(PoseStack matrix, Font fontRenderer, FormattedText text, int x, int y, int width, int color, boolean shadow) {
        List list = fontRenderer.m_92923_(text, width);
        for (int i = 0; i < list.size(); ++i) {
            FormattedCharSequence line = (FormattedCharSequence)list.get(i);
            Objects.requireNonNull(fontRenderer);
            int yTranslated = y + i * 9;
            TextRenderUtils.render(matrix, fontRenderer, line, x, yTranslated, color, shadow);
        }
    }

    public static void renderSplitScaled(PoseStack matrix, Font fontRenderer, FormattedText text, int x, int y, float scale, int color, boolean shadow, int length) {
        List lines = fontRenderer.m_92923_(text, (int)((float)length / scale));
        for (int i = 0; i < lines.size(); ++i) {
            Objects.requireNonNull(fontRenderer);
            int yTranslated = y + i * (int)(9.0f * scale + 3.0f);
            TextRenderUtils.renderScaled(matrix, fontRenderer, (FormattedCharSequence)lines.get(i), x, yTranslated, scale, color, shadow);
        }
    }
}

