/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.lib.world.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.silentchaos512.lib.world.placement.LibPlacements;

public class DimensionFilterPlacement
extends PlacementModifier {
    public static final Codec<DimensionFilterPlacement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("is_whitelist").forGetter(f -> f.isWhitelist), (App)Codec.STRING.listOf().fieldOf("list").forGetter(f -> f.levels.stream().map(rk -> rk.getRegistryName().toString()).collect(Collectors.toList()))).apply((Applicative)instance, (isWhitelist, strList) -> {
        Collection levels = strList.stream().map(str -> ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(str))).collect(Collectors.toList());
        return new DimensionFilterPlacement((boolean)isWhitelist, levels);
    }));
    private final boolean isWhitelist;
    private final Collection<ResourceKey<Level>> levels;

    public DimensionFilterPlacement(boolean isWhitelist, Collection<ResourceKey<Level>> levels) {
        this.isWhitelist = isWhitelist;
        this.levels = levels;
    }

    public Stream<BlockPos> m_183381_(PlacementContext helper, Random rand, BlockPos pos) {
        if (this.levels.contains(helper.m_191831_().m_6018_().m_46472_()) == this.isWhitelist) {
            return Stream.of(pos);
        }
        return Stream.empty();
    }

    public PlacementModifierType<DimensionFilterPlacement> m_183327_() {
        return LibPlacements.DIMENSION_FILTER.get();
    }
}

