/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.waystones.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import net.blay09.mods.waystones.block.PortstoneBlock;
import net.blay09.mods.waystones.block.entity.PortstoneBlockEntity;
import net.blay09.mods.waystones.client.ModRenderers;
import net.blay09.mods.waystones.client.render.PortstoneModel;
import net.blay09.mods.waystones.config.WaystonesConfig;
import net.blay09.mods.waystones.item.ModItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

public class PortstoneRenderer
implements BlockEntityRenderer<PortstoneBlockEntity> {
    private static final Material MATERIAL = new Material(Sheets.f_110739_, new ResourceLocation("waystones", "entity/portstone"));
    private static ItemStack warpStoneItem;
    private final PortstoneModel model;

    public PortstoneRenderer(BlockEntityRendererProvider.Context context) {
        this.model = new PortstoneModel(context.m_173582_(ModRenderers.portstoneModel));
    }

    public void render(PortstoneBlockEntity tileEntity, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        Level world = tileEntity.m_58904_();
        BlockState state = tileEntity.m_58900_();
        if (world == null || state.m_61143_((Property)PortstoneBlock.HALF) != DoubleBlockHalf.LOWER) {
            return;
        }
        Direction facing = (Direction)state.m_61143_((Property)PortstoneBlock.FACING);
        if (warpStoneItem == null) {
            warpStoneItem = new ItemStack((ItemLike)ModItems.warpStone);
            warpStoneItem.m_41663_(Enchantments.f_44986_, 1);
        }
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 0.0, 0.5);
        matrixStack.m_85845_(new Quaternion(0.0f, -facing.m_122435_(), 0.0f, true));
        matrixStack.m_85845_(new Quaternion(-180.0f, 0.0f, 0.0f, true));
        matrixStack.m_85837_(0.0, -2.0, 0.0);
        float scale = 1.01f;
        matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
        matrixStack.m_85841_(scale, scale, scale);
        VertexConsumer vertexBuilder = MATERIAL.m_119194_(buffer, RenderType::m_110452_);
        int light = WaystonesConfig.getActive().disableTextGlow() ? combinedLightIn : 0xF000F0;
        int overlay = WaystonesConfig.getActive().disableTextGlow() ? combinedOverlayIn : OverlayTexture.f_118083_;
        long gameTime = world.m_46467_();
        float min = 0.7f;
        float color = (float)Math.max((double)min, (double)min + Math.abs(Math.sin((float)gameTime / 32.0f)) * (double)(1.0f - min));
        this.model.m_7695_(matrixStack, vertexBuilder, light, overlay, color, color, color, 1.0f);
        matrixStack.m_85849_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 1.0, 0.5);
        matrixStack.m_85845_(new Quaternion(0.0f, -facing.m_122435_(), 0.0f, true));
        matrixStack.m_85837_(0.0, 0.0, (double)0.15f);
        matrixStack.m_85845_(new Quaternion(-25.0f, 0.0f, 0.0f, true));
        matrixStack.m_85841_(0.5f, 0.5f, 0.5f);
        matrixStack.m_85837_(0.03125, 0.0, 0.0);
        Minecraft.m_91087_().m_91291_().m_174269_(warpStoneItem, ItemTransforms.TransformType.FIXED, combinedLightIn, combinedOverlayIn, matrixStack, buffer, 0);
        matrixStack.m_85849_();
    }
}

