/*
 * Decompiled with CFR 0.152.
 */
package com.glisco.deathlog.client;

import com.glisco.deathlog.client.DeathInfo;
import com.glisco.deathlog.death_info.SpecialPropertyProvider;
import com.glisco.deathlog.death_info.properties.CoordinatesProperty;
import com.glisco.deathlog.death_info.properties.InventoryProperty;
import com.glisco.deathlog.death_info.properties.LocationProperty;
import com.glisco.deathlog.death_info.properties.ScoreProperty;
import com.glisco.deathlog.death_info.properties.StringProperty;
import com.glisco.deathlog.mixin.MinecraftServerAccessor;
import com.glisco.deathlog.network.DeathLogPackets;
import com.glisco.deathlog.storage.BaseDeathLogStorage;
import com.glisco.deathlog.storage.DeathInfoCreatedCallback;
import com.glisco.deathlog.storage.SingletonDeathLogStorage;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;

public class ClientDeathLogStorage
extends BaseDeathLogStorage
implements SingletonDeathLogStorage {
    private final List<DeathInfo> deathInfos = new ArrayList<DeathInfo>();
    private final File deathLogFile = FabricLoader.getInstance().getGameDir().resolve("deaths.dat").toFile();

    public ClientDeathLogStorage() {
        this.load(this.deathLogFile, this.deathInfos);
    }

    @Override
    public List<DeathInfo> getDeathInfoList(@Nullable UUID profile) {
        return this.deathInfos;
    }

    @Override
    public void delete(DeathInfo info, @Nullable UUID profile) {
        this.deathInfos.remove(info);
        this.save(this.deathLogFile, this.deathInfos);
    }

    @Override
    public void store(class_2561 deathMessage, class_1657 player) {
        DeathInfo deathInfo = new DeathInfo();
        class_310 client = class_310.method_1551();
        deathInfo.setProperty("inventory", new InventoryProperty(player.method_31548()));
        deathInfo.setProperty("coordinates", new CoordinatesProperty(player.method_24515()));
        deathInfo.setProperty("dimension", new StringProperty("deathlog.deathinfoproperty.dimension", player.field_6002.method_27983().method_29177().toString()));
        if (client.method_1542()) {
            deathInfo.setProperty("location", new LocationProperty(((MinecraftServerAccessor)client.method_1576()).deathlog_getSession().method_27005(), false));
        } else {
            deathInfo.setProperty("location", new LocationProperty(client.method_1558().field_3752, true));
        }
        deathInfo.setProperty("score", new ScoreProperty(player.method_7272(), player.field_7520, player.field_7510, player.field_7495));
        deathInfo.setProperty("death_message", new StringProperty("deathlog.deathinfoproperty.death_message", deathMessage.getString()));
        deathInfo.setProperty("time_of_death", new StringProperty("deathlog.deathinfoproperty.time_of_death", new Date().toString()));
        SpecialPropertyProvider.apply(deathInfo, player);
        ((DeathInfoCreatedCallback)DeathInfoCreatedCallback.EVENT.invoker()).event(deathInfo);
        this.deathInfos.add(deathInfo);
        this.save(this.deathLogFile, this.deathInfos);
    }

    @Override
    public void restore(int index, @Nullable UUID profile) {
        DeathLogPackets.Client.requestRestore(class_310.method_1551().field_1724.method_5667(), index);
    }

    @Override
    public String getDefaultFilter() {
        class_310 client = class_310.method_1551();
        if (client.method_1558() != null) {
            return client.method_1558().field_3752;
        }
        if (client.method_1542()) {
            return ((MinecraftServerAccessor)client.method_1576()).deathlog_getSession().method_27005();
        }
        return "";
    }
}

