/*
 * Decompiled with CFR 0.152.
 */
package L_Ender.cataclysm.entity;

import L_Ender.cataclysm.config.CMConfig;
import L_Ender.cataclysm.entity.AI.CmAttackGoal;
import L_Ender.cataclysm.entity.Boss_monster;
import L_Ender.cataclysm.entity.effect.Cm_Falling_Block_Entity;
import L_Ender.cataclysm.entity.effect.ScreenShake_Entity;
import L_Ender.cataclysm.entity.etc.CMPathNavigateGround;
import L_Ender.cataclysm.entity.etc.SmartBodyHelper2;
import L_Ender.cataclysm.init.ModEffect;
import L_Ender.cataclysm.init.ModSounds;
import L_Ender.cataclysm.init.ModTag;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class Ignis_Entity
extends Boss_monster {
    private final ServerBossEvent bossInfo = (ServerBossEvent)new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.YELLOW, BossEvent.BossBarOverlay.PROGRESS).m_7003_(false);
    public static final Animation SWING_ATTACK = Animation.create((int)95);
    public static final Animation HORIZONTAL_SWING_ATTACK = Animation.create((int)68);
    public static final Animation SHIELD_SMASH_ATTACK = Animation.create((int)70);
    public static final Animation PHASE_2 = Animation.create((int)68);
    public static final Animation POKE_ATTACK = Animation.create((int)65);
    public static final Animation POKED_ATTACK = Animation.create((int)65);
    public static final Animation PHASE = Animation.create((int)130);
    public static final Animation MAGIC_ATTACK = Animation.create((int)95);
    private static final EntityDataAccessor<Boolean> IS_BLOCKING = SynchedEntityData.m_135353_(Ignis_Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_SHIELD = SynchedEntityData.m_135353_(Ignis_Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> BOSS_PHASE = SynchedEntityData.m_135353_(Ignis_Entity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int timeWithoutTarget;
    public float blockingProgress;
    public float prevblockingProgress;

    public Ignis_Entity(EntityType entity, Level world) {
        super(entity, world);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.LAVA, 8.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, SWING_ATTACK, HORIZONTAL_SWING_ATTACK, POKE_ATTACK, POKED_ATTACK, MAGIC_ATTACK, PHASE, SHIELD_SMASH_ATTACK, PHASE_2};
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(2, (Goal)new CmAttackGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new Hornzontal_Swing());
        this.f_21345_.m_25352_(1, (Goal)new Poke());
        this.f_21345_.m_25352_(1, (Goal)new Phase_Transition());
        this.f_21345_.m_25352_(1, (Goal)new Shield_Smash());
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
    }

    @Override
    public boolean m_6469_(DamageSource source, float damage) {
        double range = this.calculateRange(source);
        if (range > CMConfig.IgnisLongRangelimit * CMConfig.IgnisLongRangelimit) {
            return false;
        }
        if (!source.m_19378_()) {
            damage = Math.min((float)CMConfig.IgnisDamageCap, damage);
        }
        if (this.getAnimation() == PHASE_2 && !source.m_19378_()) {
            return false;
        }
        Entity entity = source.m_7640_();
        if (damage > 0.0f && this.canBlockDamageSource(source)) {
            this.m_7909_(damage);
            if (!source.m_19360_() && entity instanceof LivingEntity) {
                this.m_6728_((LivingEntity)entity);
            }
            this.m_5496_(SoundEvents.f_11704_, 0.5f, 0.4f + this.m_21187_().nextFloat() * 0.1f);
            return false;
        }
        return super.m_6469_(source, damage);
    }

    private boolean canBlockDamageSource(DamageSource damageSourceIn) {
        Vec3 vector3d2;
        AbstractArrow abstractarrowentity;
        Entity entity = damageSourceIn.m_7640_();
        boolean flag = false;
        if (entity instanceof AbstractArrow && (abstractarrowentity = (AbstractArrow)entity).m_36796_() > 0) {
            flag = true;
        }
        if (!damageSourceIn.m_19376_() && !flag && this.getIsShield() && (vector3d2 = damageSourceIn.m_7270_()) != null) {
            Vec3 vector3d = this.m_20252_(1.0f);
            Vec3 vector3d1 = vector3d2.m_82505_(this.m_20182_()).m_82541_();
            vector3d1 = new Vec3(vector3d1.f_82479_, 0.0, vector3d1.f_82481_);
            return vector3d1.m_82526_(vector3d) < 0.0;
        }
        return false;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_BLOCKING, (Object)false);
        this.f_19804_.m_135372_(IS_SHIELD, (Object)false);
        this.f_19804_.m_135372_(BOSS_PHASE, (Object)0);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("BossPhase", this.getBossPhase());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setBossPhase(compound.m_128451_("BossPhase"));
        if (this.m_8077_()) {
            this.bossInfo.m_6456_(this.m_5446_());
        }
    }

    public void setIsBlocking(boolean isBlocking) {
        this.f_19804_.m_135381_(IS_BLOCKING, (Object)isBlocking);
    }

    public boolean getIsBlocking() {
        return (Boolean)this.f_19804_.m_135370_(IS_BLOCKING);
    }

    public void setIsShield(boolean isShield) {
        this.f_19804_.m_135381_(IS_SHIELD, (Object)isShield);
    }

    public boolean getIsShield() {
        return (Boolean)this.f_19804_.m_135370_(IS_SHIELD);
    }

    public void setBossPhase(int bossPhase) {
        this.f_19804_.m_135381_(BOSS_PHASE, (Object)bossPhase);
    }

    public int getBossPhase() {
        return (Integer)this.f_19804_.m_135370_(BOSS_PHASE);
    }

    public static AttributeSupplier.Builder ignis() {
        return Monster.m_33035_().m_22268_(Attributes.f_22277_, 50.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22281_, CMConfig.IgnisDamage).m_22268_(Attributes.f_22276_, CMConfig.IgnisHealth).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    public float m_6073_() {
        return 1.0f;
    }

    protected int m_7302_(int air) {
        return air;
    }

    public boolean m_142535_(float p_148711_, float p_148712_, DamageSource p_148713_) {
        return false;
    }

    public void m_8119_() {
        if (!this.f_19861_ && this.m_20184_().f_82480_ < 0.0 && this.getAnimation() == NO_ANIMATION) {
            this.m_20256_(this.m_20184_().m_82542_(1.0, 0.6, 1.0));
        }
        if (!this.m_20197_().isEmpty() && ((Entity)this.m_20197_().get(0)).m_6144_()) {
            ((Entity)this.m_20197_().get(0)).m_20260_(false);
        }
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
        this.prevblockingProgress = this.blockingProgress;
        if (this.getIsBlocking() && this.blockingProgress < 10.0f) {
            this.blockingProgress += 1.0f;
        }
        if (!this.getIsBlocking() && this.blockingProgress > 0.0f) {
            this.blockingProgress -= 1.0f;
        }
        LivingEntity target = this.m_5448_();
        if (this.f_19853_.f_46443_) {
            if (this.f_19796_.nextInt(24) == 0 && !this.m_20067_()) {
                this.f_19853_.m_7785_(this.m_20185_() + 0.5, this.m_20186_() + 0.5, this.m_20189_() + 0.5, SoundEvents.f_11702_, this.m_5720_(), 1.0f + this.f_19796_.nextFloat(), this.f_19796_.nextFloat() * 0.7f + 0.3f, false);
            }
            for (int i = 0; i < 2; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123755_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
            }
        } else {
            ++this.timeWithoutTarget;
            if (target != null) {
                this.timeWithoutTarget = 0;
                if (!this.getIsBlocking()) {
                    this.setIsBlocking(true);
                }
            }
            if (this.timeWithoutTarget > 150 && this.getIsBlocking() && target == null) {
                this.timeWithoutTarget = 0;
                this.setIsBlocking(false);
            }
            if (this.getBossPhase() > 0) {
                this.bossInfo.m_6451_(BossEvent.BossBarColor.BLUE);
            }
        }
        this.repelEntities(1.7f, 4.0f, 1.7f, 1.7f);
        this.m_146922_(this.f_20883_);
        if (this.m_6084_()) {
            if (!this.m_21525_() && this.getAnimation() == NO_ANIMATION && this.m_21223_() <= this.m_21233_() / 2.0f && this.getBossPhase() < 1) {
                this.setAnimation(PHASE_2);
            } else if (target != null && target.m_6084_() && !this.m_21525_() && this.getAnimation() == NO_ANIMATION && this.m_20270_((Entity)target) < 5.0f) {
                if (this.f_19796_.nextInt(2) == 0) {
                    this.setAnimation(SHIELD_SMASH_ATTACK);
                } else {
                    this.setAnimation(HORIZONTAL_SWING_ATTACK);
                }
            }
        }
        super.m_8119_();
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        if (this.getIsBlocking() && this.blockingProgress == 10.0f) {
            if (this.getAnimation() == NO_ANIMATION) {
                this.setIsShield(true);
            } else if (this.getAnimation() == HORIZONTAL_SWING_ATTACK) {
                this.setIsShield(this.getAnimationTick() > 31);
            }
        } else {
            this.setIsShield(false);
        }
        if (this.getAnimation() == HORIZONTAL_SWING_ATTACK && this.getAnimationTick() == 31) {
            this.m_5496_((SoundEvent)ModSounds.STRONGSWING.get(), 1.0f, 1.0f + this.m_21187_().nextFloat() * 0.1f);
            this.AreaAttack(6.0f, 6.0f, 250.0f, 1.1f, 0.08f, 100, 5, 300);
        }
        if (this.getAnimation() == PHASE_2) {
            if (this.getAnimationTick() == 29) {
                this.m_5496_((SoundEvent)ModSounds.FLAME_BURST.get(), 1.0f, 1.0f + this.m_21187_().nextFloat() * 0.1f);
            }
            if (this.getAnimationTick() > 29 && this.getAnimationTick() < 39) {
                this.Sphereparticle(2.0f, 5.0f);
            }
            if (this.getAnimationTick() == 34) {
                this.setBossPhase(1);
            }
        }
        if (this.getAnimation() == SHIELD_SMASH_ATTACK) {
            if (this.getAnimationTick() == 34) {
                this.m_5496_(SoundEvents.f_12513_, 1.5f, 0.8f + this.m_21187_().nextFloat() * 0.1f);
                ScreenShake_Entity.ScreenShake(this.f_19853_, this.m_20182_(), 20.0f, 0.3f, 0, 10);
                this.AreaAttack(4.85f, 2.5f, 45.0f, 1.5f, 0.15f, 200, 0, 0);
                this.ShieldSmashDamage(4, 2.75f);
                this.ShieldSmashparticle(2.75f, -0.1f);
            }
            if (this.getAnimationTick() == 37) {
                this.ShieldSmashDamage(5, 2.75f);
            }
            if (this.getAnimationTick() == 40) {
                this.ShieldSmashDamage(6, 2.75f);
            }
        }
        if (this.getAnimation() == POKE_ATTACK && this.getAnimationTick() == 39) {
            this.Poke(7.0f, 50.0f);
        }
    }

    public void setMaxHealth(double maxHealth, boolean heal) {
        this.m_21051_(Attributes.f_22276_).m_22100_(maxHealth);
        if (heal) {
            this.m_5634_((float)maxHealth);
        }
    }

    private void AreaAttack(float range, float height, float arc, float damage, float hpdamage, int shieldbreakticks, int firetime, int brandticks) {
        List<LivingEntity> entitiesHit = this.getEntityLivingBaseNearby(range, height, range, range);
        for (LivingEntity entityHit : entitiesHit) {
            float entityHitAngle = (float)((Math.atan2(entityHit.m_20189_() - this.m_20189_(), entityHit.m_20185_() - this.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.f_20883_ % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            float entityHitDistance = (float)Math.sqrt((entityHit.m_20189_() - this.m_20189_()) * (entityHit.m_20189_() - this.m_20189_()) + (entityHit.m_20185_() - this.m_20185_()) * (entityHit.m_20185_() - this.m_20185_()));
            if (!(entityHitDistance <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f) && !(entityRelativeAngle <= -360.0f + arc / 2.0f) || entityHit instanceof Ignis_Entity) continue;
            boolean flag = entityHit.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)(this.m_21133_(Attributes.f_22281_) * (double)damage + (double)(entityHit.m_21233_() * hpdamage)));
            if (entityHit instanceof Player && entityHit.m_21254_() && shieldbreakticks > 0) {
                Ignis_Entity.disableShield(entityHit, shieldbreakticks);
            }
            if (!flag) continue;
            entityHit.m_20254_(firetime);
            if (brandticks <= 0) continue;
            MobEffectInstance effectinstance1 = entityHit.m_21124_((MobEffect)ModEffect.EFFECTBLAZING_BRAND.get());
            int i = 1;
            if (effectinstance1 != null) {
                i += effectinstance1.m_19564_();
                entityHit.m_6234_((MobEffect)ModEffect.EFFECTBLAZING_BRAND.get());
            } else {
                --i;
            }
            i = Mth.m_14045_((int)i, (int)0, (int)4);
            MobEffectInstance effectinstance = new MobEffectInstance((MobEffect)ModEffect.EFFECTBLAZING_BRAND.get(), brandticks, i, false, false, true);
            entityHit.m_7292_(effectinstance);
            this.m_5634_(10 * (i + 1));
        }
    }

    private void Poke(float range, float arc) {
        LivingEntity target = this.m_5448_();
        if (target != null) {
            boolean flag;
            float entityHitAngle = (float)((Math.atan2(target.m_20189_() - this.m_20189_(), target.m_20185_() - this.m_20185_()) * 57.29577951308232 - 90.0) % 360.0);
            float entityAttackingAngle = this.f_20883_ % 360.0f;
            if (entityHitAngle < 0.0f) {
                entityHitAngle += 360.0f;
            }
            if (entityAttackingAngle < 0.0f) {
                entityAttackingAngle += 360.0f;
            }
            float entityRelativeAngle = entityHitAngle - entityAttackingAngle;
            if ((this.m_20270_((Entity)target) <= range && entityRelativeAngle <= arc / 2.0f && entityRelativeAngle >= -arc / 2.0f || entityRelativeAngle >= 360.0f - arc / 2.0f || entityRelativeAngle <= -360.0f + arc / 2.0f) && (flag = target.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_) + target.m_21233_() * 0.1f))) {
                target.m_7998_((Entity)this, true);
                AnimationHandler.INSTANCE.sendAnimationMessage((Entity)this, POKED_ATTACK);
            }
        }
    }

    private void ShieldSmashparticle(float vec, float math) {
        if (this.f_19853_.f_46443_) {
            for (int i1 = 0; i1 < 80 + this.f_19796_.nextInt(12); ++i1) {
                double motionX = this.m_21187_().nextGaussian() * 0.07;
                double motionY = this.m_21187_().nextGaussian() * 0.07;
                double motionZ = this.m_21187_().nextGaussian() * 0.07;
                float angle = (float)Math.PI / 180 * this.f_20883_ + (float)i1;
                float f = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                float f1 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
                double extraX = 1.3 * (double)Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
                double extraY = 0.3f;
                double extraZ = 1.3 * (double)Mth.m_14089_((float)angle);
                double theta = (double)this.f_20883_ * (Math.PI / 180);
                double vecX = Math.cos(theta += 1.5707963267948966);
                double vecZ = Math.sin(theta);
                int hitX = Mth.m_14107_((double)(this.m_20185_() + (double)vec * vecX + extraX));
                int hitY = Mth.m_14107_((double)this.m_20186_());
                int hitZ = Mth.m_14107_((double)(this.m_20189_() + (double)vec * vecZ + extraZ));
                BlockPos hit = new BlockPos(hitX, hitY, hitZ);
                BlockState block = this.f_19853_.m_8055_(hit.m_7495_());
                this.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, block), this.m_20185_() + (double)vec * vecX + extraX + (double)(f * math), this.m_20186_() + extraY, this.m_20189_() + (double)vec * vecZ + extraZ + (double)(f1 * math), motionX, motionY, motionZ);
            }
        }
    }

    private void ShieldSmashDamage(int distance, float vec) {
        double perpFacing = (double)this.f_20883_ * (Math.PI / 180);
        double facingAngle = perpFacing + 1.5707963267948966;
        int hitY = Mth.m_14107_((double)(this.m_142469_().f_82289_ - 0.5));
        double spread = Math.PI * 2;
        int arcLen = Mth.m_14165_((double)((double)distance * spread));
        double minY = this.m_20186_() - 1.0;
        double maxY = this.m_20186_() + 1.5;
        for (int i = 0; i < arcLen; ++i) {
            double theta = ((double)i / ((double)arcLen - 1.0) - 0.5) * spread + facingAngle;
            double vx = Math.cos(theta);
            double vz = Math.sin(theta);
            double px = this.m_20185_() + vx * (double)distance + (double)vec * Math.cos((double)(this.f_20883_ + 90.0f) * Math.PI / 180.0);
            double pz = this.m_20189_() + vz * (double)distance + (double)vec * Math.sin((double)(this.f_20883_ + 90.0f) * Math.PI / 180.0);
            if (!this.f_19853_.f_46443_) {
                int hitX = Mth.m_14107_((double)px);
                int hitZ = Mth.m_14107_((double)pz);
                BlockPos pos = new BlockPos(hitX, hitY, hitZ);
                BlockPos abovePos = new BlockPos((Vec3i)pos).m_7494_();
                BlockState block = this.f_19853_.m_8055_(pos);
                BlockState blockAbove = this.f_19853_.m_8055_(abovePos);
                if (!(block.m_60767_() == Material.f_76296_ || block.m_155947_() || blockAbove.m_60767_().m_76334_() || block.m_204336_(ModTag.NETHERITE_MONSTROSITY_IMMUNE))) {
                    Cm_Falling_Block_Entity fallingBlockEntity = new Cm_Falling_Block_Entity(this.f_19853_, (double)hitX + 0.5, (double)hitY + 0.5, (double)hitZ + 0.5, block);
                    this.f_19853_.m_7731_(pos, block.m_60819_().m_76188_(), 3);
                    fallingBlockEntity.m_5997_(0.0, 0.2 + this.m_21187_().nextGaussian() * 0.15, 0.0);
                    this.f_19853_.m_7967_((Entity)fallingBlockEntity);
                }
            }
            AABB selection = new AABB(px - 0.5, minY, pz - 0.5, px + 0.5, maxY, pz + 0.5);
            List hit = this.f_19853_.m_45976_(LivingEntity.class, selection);
            for (LivingEntity entity : hit) {
                boolean flag;
                if (this.m_7307_((Entity)entity) || entity instanceof Ignis_Entity || entity == this || !(flag = entity.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)this.m_21133_(Attributes.f_22281_)))) continue;
                double airborne = 0.1 * (double)distance + this.f_19853_.f_46441_.nextDouble() * 0.15;
                entity.m_20256_(entity.m_20184_().m_82520_(0.0, airborne, 0.0));
            }
        }
    }

    private void Sphereparticle(float height, float size) {
        if (this.f_19853_.f_46443_ && this.f_19797_ % 2 == 0) {
            double d0 = this.m_20185_();
            double d1 = this.m_20186_() + (double)height;
            double d2 = this.m_20189_();
            for (float i = -size; i <= size; i += 1.0f) {
                for (float j = -size; j <= size; j += 1.0f) {
                    for (float k = -size; k <= size; k += 1.0f) {
                        double d3 = (double)j + (this.f_19796_.nextDouble() - this.f_19796_.nextDouble()) * 0.5;
                        double d4 = (double)i + (this.f_19796_.nextDouble() - this.f_19796_.nextDouble()) * 0.5;
                        double d5 = (double)k + (this.f_19796_.nextDouble() - this.f_19796_.nextDouble()) * 0.5;
                        double d6 = (double)Mth.m_14116_((float)((float)(d3 * d3 + d4 * d4 + d5 * d5))) / 0.5 + this.f_19796_.nextGaussian() * 0.05;
                        if (this.getBossPhase() == 0) {
                            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, d0, d1, d2, d3 / d6, d4 / d6, d5 / d6);
                        } else {
                            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123745_, d0, d1, d2, d3 / d6, d4 / d6, d5 / d6);
                        }
                        if (i == -size || i == size || j == -size || j == size) continue;
                        k += size * 2.0f - 1.0f;
                    }
                }
            }
        }
    }

    public void m_7332_(Entity passenger) {
        super.m_7332_(passenger);
        if (this.m_20363_(passenger)) {
            int tick = 5;
            if (this.getAnimation() == POKED_ATTACK) {
                tick = this.getAnimationTick();
                if (this.getAnimationTick() == 46) {
                    passenger.m_8127_();
                }
                this.m_146922_(this.f_19859_);
            }
            float radius = 4.0f;
            float math = 0.175f;
            float angle = (float)Math.PI / 180 * this.f_20883_;
            float f = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            float f1 = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * Mth.m_14089_((float)angle);
            double extraY = tick < 10 ? 0.0 : (double)(0.2f * (float)Mth.m_14045_((int)(tick - 10), (int)0, (int)15));
            passenger.m_6034_(this.m_20185_() + (double)(f * math) + extraX, this.m_20186_() + extraY + (double)1.2f, this.m_20189_() + (double)(f1 * math) + extraZ);
            if ((tick - 10) % 4 == 0) {
                passenger.m_6469_(DamageSource.m_19370_((LivingEntity)this), 3.0f);
            }
        }
    }

    public boolean canRiderInteract() {
        return true;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    @Override
    protected void repelEntities(float x, float y, float z, float radius) {
        super.repelEntities(x, y, z, radius);
    }

    @Override
    public boolean canBePushedByEntity(Entity entity) {
        return false;
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        this.setMaxHealth(CMConfig.IgnisHealth, true);
        this.m_21051_(Attributes.f_22281_).m_22100_(CMConfig.IgnisDamage);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public void m_7023_(Vec3 travelVector) {
        this.m_7910_((float)this.m_21133_(Attributes.f_22279_) * (this.m_20077_() ? 0.2f : 1.0f));
        if (this.getAnimation() == POKED_ATTACK) {
            if (this.m_21573_().m_26570_() != null) {
                this.m_21573_().m_26573_();
            }
            travelVector = Vec3.f_82478_;
            super.m_7023_(travelVector);
            return;
        }
        super.m_7023_(travelVector);
    }

    protected BodyRotationControl m_7560_() {
        return new SmartBodyHelper2((Mob)this);
    }

    protected PathNavigation m_6037_(Level worldIn) {
        return new CMPathNavigateGround((Mob)this, worldIn);
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
    }

    class Hornzontal_Swing
    extends Goal {
        public Hornzontal_Swing() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return Ignis_Entity.this.getAnimation() == HORIZONTAL_SWING_ATTACK;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity target = Ignis_Entity.this.m_5448_();
            if (Ignis_Entity.this.getAnimationTick() < 31 && target != null || Ignis_Entity.this.getAnimationTick() > 51 && target != null) {
                Ignis_Entity.this.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            } else {
                Ignis_Entity.this.m_146922_(Ignis_Entity.this.f_19859_);
            }
            if (Ignis_Entity.this.getAnimationTick() == 26) {
                float f1 = (float)Math.cos(Math.toRadians(Ignis_Entity.this.m_146908_() + 90.0f));
                float f2 = (float)Math.sin(Math.toRadians(Ignis_Entity.this.m_146908_() + 90.0f));
                if (target != null) {
                    float r = Ignis_Entity.this.m_20270_((Entity)target);
                    r = Mth.m_14036_((float)r, (float)0.0f, (float)15.0f);
                    Ignis_Entity.this.m_5997_((double)f1 * 0.3 * (double)r, 0.0, (double)f2 * 0.3 * (double)r);
                } else {
                    Ignis_Entity.this.m_5997_(f1, 0.0, f2);
                }
            }
            if (Ignis_Entity.this.getAnimationTick() > 32 || Ignis_Entity.this.getAnimationTick() < 26) {
                Ignis_Entity.this.m_20334_(0.0, Ignis_Entity.this.m_20184_().f_82480_, 0.0);
            }
        }
    }

    class Poke
    extends Goal {
        public Poke() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return Ignis_Entity.this.getAnimation() == POKE_ATTACK;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity target = Ignis_Entity.this.m_5448_();
            if (Ignis_Entity.this.getAnimationTick() < 39 && target != null || Ignis_Entity.this.getAnimationTick() > 59 && target != null) {
                Ignis_Entity.this.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            } else {
                Ignis_Entity.this.m_146922_(Ignis_Entity.this.f_19859_);
            }
            if (Ignis_Entity.this.getAnimationTick() == 34) {
                float f1 = (float)Math.cos(Math.toRadians(Ignis_Entity.this.m_146908_() + 90.0f));
                float f2 = (float)Math.sin(Math.toRadians(Ignis_Entity.this.m_146908_() + 90.0f));
                if (target != null) {
                    float r = Ignis_Entity.this.m_20270_((Entity)target);
                    r = Mth.m_14036_((float)r, (float)0.0f, (float)5.0f);
                    Ignis_Entity.this.m_5997_((double)f1 * 0.3 * (double)r, 0.0, (double)f2 * 0.3 * (double)r);
                } else {
                    Ignis_Entity.this.m_5997_((double)f1 * 1.5, 0.0, (double)f2 * 1.5);
                }
            }
            if (Ignis_Entity.this.getAnimationTick() > 40 || Ignis_Entity.this.getAnimationTick() < 34) {
                Ignis_Entity.this.m_20334_(0.0, Ignis_Entity.this.m_20184_().f_82480_, 0.0);
            }
        }
    }

    class Phase_Transition
    extends Goal {
        public Phase_Transition() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return Ignis_Entity.this.getAnimation() == PHASE_2;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity target = Ignis_Entity.this.m_5448_();
            if (Ignis_Entity.this.getAnimationTick() < 34 && target != null || Ignis_Entity.this.getAnimationTick() > 54 && target != null) {
                Ignis_Entity.this.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            } else {
                Ignis_Entity.this.m_146922_(Ignis_Entity.this.f_19859_);
            }
            Ignis_Entity.this.m_20334_(0.0, Ignis_Entity.this.m_20184_().f_82480_, 0.0);
        }
    }

    class Shield_Smash
    extends Goal {
        public Shield_Smash() {
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.LOOK, Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return Ignis_Entity.this.getAnimation() == SHIELD_SMASH_ATTACK;
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8037_() {
            LivingEntity target = Ignis_Entity.this.m_5448_();
            if (Ignis_Entity.this.getAnimationTick() < 34 && target != null) {
                Ignis_Entity.this.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
            } else {
                Ignis_Entity.this.m_146922_(Ignis_Entity.this.f_19859_);
            }
            Ignis_Entity.this.m_20334_(0.0, Ignis_Entity.this.m_20184_().f_82480_, 0.0);
        }
    }
}

