/*
 * Decompiled with CFR 0.152.
 */
package L_Ender.cataclysm.tileentities;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class TileEntityBossSpawner<T extends Mob>
extends BlockEntity {
    protected static final int SHORT_RANGE = 6;
    protected static final int LONG_RANGE = 50;
    protected final EntityType<T> entityType;
    protected boolean spawnedBoss = false;

    protected TileEntityBossSpawner(BlockEntityType<?> type, EntityType<T> entityType, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.entityType = entityType;
    }

    public static void commonTick(Level level, BlockPos pos, BlockState state, TileEntityBossSpawner entity) {
        entity.tick(level, pos, state, entity);
    }

    public boolean anyPlayerInRange() {
        return this.f_58857_.m_45914_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, (double)this.getRange());
    }

    public void tick(Level level, BlockPos pos, BlockState state, TileEntityBossSpawner<?> te) {
        if (this.spawnedBoss || !this.anyPlayerInRange()) {
            return;
        }
        if (level.f_46443_) {
            double rx = (float)pos.m_123341_() - 0.2f + level.f_46441_.nextFloat() * 1.25f;
            double ry = (float)pos.m_123342_() - 0.2f + level.f_46441_.nextFloat() * 1.25f;
            double rz = (float)pos.m_123343_() - 0.2f + level.f_46441_.nextFloat() * 1.25f;
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, rx, ry, rz, 0.0, 0.0, 0.0);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123744_, rx, ry, rz, 0.0, 0.0, 0.0);
        } else if (level.m_46791_() != Difficulty.PEACEFUL && this.spawnMyBoss((ServerLevelAccessor)((ServerLevel)level))) {
            level.m_46961_(pos, false);
            this.spawnedBoss = true;
        }
    }

    protected boolean spawnMyBoss(ServerLevelAccessor world) {
        T myCreature = this.makeMyCreature();
        myCreature.m_20035_(this.f_58858_, world.m_6018_().f_46441_.nextFloat() * 360.0f, 0.0f);
        myCreature.m_6518_(world, world.m_6436_(this.f_58858_), MobSpawnType.SPAWNER, null, null);
        this.initializeCreature(myCreature);
        return world.m_7967_(myCreature);
    }

    protected void initializeCreature(T myCreature) {
        myCreature.m_21446_(this.f_58858_, 46);
    }

    protected int getRange() {
        return 6;
    }

    protected T makeMyCreature() {
        return (T)((Mob)this.entityType.m_20615_(this.f_58857_));
    }
}

