/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.block.dock;

import dev.murad.shipping.block.dock.AbstractDockTileEntity;
import dev.murad.shipping.block.dock.AbstractTailDockTileEntity;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class DockingBlockStates {
    public static final BooleanProperty INVERTED = BlockStateProperties.f_61441_;
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    public static Optional<AbstractDockTileEntity<?>> getTileEntity(Level world, BlockPos pos) {
        BlockEntity tileEntity = world.m_7702_(pos);
        if (tileEntity instanceof AbstractDockTileEntity) {
            return Optional.of((AbstractDockTileEntity)tileEntity);
        }
        return Optional.empty();
    }

    public static void fixHopperPos(BlockState state, Level world, BlockPos p_220069_3_, Direction targetLoc, Direction targetDir) {
        DockingBlockStates.getTileEntity(world, p_220069_3_).filter(DockingBlockStates::isImport).flatMap(dock -> dock.getHopper(p_220069_3_.m_142300_(targetLoc))).ifPresent(te -> {
            if (((Direction)te.m_58900_().m_61143_((Property)HopperBlock.f_54021_)).equals((Object)Direction.DOWN)) {
                world.m_7731_(te.m_58899_(), (BlockState)te.m_58900_().m_61124_((Property)HopperBlock.f_54021_, (Comparable)targetDir), 2);
            }
        });
    }

    private static boolean isImport(AbstractDockTileEntity<?> dock) {
        if (dock instanceof AbstractTailDockTileEntity) {
            return (Boolean)dock.m_58900_().m_61143_((Property)INVERTED) == false;
        }
        return true;
    }
}

