/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.entity.accessor;

import dev.murad.shipping.entity.accessor.DataAccessor;
import dev.murad.shipping.entity.accessor.SupplierIntArray;
import java.util.function.BooleanSupplier;
import java.util.function.IntSupplier;
import net.minecraft.world.inventory.ContainerData;

public class EnergyTugDataAccessor
extends DataAccessor {
    private static final int SHORT_MASK = 65535;

    public EnergyTugDataAccessor(ContainerData data) {
        super(data);
    }

    public int getEnergy() {
        int lo = this.data.m_6413_(1) & 0xFFFF;
        int hi = this.data.m_6413_(2) & 0xFFFF;
        return lo | hi << 16;
    }

    public int getCapacity() {
        int lo = this.data.m_6413_(3) & 0xFFFF;
        int hi = this.data.m_6413_(4) & 0xFFFF;
        return lo | hi << 16;
    }

    public boolean isLit() {
        return this.data.m_6413_(5) == 1;
    }

    public static class Builder {
        SupplierIntArray arr = new SupplierIntArray(6);

        public Builder(int uuid) {
            this.arr.m_8050_(0, uuid);
        }

        public Builder withEnergy(IntSupplier energy) {
            this.arr.setSupplier(1, () -> energy.getAsInt() & 0xFFFF);
            this.arr.setSupplier(2, () -> energy.getAsInt() >> 16 & 0xFFFF);
            return this;
        }

        public Builder withCapacity(IntSupplier capacity) {
            this.arr.setSupplier(3, () -> capacity.getAsInt() & 0xFFFF);
            this.arr.setSupplier(4, () -> capacity.getAsInt() >> 16 & 0xFFFF);
            return this;
        }

        public Builder withLit(BooleanSupplier lit) {
            this.arr.setSupplier(5, () -> lit.getAsBoolean() ? 1 : -1);
            return this;
        }

        public EnergyTugDataAccessor build() {
            return new EnergyTugDataAccessor(this.arr);
        }
    }
}

