/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.entity.custom.barge;

import dev.murad.shipping.capability.StallingCapability;
import dev.murad.shipping.entity.custom.SpringEntity;
import dev.murad.shipping.entity.custom.VesselEntity;
import dev.murad.shipping.entity.custom.tug.AbstractTugEntity;
import dev.murad.shipping.util.Train;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.NetworkHooks;

public abstract class AbstractBargeEntity
extends VesselEntity {
    private final StallingCapability capability = new StallingCapability(){

        @Override
        public boolean isDocked() {
            return this.delegate().map(StallingCapability::isDocked).orElse(false);
        }

        @Override
        public void dock(double x, double y, double z) {
            this.delegate().ifPresent(s -> s.dock(x, y, z));
        }

        @Override
        public void undock() {
            this.delegate().ifPresent(StallingCapability::undock);
        }

        @Override
        public boolean isStalled() {
            return this.delegate().map(StallingCapability::isStalled).orElse(false);
        }

        @Override
        public void stall() {
            this.delegate().ifPresent(StallingCapability::stall);
        }

        @Override
        public void unstall() {
            this.delegate().ifPresent(StallingCapability::unstall);
        }

        @Override
        public boolean isFrozen() {
            return AbstractBargeEntity.super.isFrozen();
        }

        @Override
        public void freeze() {
            AbstractBargeEntity.super.setFrozen(true);
        }

        @Override
        public void unfreeze() {
            AbstractBargeEntity.super.setFrozen(false);
        }

        private Optional<StallingCapability> delegate() {
            Object v = AbstractBargeEntity.this.train.getHead();
            if (v instanceof AbstractTugEntity) {
                AbstractTugEntity e = (AbstractTugEntity)v;
                return e.getCapability(StallingCapability.STALLING_CAPABILITY).resolve();
            }
            return Optional.empty();
        }
    };
    private final LazyOptional<StallingCapability> capabilityOpt = LazyOptional.of(() -> this.capability);

    public AbstractBargeEntity(EntityType<? extends AbstractBargeEntity> type, Level world) {
        super(type, world);
        this.f_19850_ = true;
        this.train = new Train<AbstractBargeEntity>(this);
    }

    public AbstractBargeEntity(EntityType<? extends AbstractBargeEntity> type, Level worldIn, double x, double y, double z) {
        this(type, worldIn);
        this.m_6034_(x, y, z);
        this.m_20256_(Vec3.f_82478_);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    protected boolean m_7310_(Entity passenger) {
        return false;
    }

    @Nonnull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @Override
    public abstract Item getDropItem();

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (!this.f_19853_.f_46443_) {
            this.doInteract(player);
        }
        return InteractionResult.CONSUME;
    }

    protected abstract void doInteract(Player var1);

    public boolean m_6469_(DamageSource p_70097_1_, float p_70097_2_) {
        if (this.m_6673_(p_70097_1_)) {
            return false;
        }
        if (!this.f_19853_.f_46443_ && !this.f_20890_) {
            this.m_19998_((ItemLike)this.getDropItem());
            this.m_142687_(Entity.RemovalReason.KILLED);
            return true;
        }
        return true;
    }

    @Override
    public boolean hasWaterOnSides() {
        return this.f_19853_.m_8055_(this.m_20097_().m_142300_(this.m_6350_().m_122427_())).m_60734_().equals(Blocks.f_49990_) && this.f_19853_.m_8055_(this.m_20097_().m_142300_(this.m_6350_().m_122427_())).m_60734_().equals(Blocks.f_49990_) && this.f_19853_.m_8055_(this.m_20097_().m_7494_().m_142300_(this.m_6350_().m_122427_())).m_60734_().equals(Blocks.f_50016_) && this.f_19853_.m_8055_(this.m_20097_().m_7494_().m_142300_(this.m_6350_().m_122427_())).m_60734_().equals(Blocks.f_50016_);
    }

    @Override
    public void setDominated(VesselEntity entity) {
        this.dominated = Optional.of(entity);
    }

    @Override
    public void setDominatedSpring(SpringEntity spring) {
        this.dominatedS = Optional.of(spring);
    }

    @Override
    public void setDominant(VesselEntity entity) {
        this.setTrain(entity.getTrain());
        this.dominant = Optional.of(entity);
    }

    @Override
    public void setDominantSpring(SpringEntity spring) {
        this.dominantS = Optional.of(spring);
    }

    @Override
    public void removeDominated() {
        if (!this.m_6084_()) {
            return;
        }
        this.dominated = Optional.empty();
        this.dominatedS = Optional.empty();
        this.train.setTail(this);
    }

    @Override
    public void removeDominant() {
        if (!this.m_6084_()) {
            return;
        }
        this.dominant = Optional.empty();
        this.dominantS = Optional.empty();
        this.setTrain(new Train<AbstractBargeEntity>(this));
    }

    @Override
    public void setTrain(Train train) {
        this.train = train;
        train.setTail(this);
        this.dominated.ifPresent(dominated -> {
            if (!dominated.getTrain().equals(train)) {
                dominated.setTrain(train);
            }
        });
    }

    public void m_142687_(Entity.RemovalReason r) {
        this.handleLinkableKill();
        super.m_142687_(r);
    }

    public boolean isDockable() {
        return this.dominant.map(dom -> this.m_20280_((Entity)dom) < 1.1).orElse(true);
    }

    @Override
    public boolean allowDockInterface() {
        return this.isDockable();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap) {
        if (cap == StallingCapability.STALLING_CAPABILITY) {
            return this.capabilityOpt.cast();
        }
        return super.getCapability(cap);
    }
}

