/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.entity.custom.train;

import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import dev.murad.shipping.ShippingConfig;
import dev.murad.shipping.entity.custom.SpringEntity;
import dev.murad.shipping.entity.custom.train.locomotive.AbstractLocomotiveEntity;
import dev.murad.shipping.setup.ModItems;
import dev.murad.shipping.util.LinkableEntity;
import dev.murad.shipping.util.RailHelper;
import dev.murad.shipping.util.Train;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.extensions.IForgeAbstractMinecart;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractTrainCarEntity
extends AbstractMinecart
implements IForgeAbstractMinecart,
LinkableEntity<AbstractTrainCarEntity> {
    protected Optional<AbstractTrainCarEntity> dominant = Optional.empty();
    protected Optional<AbstractTrainCarEntity> dominated = Optional.empty();
    @Nullable
    private CompoundTag dominantNBT;
    public static final EntityDataAccessor<Integer> DOMINANT_ID = SynchedEntityData.m_135353_(AbstractTrainCarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DOMINATED_ID = SynchedEntityData.m_135353_(AbstractTrainCarEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected Train<AbstractTrainCarEntity> train;
    protected static double TRAIN_SPEED = (Double)ShippingConfig.Server.TRAIN_MAX_SPEED.get();
    protected final RailHelper railHelper;
    private boolean frozen = false;
    private static final Map<RailShape, Pair<Vec3i, Vec3i>> EXITS = (Map)Util.m_137469_((Object)Maps.newEnumMap(RailShape.class), p_38135_ -> {
        Vec3i west = Direction.WEST.m_122436_();
        Vec3i east = Direction.EAST.m_122436_();
        Vec3i north = Direction.NORTH.m_122436_();
        Vec3i south = Direction.SOUTH.m_122436_();
        Vec3i westUnder = west.m_7495_();
        Vec3i eastUnder = east.m_7495_();
        Vec3i northUnder = north.m_7495_();
        Vec3i southUnder = south.m_7495_();
        p_38135_.put(RailShape.NORTH_SOUTH, Pair.of((Object)north, (Object)south));
        p_38135_.put(RailShape.EAST_WEST, Pair.of((Object)west, (Object)east));
        p_38135_.put(RailShape.ASCENDING_EAST, Pair.of((Object)westUnder, (Object)east));
        p_38135_.put(RailShape.ASCENDING_WEST, Pair.of((Object)west, (Object)eastUnder));
        p_38135_.put(RailShape.ASCENDING_NORTH, Pair.of((Object)north, (Object)southUnder));
        p_38135_.put(RailShape.ASCENDING_SOUTH, Pair.of((Object)northUnder, (Object)south));
        p_38135_.put(RailShape.SOUTH_EAST, Pair.of((Object)south, (Object)east));
        p_38135_.put(RailShape.SOUTH_WEST, Pair.of((Object)south, (Object)west));
        p_38135_.put(RailShape.NORTH_WEST, Pair.of((Object)north, (Object)west));
        p_38135_.put(RailShape.NORTH_EAST, Pair.of((Object)north, (Object)east));
    });

    private static Pair<Vec3i, Vec3i> exits(RailShape pShape) {
        return EXITS.get(pShape);
    }

    public AbstractTrainCarEntity(EntityType<?> p_38087_, Level p_38088_) {
        super(p_38087_, p_38088_);
        this.train = new Train<AbstractTrainCarEntity>(this);
        this.railHelper = new RailHelper(this);
    }

    public AbstractTrainCarEntity(EntityType<?> p_38087_, Level level, Double aDouble, Double aDouble1, Double aDouble2) {
        super(p_38087_, level, aDouble.doubleValue(), aDouble1.doubleValue(), aDouble2.doubleValue());
        BlockPos pos = new BlockPos(aDouble.doubleValue(), aDouble1.doubleValue(), aDouble2.doubleValue());
        BlockState state = level.m_8055_(pos);
        Block block = state.m_60734_();
        if (block instanceof BaseRailBlock) {
            BaseRailBlock railBlock = (BaseRailBlock)block;
            RailShape railshape = railBlock.getRailDirection(state, (BlockGetter)this.f_19853_, pos, (AbstractMinecart)this);
            Vec3i exit = (Vec3i)RailHelper.EXITS.get(railshape).getFirst();
            this.m_146922_(RailHelper.directionFromVelocity(new Vec3((double)exit.m_123341_(), (double)exit.m_123342_(), (double)exit.m_123343_())).m_122435_());
        }
        this.train = new Train<AbstractTrainCarEntity>(this);
        this.railHelper = new RailHelper(this);
    }

    protected Optional<RailShape> getRailShape() {
        for (BlockPos pos : Arrays.asList(this.m_20097_().m_7494_(), this.m_20097_())) {
            BlockState state = this.f_19853_.m_8055_(pos);
            Block block = state.m_60734_();
            if (!(block instanceof BaseRailBlock)) continue;
            BaseRailBlock railBlock = (BaseRailBlock)block;
            return Optional.of(this.railHelper.getShape(pos));
        }
        return Optional.empty();
    }

    public boolean m_5829_() {
        return super.m_5829_();
    }

    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.dominantNBT = compound.m_128469_("dominant");
    }

    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.dominant.isPresent()) {
            this.writeNBT((Entity)this.dominant.get(), compound);
        } else if (this.dominantNBT != null) {
            compound.m_128365_(SpringEntity.SpringSide.DOMINANT.name(), (Tag)this.dominantNBT);
        }
    }

    private Optional<AbstractTrainCarEntity> tryToLoadFromNBT(CompoundTag compound) {
        try {
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            pos.m_122178_(compound.m_128451_("X"), compound.m_128451_("Y"), compound.m_128451_("Z"));
            String uuid = compound.m_128461_("UUID");
            AABB searchBox = new AABB((double)(pos.m_123341_() - 2), (double)(pos.m_123342_() - 2), (double)(pos.m_123343_() - 2), (double)(pos.m_123341_() + 2), (double)(pos.m_123342_() + 2), (double)(pos.m_123343_() + 2));
            List entities = this.f_19853_.m_6249_((Entity)this, searchBox, e -> e.m_20149_().equals(uuid));
            return entities.stream().findFirst().map(e -> (AbstractTrainCarEntity)e);
        }
        catch (Exception e2) {
            return Optional.empty();
        }
    }

    private void writeNBT(Entity entity, CompoundTag globalCompound) {
        CompoundTag compound = new CompoundTag();
        compound.m_128405_("X", (int)Math.floor(entity.m_20185_()));
        compound.m_128405_("Y", (int)Math.floor(entity.m_20186_()));
        compound.m_128405_("Z", (int)Math.floor(entity.m_20189_()));
        compound.m_128359_("UUID", entity.m_142081_().toString());
        globalCompound.m_128365_("dominant", (Tag)compound);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DOMINANT_ID, (Object)-1);
        this.m_20088_().m_135372_(DOMINATED_ID, (Object)-1);
    }

    public void m_7350_(@NotNull EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (this.f_19853_.f_46443_ && (DOMINANT_ID.equals(key) || DOMINATED_ID.equals(key))) {
            this.fetchDominantClient();
            this.fetchDominatedClient();
        }
    }

    private void fetchDominantClient() {
        Entity potential = this.f_19853_.m_6815_(((Integer)this.m_20088_().m_135370_(DOMINANT_ID)).intValue());
        if (potential instanceof AbstractTrainCarEntity) {
            AbstractTrainCarEntity t = (AbstractTrainCarEntity)potential;
            this.dominant = Optional.of(t);
        } else {
            this.dominant = Optional.empty();
        }
    }

    private void fetchDominatedClient() {
        Entity potential = this.f_19853_.m_6815_(((Integer)this.m_20088_().m_135370_(DOMINATED_ID)).intValue());
        if (potential instanceof AbstractTrainCarEntity) {
            AbstractTrainCarEntity t = (AbstractTrainCarEntity)potential;
            this.dominated = Optional.of(t);
        } else {
            this.dominated = Optional.empty();
        }
    }

    public void m_8119_() {
        this.tickLoad();
        this.tickYRot();
        float yrot = this.m_146908_();
        this.tickVanilla();
        this.m_146922_(yrot);
        if (!this.f_19853_.f_46443_) {
            this.doChainMath();
            this.enforceMaxVelocity(TRAIN_SPEED);
        }
    }

    public float getMaxCartSpeedOnRail() {
        return (float)TRAIN_SPEED;
    }

    protected void enforceMaxVelocity(double maxSpeed) {
        Vec3 vel = this.m_20184_();
        Vec3 normal = vel.m_82541_();
        if (Math.abs(vel.f_82479_) > maxSpeed) {
            this.m_20334_(normal.f_82479_ * maxSpeed, vel.f_82480_, vel.f_82481_);
            vel = this.m_20184_();
        }
        if (Math.abs(vel.f_82481_) > maxSpeed) {
            this.m_20334_(vel.f_82479_, vel.f_82480_, normal.f_82481_ * maxSpeed);
        }
    }

    public void m_7334_(Entity pEntity) {
        double d1;
        double d0;
        double d2;
        if (!(this.f_19853_.f_46443_ || pEntity.f_19794_ || this.f_19794_ || this.m_20363_(pEntity) && !this.getDominant().isPresent() || !((d2 = (d0 = pEntity.m_20185_() - this.m_20185_()) * d0 + (d1 = pEntity.m_20189_() - this.m_20189_()) * d1) >= (double)1.0E-4f))) {
            d2 = Math.sqrt(d2);
            d0 /= d2;
            d1 /= d2;
            double d3 = 1.0 / d2;
            if (d3 > 1.0) {
                d3 = 1.0;
            }
            d0 *= d3;
            d1 *= d3;
            d0 *= (double)0.1f;
            d1 *= (double)0.1f;
            d0 *= 0.5;
            d1 *= 0.5;
            if (pEntity instanceof AbstractMinecart) {
                Vec3 vec31;
                double d5;
                double d4 = pEntity.m_20185_() - this.m_20185_();
                Vec3 vec3 = new Vec3(d4, 0.0, d5 = pEntity.m_20189_() - this.m_20189_()).m_82541_();
                double d6 = Math.abs(vec3.m_82526_(vec31 = new Vec3((double)Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180))), 0.0, (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)))).m_82541_()));
                if (d6 < (double)0.8f) {
                    return;
                }
                Vec3 vec32 = this.m_20184_();
                Vec3 vec33 = pEntity.m_20184_();
                if (((AbstractMinecart)pEntity).isPoweredCart() && !this.isPoweredCart()) {
                    this.m_20256_(vec32.m_82542_(0.2, 1.0, 0.2));
                    this.m_5997_(vec33.f_82479_ - d0, 0.0, vec33.f_82481_ - d1);
                    pEntity.m_20256_(vec33.m_82542_(0.95, 1.0, 0.95));
                } else if (!((AbstractMinecart)pEntity).isPoweredCart() && this.isPoweredCart()) {
                    pEntity.m_20256_(vec33.m_82542_(0.2, 1.0, 0.2));
                    pEntity.m_5997_(vec32.f_82479_ + d0, 0.0, vec32.f_82481_ + d1);
                    this.m_20256_(vec32.m_82542_(0.95, 1.0, 0.95));
                } else {
                    double d7 = (vec33.f_82479_ + vec32.f_82479_) / 2.0;
                    double d8 = (vec33.f_82481_ + vec32.f_82481_) / 2.0;
                    this.m_20256_(vec32.m_82542_(0.2, 1.0, 0.2));
                    this.m_5997_(d7 - d0, 0.0, d8 - d1);
                    pEntity.m_20256_(vec33.m_82542_(0.2, 1.0, 0.2));
                    pEntity.m_5997_(d7 + d0, 0.0, d8 + d1);
                }
            } else {
                this.m_5997_(-d0, 0.0, -d1);
                pEntity.m_5997_(d0 / 4.0, 0.0, d1 / 4.0);
            }
        }
    }

    public BlockPos m_20097_() {
        BlockPos blockpos1;
        BlockState blockstate;
        int k;
        int j;
        Vec3 position = this.m_20182_();
        int i = Mth.m_14107_((double)position.f_82479_);
        BlockPos blockpos = new BlockPos(i, j = Mth.m_14107_((double)(position.f_82480_ - (double)0.2f)), k = Mth.m_14107_((double)position.f_82481_));
        if (this.f_19853_.m_46859_(blockpos) && (blockstate = this.f_19853_.m_8055_(blockpos1 = blockpos.m_7495_())).collisionExtendsVertically((BlockGetter)this.f_19853_, blockpos1, (Entity)this)) {
            return blockpos1;
        }
        return blockpos;
    }

    protected void tickLoad() {
        if (this.f_19853_.f_46443_) {
            this.fetchDominantClient();
            this.fetchDominatedClient();
        } else {
            if (this.dominant.isEmpty() && this.dominantNBT != null) {
                this.tryToLoadFromNBT(this.dominantNBT).ifPresent(this::setDominant);
                this.dominant.ifPresent(d -> d.setDominated(this));
            }
            this.f_19804_.m_135381_(DOMINANT_ID, (Object)this.dominant.map(Entity::m_142049_).orElse(-1));
            this.f_19804_.m_135381_(DOMINATED_ID, (Object)this.dominated.map(Entity::m_142049_).orElse(-1));
        }
    }

    protected void tickYRot() {
        this.m_146922_(this.computeYaw());
    }

    public float computeYaw() {
        float yrot = this.m_146908_();
        Optional<RailShape> railShape = this.getRailShape();
        if (this.dominated.isPresent() && railShape.isPresent()) {
            Pair<Direction, Integer> pair;
            Optional<Vec3i> directionOpt;
            Optional<Pair<Direction, Integer>> r = this.railHelper.traverseBi(this.m_20097_().m_7494_(), RailHelper.samePositionPredicate(this.dominated.get()), 5, this);
            if (r.isPresent() && (directionOpt = RailHelper.getDirectionToOtherExit((Direction)(pair = r.get()).getFirst(), railShape.get())).isPresent()) {
                Vec3i direction = directionOpt.get();
                return (float)(Mth.m_14136_((double)direction.m_123343_(), (double)direction.m_123341_()) * 180.0 / Math.PI) + 90.0f;
            }
        } else if (this.dominant.isPresent() && railShape.isPresent()) {
            Pair<Direction, Integer> pair;
            Optional<Vec3i> directionOpt;
            Optional<Pair<Direction, Integer>> r = this.railHelper.traverseBi(this.m_20097_().m_7494_(), RailHelper.samePositionPredicate(this.dominant.get()), 5, this);
            if (r.isPresent() && (directionOpt = RailHelper.getDirectionToOtherExit((Direction)(pair = r.get()).getFirst(), railShape.get())).isPresent()) {
                Vec3i direction = directionOpt.get();
                return (float)(Mth.m_14136_((double)(-direction.m_123343_()), (double)(-direction.m_123341_())) * 180.0 / Math.PI) + 90.0f;
            }
        } else {
            double d3;
            double d1 = this.f_19854_ - this.m_20185_();
            if (d1 * d1 + (d3 = this.f_19856_ - this.m_20189_()) * d3 > 0.001) {
                return (float)(Mth.m_14136_((double)d3, (double)d1) * 180.0 / Math.PI) + 90.0f;
            }
        }
        return yrot;
    }

    @Nullable
    public Vec3 m_38096_(double pX, double pY, double pZ, double pOffset) {
        BlockState blockstate;
        int k;
        int j;
        int i = Mth.m_14107_((double)pX);
        if (this.f_19853_.m_8055_(new BlockPos(i, (j = Mth.m_14107_((double)pY)) - 1, k = Mth.m_14107_((double)pZ))).m_204336_(BlockTags.f_13034_)) {
            --j;
        }
        if (BaseRailBlock.m_49416_((BlockState)(blockstate = this.f_19853_.m_8055_(new BlockPos(i, j, k))))) {
            RailShape railshape = ((BaseRailBlock)blockstate.m_60734_()).getRailDirection(blockstate, (BlockGetter)this.f_19853_, new BlockPos(i, j, k), (AbstractMinecart)this);
            pY = j;
            if (railshape.m_61745_()) {
                pY = j + 1;
            }
            Pair<Vec3i, Vec3i> pair = AbstractTrainCarEntity.exits(railshape);
            Vec3i exit1 = (Vec3i)pair.getFirst();
            Vec3i exit2 = (Vec3i)pair.getSecond();
            double yawX = -Math.sin(Math.toRadians(this.m_146908_()));
            double yawZ = Math.cos(Math.toRadians(this.m_146908_()));
            Vec3 vec3 = new Vec3(yawX, 0.0, yawZ);
            Vec3 vec32 = new Vec3((double)(exit2.m_123341_() - exit1.m_123341_()), (double)(exit2.m_123342_() - exit1.m_123342_()), (double)(exit2.m_123343_() - exit1.m_123343_()));
            if (vec3.m_82526_(vec32) <= 0.0) {
                Vec3i temp = exit1;
                exit1 = exit2;
                exit2 = temp;
            }
            double xDiff = exit2.m_123341_() - exit1.m_123341_();
            double zDiff = exit2.m_123343_() - exit1.m_123343_();
            double dist = Math.sqrt(xDiff * xDiff + zDiff * zDiff);
            if (exit1.m_123342_() != 0 && Mth.m_14107_((double)(pX += (xDiff /= dist) * pOffset)) - i == exit1.m_123341_() && Mth.m_14107_((double)(pZ += (zDiff /= dist) * pOffset)) - k == exit1.m_123343_()) {
                pY += (double)exit1.m_123342_();
            } else if (exit2.m_123342_() != 0 && Mth.m_14107_((double)pX) - i == exit2.m_123341_() && Mth.m_14107_((double)pZ) - k == exit2.m_123343_()) {
                pY += (double)exit2.m_123342_();
            }
            return this.m_38179_(pX, pY, pZ);
        }
        return null;
    }

    public boolean m_6000_(double pX, double pY, double pZ) {
        return true;
    }

    public Direction m_6374_() {
        return Direction.m_122364_((double)this.m_146908_());
    }

    public void m_146922_(float pYRot) {
        super.m_146922_(pYRot);
    }

    protected void tickVanilla() {
        super.m_8119_();
    }

    public void m_142687_(Entity.RemovalReason r) {
        this.handleLinkableKill();
        super.m_142687_(r);
    }

    public void m_7617_(DamageSource pSource) {
        int i = (int)Stream.of(this.dominant, this.dominated).filter(Optional::isPresent).count();
        this.m_142687_(Entity.RemovalReason.KILLED);
        if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
            this.m_19983_(this.m_142340_());
            for (int j = 0; j < i; ++j) {
                this.spawnChain();
            }
        }
    }

    protected void prevent180() {
        Vec3 dir = new Vec3((double)this.m_6350_().m_122429_(), (double)this.m_6350_().m_122430_(), (double)this.m_6350_().m_122431_());
        Vec3 vel = this.m_20184_();
        Vec3 mag = vel.m_82559_(dir);
        Vec3 fixer = new Vec3(this.fixUtil(mag.f_82479_), 1.0, this.fixUtil(mag.f_82481_));
        this.m_20256_(this.m_20184_().m_82559_(fixer));
    }

    private double fixUtil(double mag) {
        return mag < 0.0 ? 0.0 : 1.0;
    }

    private void doChainMath() {
        this.dominant.ifPresent(parent -> {
            Optional<Pair<Direction, Integer>> railDirDis = this.railHelper.traverseBi(this.m_20097_().m_7494_(), RailHelper.samePositionPredicate(parent), 5, this);
            boolean docked = this.getTrain().getTug().isPresent() && this.getTrain().getTug().get().m_20184_().equals((Object)Vec3.f_82478_);
            double maxDist = docked ? 1.0 : 1.2;
            double minDist = 1.0;
            float distance = railDirDis.map(Pair::getSecond).filter(a -> a > 0).map(di -> {
                float euclid = this.m_20270_((Entity)parent);
                return Float.valueOf((double)euclid < maxDist ? (float)di.intValue() : euclid);
            }).orElse(Float.valueOf(this.m_20270_((Entity)parent))).floatValue();
            if (distance <= 5.0f) {
                Vec3 euclideanDir = parent.m_20182_().m_82546_(this.m_20182_()).m_82541_();
                Vec3 parentDirection = railDirDis.map(Pair::getFirst).map(Direction::m_122436_).map(Vec3::m_82528_).orElse(euclideanDir).m_82541_();
                Vec3 parentVelocity = parent.m_20184_();
                if ((double)distance > maxDist) {
                    if (parentVelocity.m_82553_() == 0.0) {
                        this.m_20256_(parentDirection.m_82490_(0.05));
                    } else {
                        this.m_20256_(parentDirection.m_82490_(parentVelocity.m_82553_()));
                        if ((double)distance > maxDist + 0.2) {
                            this.m_20256_(this.m_20184_().m_82490_((double)distance * 0.8));
                        }
                    }
                } else if ((double)parent.m_20270_((Entity)this) < minDist && parent.m_20184_().m_82553_() < 0.01) {
                    this.m_6027_(Math.floor(this.m_20185_()) + 0.5, this.m_20186_(), Math.floor(this.m_20189_()) + 0.5);
                    this.m_20256_(Vec3.f_82478_);
                } else {
                    this.m_20256_(Vec3.f_82478_);
                }
            } else {
                this.dominant.ifPresent(LinkableEntity::removeDominated);
                this.removeDominant();
            }
        });
    }

    public AbstractMinecart.Type m_6064_() {
        return AbstractMinecart.Type.CHEST;
    }

    @Override
    public Optional<AbstractTrainCarEntity> getDominated() {
        return this.dominated;
    }

    @Override
    public Optional<AbstractTrainCarEntity> getDominant() {
        return this.dominant;
    }

    private void spawnChain() {
        ItemStack stack = new ItemStack((ItemLike)ModItems.SPRING.get());
        this.m_19983_(stack);
    }

    @Override
    public void handleShearsCut() {
        if (!this.f_19853_.f_46443_ && this.dominant.isPresent()) {
            this.spawnChain();
        }
        this.dominant.ifPresent(LinkableEntity::removeDominated);
        this.removeDominant();
    }

    @Override
    public BlockPos getBlockPos() {
        return this.m_20097_();
    }

    @Override
    public Train<AbstractTrainCarEntity> getTrain() {
        return this.train;
    }

    @Override
    public boolean hasWaterOnSides() {
        return false;
    }

    private void invertDoms() {
        Optional<AbstractTrainCarEntity> temp = this.dominant;
        this.dominant = this.dominated;
        this.dominated = temp;
    }

    private Optional<Integer> distHelper(AbstractTrainCarEntity car1, AbstractTrainCarEntity car2) {
        return this.railHelper.traverseBi(car1.m_20097_().m_7494_(), (l, p) -> RailHelper.getRail(car2.m_20097_().m_7494_(), car2.f_19853_).map(rp -> rp.equals(p)).orElse(false), 5, car1).map(Pair::getSecond);
    }

    private Optional<Pair<AbstractTrainCarEntity, AbstractTrainCarEntity>> findClosestPair(Train<AbstractTrainCarEntity> train1, Train<AbstractTrainCarEntity> train2) {
        int mindistance = Integer.MAX_VALUE;
        Optional<Pair> curr = Optional.empty();
        List<Pair> pairs = Arrays.asList(Pair.of((Object)train1.getHead(), (Object)train2.getTail()), Pair.of((Object)train1.getTail(), (Object)train2.getHead()), Pair.of((Object)train1.getTail(), (Object)train2.getTail()), Pair.of((Object)train1.getHead(), (Object)train2.getHead()));
        for (Pair pair2 : pairs) {
            Optional<Integer> d = this.distHelper((AbstractTrainCarEntity)pair2.getFirst(), (AbstractTrainCarEntity)pair2.getSecond());
            if (!d.isPresent() || d.get() >= mindistance) continue;
            mindistance = d.get();
            curr = Optional.of(pair2);
        }
        return curr.filter(pair -> !(pair.getFirst() instanceof AbstractLocomotiveEntity && !((AbstractTrainCarEntity)pair.getFirst()).getDominated().isEmpty() || pair.getSecond() instanceof AbstractLocomotiveEntity && !((AbstractTrainCarEntity)pair.getSecond()).getDominated().isEmpty()));
    }

    private static Pair<AbstractTrainCarEntity, AbstractTrainCarEntity> caseTailHead(Train<AbstractTrainCarEntity> trainTail, Train<AbstractTrainCarEntity> trainHead, Pair<AbstractTrainCarEntity, AbstractTrainCarEntity> targetPair) {
        if (trainHead.getTug().isPresent()) {
            AbstractTrainCarEntity.invertTrain(trainHead);
            AbstractTrainCarEntity.invertTrain(trainTail);
            return targetPair.swap();
        }
        return targetPair;
    }

    private static void invertTrain(Train<AbstractTrainCarEntity> train) {
        AbstractTrainCarEntity head = train.getHead();
        AbstractTrainCarEntity tail = train.getTail();
        train.asList().forEach(AbstractTrainCarEntity::invertDoms);
        train.setHead(tail);
        train.setTail(head);
    }

    private Optional<Pair<AbstractTrainCarEntity, AbstractTrainCarEntity>> tryFindAndPrepareClosePair(Train<AbstractTrainCarEntity> train1, Train<AbstractTrainCarEntity> train2) {
        return this.findClosestPair(train1, train2).flatMap(targetPair -> {
            if (((AbstractTrainCarEntity)targetPair.getFirst()).equals(train1.getHead()) && ((AbstractTrainCarEntity)targetPair.getSecond()).equals(train2.getHead())) {
                if (train1.getTug().isPresent()) {
                    return Optional.of(targetPair);
                }
                AbstractTrainCarEntity.invertTrain(train2);
                return Optional.of(targetPair.swap());
            }
            if (((AbstractTrainCarEntity)targetPair.getFirst()).equals(train1.getHead()) && ((AbstractTrainCarEntity)targetPair.getSecond()).equals(train2.getTail())) {
                return Optional.of(AbstractTrainCarEntity.caseTailHead(train2, train1, (Pair<AbstractTrainCarEntity, AbstractTrainCarEntity>)targetPair.swap()));
            }
            if (((AbstractTrainCarEntity)targetPair.getFirst()).equals(train1.getTail()) && ((AbstractTrainCarEntity)targetPair.getSecond()).equals(train2.getHead())) {
                return Optional.of(AbstractTrainCarEntity.caseTailHead(train1, train2, (Pair<AbstractTrainCarEntity, AbstractTrainCarEntity>)targetPair));
            }
            if (((AbstractTrainCarEntity)targetPair.getFirst()).equals(train1.getTail()) && ((AbstractTrainCarEntity)targetPair.getSecond()).equals(train2.getTail())) {
                if (train2.getTug().isPresent()) {
                    AbstractTrainCarEntity.invertTrain(train1);
                    return Optional.of(targetPair.swap());
                }
                AbstractTrainCarEntity.invertTrain(train2);
                return Optional.of(targetPair);
            }
            return Optional.empty();
        });
    }

    @Override
    public boolean linkEntities(Player player, Entity target) {
        if (target instanceof AbstractTrainCarEntity) {
            AbstractTrainCarEntity t = (AbstractTrainCarEntity)target;
            Train<AbstractTrainCarEntity> train1 = t.getTrain();
            Train<AbstractTrainCarEntity> train2 = this.getTrain();
            if (train2.getTug().isPresent() && train1.getTug().isPresent()) {
                player.m_5661_((Component)new TranslatableComponent("item.littlelogistics.spring.noTwoLoco"), true);
                return false;
            }
            if (train2.equals(train1)) {
                player.m_5661_((Component)new TranslatableComponent("item.littlelogistics.spring.noLoops"), true);
                return false;
            }
            this.tryFindAndPrepareClosePair(train1, train2).ifPresentOrElse(pair -> AbstractTrainCarEntity.createLinks((AbstractTrainCarEntity)pair.getFirst(), (AbstractTrainCarEntity)pair.getSecond()), () -> player.m_5661_((Component)new TranslatableComponent("item.littlelogistics.spring.tooFar"), true));
            return true;
        }
        player.m_5661_((Component)new TranslatableComponent("item.littlelogistics.spring.badTypes"), true);
        return false;
    }

    private static void createLinks(AbstractTrainCarEntity dominant, AbstractTrainCarEntity dominated) {
        dominated.setDominant(dominant);
        dominant.setDominated(dominated);
    }

    public abstract ItemStack m_142340_();

    public RailHelper getRailHelper() {
        return this.railHelper;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public void setFrozen(boolean frozen) {
        this.frozen = frozen;
    }
}

