/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.entity.custom.tug;

import dev.murad.shipping.ShippingConfig;
import dev.murad.shipping.entity.accessor.SteamTugDataAccessor;
import dev.murad.shipping.entity.container.SteamTugContainer;
import dev.murad.shipping.entity.custom.tug.AbstractTugEntity;
import dev.murad.shipping.setup.ModEntityTypes;
import dev.murad.shipping.setup.ModItems;
import dev.murad.shipping.setup.ModSounds;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraftforge.common.ForgeHooks;

public class SteamTugEntity
extends AbstractTugEntity {
    private static final int FURNACE_FUEL_MULTIPLIER = (Integer)ShippingConfig.Server.STEAM_TUG_FUEL_MULTIPLIER.get();
    protected int burnTime = 0;
    protected int burnCapacity = 0;

    public SteamTugEntity(EntityType<? extends WaterAnimal> type, Level world) {
        super(type, world);
    }

    public SteamTugEntity(Level worldIn, double x, double y, double z) {
        super((EntityType)ModEntityTypes.STEAM_TUG.get(), worldIn, x, y, z);
    }

    @Override
    protected int getNonRouteItemSlots() {
        return 1;
    }

    @Override
    protected MenuProvider createContainerProvider() {
        return new MenuProvider(){

            public Component m_5446_() {
                return new TranslatableComponent("screen.littlelogistics.tug");
            }

            @Nullable
            public AbstractContainerMenu m_7208_(int i, Inventory playerInventory, Player Player2) {
                return new SteamTugContainer(i, SteamTugEntity.this.f_19853_, SteamTugEntity.this.getDataAccessor(), playerInventory, Player2);
            }
        };
    }

    public int getBurnProgress() {
        int i = this.burnCapacity;
        if (i == 0) {
            i = 200;
        }
        return this.burnTime * 13 / i;
    }

    public boolean isLit() {
        return this.burnTime > 0;
    }

    @Override
    public SteamTugDataAccessor getDataAccessor() {
        return new SteamTugDataAccessor.Builder(this.m_142049_()).withBurnProgress(this::getBurnProgress).withLit(this::isLit).build();
    }

    @Override
    protected boolean isTugSlotItemValid(int slot, @Nonnull ItemStack stack) {
        return slot == 1 && FurnaceBlockEntity.m_58399_((ItemStack)stack);
    }

    @Override
    protected int getTugSlotLimit(int slot) {
        return slot == 1 ? 64 : 0;
    }

    @Override
    protected boolean tickFuel() {
        if (this.burnTime > 0) {
            --this.burnTime;
            return true;
        }
        ItemStack stack = this.itemHandler.getStackInSlot(1);
        if (!stack.m_41619_()) {
            this.burnCapacity = ForgeHooks.getBurnTime((ItemStack)stack, null) * FURNACE_FUEL_MULTIPLIER - 1;
            this.burnTime = this.burnCapacity - 1;
            stack.m_41774_(1);
            return true;
        }
        this.burnCapacity = 0;
        this.burnTime = 0;
        return false;
    }

    @Override
    public Item getDropItem() {
        return (Item)ModItems.STEAM_TUG.get();
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        this.burnTime = compound.m_128441_("burn") ? compound.m_128451_("burn") : 0;
        this.burnCapacity = compound.m_128441_("burn_capacity") ? compound.m_128451_("burn_capacity") : 0;
        super.m_7378_(compound);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        compound.m_128405_("burn", this.burnTime);
        compound.m_128405_("burn_capacity", this.burnCapacity);
        super.m_7380_(compound);
    }

    @Override
    protected void onUndock() {
        super.onUndock();
        this.m_5496_((SoundEvent)ModSounds.STEAM_TUG_WHISTLE.get(), 1.0f, (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f + 1.0f);
    }

    public boolean m_7983_() {
        return this.itemHandler.getStackInSlot(1).m_41619_();
    }

    public void m_6836_(int p_70299_1_, ItemStack p_70299_2_) {
        if (!this.itemHandler.isItemValid(1, p_70299_2_)) {
            return;
        }
        this.itemHandler.insertItem(1, p_70299_2_, false);
        if (!p_70299_2_.m_41619_() && p_70299_2_.m_41613_() > this.m_6893_()) {
            p_70299_2_.m_41764_(this.m_6893_());
        }
    }
}

