/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.item.container;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import dev.murad.shipping.item.TugRouteItem;
import dev.murad.shipping.item.container.StringInputScreen;
import dev.murad.shipping.item.container.TugRouteClientHandler;
import dev.murad.shipping.item.container.TugRouteContainer;
import dev.murad.shipping.util.TugRouteNode;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TugRouteScreen
extends AbstractContainerScreen<TugRouteContainer> {
    private static final Logger LOGGER = LogManager.getLogger(TugRouteScreen.class);
    public static final ResourceLocation GUI = new ResourceLocation("littlelogistics", "textures/container/tug_route.png");
    private final ItemStack stack;
    private final TugRouteClientHandler route;

    public TugRouteScreen(TugRouteContainer menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        this.f_97726_ = 256;
        this.f_97727_ = 233;
        this.stack = ((TugRouteContainer)this.f_97732_).getItemStack();
        this.route = new TugRouteClientHandler(this, this.f_96541_, TugRouteItem.getRoute(this.stack), menu.isOffHand());
    }

    private int getRight() {
        return this.f_97735_ + this.f_97726_;
    }

    private int getBot() {
        return this.f_97736_ + this.f_97727_;
    }

    private Button.OnTooltip getTooltip(TranslatableComponent tooltip) {
        return (button, stack, x, y) -> this.m_96602_(stack, (Component)tooltip, x, y);
    }

    protected void m_7856_() {
        super.m_7856_();
        LOGGER.info("Initializing TugRouteScreen");
        this.m_142416_((GuiEventListener)this.route.initializeWidget(this.f_96543_, this.f_96544_, this.f_97736_ + 40, this.f_97736_ + this.f_97727_ - 45, 20));
        this.m_142416_((GuiEventListener)new Button(this.getRight() - 92, this.getBot() - 24, 20, 20, (Component)new TextComponent("..\ua56f").m_130940_(ChatFormatting.BOLD), button -> {
            Optional<Pair<Integer, TugRouteNode>> selectedOpt = this.route.getSelected();
            if (selectedOpt.isPresent()) {
                Pair<Integer, TugRouteNode> selected = selectedOpt.get();
                this.f_96541_.pushGuiLayer((Screen)new StringInputScreen((TugRouteNode)selected.getSecond(), (Integer)selected.getFirst(), this.route::renameSelected));
            }
        }, this.getTooltip(new TranslatableComponent("screen.littlelogistics.tug_route.rename_button"))));
        this.m_142416_((GuiEventListener)new Button(this.getRight() - 70, this.getBot() - 24, 20, 20, (Component)new TextComponent("\u25b2"), button -> this.route.moveSelectedUp(), this.getTooltip(new TranslatableComponent("screen.littlelogistics.tug_route.up_button"))));
        this.m_142416_((GuiEventListener)new Button(this.getRight() - 47, this.getBot() - 24, 20, 20, (Component)new TextComponent("\u25bc"), button -> this.route.moveSelectedDown(), this.getTooltip(new TranslatableComponent("screen.littlelogistics.tug_route.down_button"))));
        this.m_142416_((GuiEventListener)new Button(this.getRight() - 24, this.getBot() - 24, 20, 20, (Component)new TextComponent("\u2718"), button -> this.route.deleteSelected(), this.getTooltip(new TranslatableComponent("screen.littlelogistics.tug_route.delete_button"))));
    }

    public void m_6305_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.m_7025_(matrixStack, mouseX, mouseY);
    }

    protected void m_7286_(PoseStack matrixStack, float partialTicks, int x, int y) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI);
        int left = this.getGuiLeft();
        int top = this.getGuiTop();
        int right = this.getRight();
        int bot = this.getBot();
        this.m_93228_(matrixStack, left, top, 0, 0, 4, 4);
        this.m_93228_(matrixStack, this.getRight() - 4, top, 8, 0, 4, 4);
        this.m_93228_(matrixStack, left, this.getBot() - 4, 0, 8, 4, 4);
        this.m_93228_(matrixStack, this.getRight() - 4, this.getBot() - 4, 8, 8, 4, 4);
        int zoom = 1000;
        TugRouteScreen.m_93143_((PoseStack)matrixStack, (int)(left + 4), (int)top, (int)this.m_93252_(), (float)(4 * zoom), (float)0.0f, (int)(this.getXSize() - 8), (int)4, (int)(256 * zoom), (int)256);
        TugRouteScreen.m_93143_((PoseStack)matrixStack, (int)(left + 4), (int)(bot - 4), (int)this.m_93252_(), (float)(4 * zoom), (float)8.0f, (int)(this.getXSize() - 8), (int)4, (int)(256 * zoom), (int)256);
        TugRouteScreen.m_93143_((PoseStack)matrixStack, (int)left, (int)(top + 4), (int)this.m_93252_(), (float)0.0f, (float)(4 * zoom), (int)4, (int)(this.getYSize() - 8), (int)256, (int)(256 * zoom));
        TugRouteScreen.m_93143_((PoseStack)matrixStack, (int)(right - 4), (int)(top + 4), (int)this.m_93252_(), (float)8.0f, (float)(4 * zoom), (int)4, (int)(this.getYSize() - 8), (int)256, (int)(256 * zoom));
        TugRouteScreen.m_93143_((PoseStack)matrixStack, (int)(left + 4), (int)(top + 4), (int)this.m_93252_(), (float)(4 * zoom), (float)(4 * zoom), (int)(this.getXSize() - 8), (int)(this.getYSize() - 8), (int)(256 * zoom), (int)(256 * zoom));
    }

    protected void m_7027_(PoseStack stack, int p_230451_2_, int p_230451_3_) {
        this.f_96547_.m_92889_(stack, this.f_96539_, (float)this.f_97728_, (float)this.f_97729_, 0x404040);
    }

    public Font getFont() {
        return this.f_96547_;
    }
}

