/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.gl.buffer;

import com.jozufozu.flywheel.backend.gl.buffer.GlBuffer;
import com.jozufozu.flywheel.backend.gl.buffer.GlBufferType;
import com.jozufozu.flywheel.backend.gl.buffer.GlBufferUsage;
import com.jozufozu.flywheel.backend.gl.buffer.Mappable;
import com.jozufozu.flywheel.backend.gl.buffer.MappedBuffer;
import com.jozufozu.flywheel.backend.gl.error.GlError;
import com.jozufozu.flywheel.backend.gl.error.GlException;
import java.nio.ByteBuffer;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL30;

public class MappedGlBuffer
extends GlBuffer
implements Mappable {
    protected final GlBufferUsage usage;

    public MappedGlBuffer(GlBufferType type) {
        this(type, GlBufferUsage.STATIC_DRAW);
    }

    public MappedGlBuffer(GlBufferType type, GlBufferUsage usage) {
        super(type);
        this.usage = usage;
    }

    @Override
    protected void alloc(long size) {
        GL15.glBufferData((int)this.type.glEnum, (long)size, (int)this.usage.glEnum);
    }

    @Override
    public void upload(ByteBuffer directBuffer) {
        GL15.glBufferData((int)this.type.glEnum, (ByteBuffer)directBuffer, (int)this.usage.glEnum);
    }

    @Override
    public MappedBuffer getBuffer(long offset, long length) {
        ByteBuffer byteBuffer = GL30.glMapBufferRange((int)this.type.glEnum, (long)offset, (long)length, (int)2);
        if (byteBuffer == null) {
            throw new GlException(GlError.poll(), "Could not map buffer");
        }
        return new MappedBuffer(this, byteBuffer, offset, length);
    }

    @Override
    public GlBufferType getType() {
        return this.type;
    }

    @Override
    public boolean isPersistent() {
        return false;
    }
}

