/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.backend.instancing;

import com.jozufozu.flywheel.Flywheel;
import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.backend.instancing.InstanceManager;
import com.jozufozu.flywheel.backend.instancing.InstanceWorld;
import com.jozufozu.flywheel.config.FlwCommands;
import com.jozufozu.flywheel.config.FlwConfig;
import com.jozufozu.flywheel.event.BeginFrameEvent;
import com.jozufozu.flywheel.event.ReloadRenderersEvent;
import com.jozufozu.flywheel.event.RenderLayerEvent;
import com.jozufozu.flywheel.util.AnimationTickHolder;
import com.jozufozu.flywheel.util.WorldAttached;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class InstancedRenderDispatcher {
    private static final WorldAttached<InstanceWorld> instanceWorlds = new WorldAttached<InstanceWorld>(InstanceWorld::new);

    public static void enqueueUpdate(BlockEntity blockEntity) {
        if (Backend.isOn() && blockEntity.m_58898_() && blockEntity.m_58904_() instanceof ClientLevel) {
            instanceWorlds.get((LevelAccessor)blockEntity.m_58904_()).getBlockEntityInstanceManager().queueUpdate(blockEntity);
        }
    }

    public static void enqueueUpdate(Entity entity) {
        if (Backend.isOn()) {
            instanceWorlds.get((LevelAccessor)entity.f_19853_).getEntityInstanceManager().queueUpdate(entity);
        }
    }

    public static InstanceManager<BlockEntity> getBlockEntities(LevelAccessor world) {
        if (Backend.isOn()) {
            return instanceWorlds.get(world).getBlockEntityInstanceManager();
        }
        throw new NullPointerException("Backend is off, cannot retrieve instance world.");
    }

    public static InstanceManager<Entity> getEntities(LevelAccessor world) {
        if (Backend.isOn()) {
            return instanceWorlds.get(world).getEntityInstanceManager();
        }
        throw new NullPointerException("Backend is off, cannot retrieve instance world.");
    }

    @SubscribeEvent
    public static void tick(TickEvent.ClientTickEvent event) {
        if (!Backend.isGameActive() || event.phase == TickEvent.Phase.START) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel world = mc.f_91073_;
        AnimationTickHolder.tick();
        if (Backend.isOn()) {
            instanceWorlds.get((LevelAccessor)world).tick();
        }
    }

    @SubscribeEvent
    public static void onBeginFrame(BeginFrameEvent event) {
        if (Backend.isGameActive() && Backend.isOn()) {
            instanceWorlds.get((LevelAccessor)event.getWorld()).beginFrame(event);
        }
    }

    @SubscribeEvent
    public static void renderLayer(RenderLayerEvent event) {
        if (event.layer == null) {
            return;
        }
        ClientLevel world = event.getWorld();
        if (!Backend.canUseInstancing((Level)world)) {
            return;
        }
        instanceWorlds.get((LevelAccessor)world).renderLayer(event);
    }

    @SubscribeEvent
    public static void onReloadRenderers(ReloadRenderersEvent event) {
        ClientLevel world = event.getWorld();
        if (Backend.isOn() && world != null) {
            InstancedRenderDispatcher.resetInstanceWorld(world);
        }
    }

    public static void resetInstanceWorld(ClientLevel world) {
        instanceWorlds.replace((LevelAccessor)world, InstanceWorld::delete).loadEntities(world);
    }

    public static void getDebugString(List<String> debug) {
        debug.add("");
        debug.add("Flywheel: " + Flywheel.getVersion());
        if (Backend.isOn()) {
            InstanceWorld instanceWorld = instanceWorlds.get((LevelAccessor)Minecraft.m_91087_().f_91073_);
            debug.add("Update limiting: " + FlwCommands.boolToText(FlwConfig.get().limitUpdates()).getString());
            debug.add("B: " + instanceWorld.blockEntityInstanceManager.getObjectCount() + ", E: " + instanceWorld.entityInstanceManager.getObjectCount());
            instanceWorld.engine.addDebugInfo(debug);
        } else {
            debug.add("Disabled");
        }
    }
}

