/*
 * Decompiled with CFR 0.152.
 */
package com.jozufozu.flywheel.core.compile;

import com.google.common.collect.ImmutableList;
import com.jozufozu.flywheel.api.vertex.VertexType;
import com.jozufozu.flywheel.core.compile.VertexData;
import com.jozufozu.flywheel.core.source.FileIndex;
import com.jozufozu.flywheel.core.source.ShaderLoadingException;
import com.jozufozu.flywheel.core.source.SourceFile;
import com.jozufozu.flywheel.core.source.error.ErrorReporter;
import com.jozufozu.flywheel.core.source.parse.ShaderFunction;
import com.jozufozu.flywheel.core.source.parse.Variable;
import java.util.Optional;

public class OneShotTemplateData
implements VertexData {
    public final SourceFile file;
    public final ShaderFunction vertexMain;

    public OneShotTemplateData(SourceFile file) {
        this.file = file;
        Optional<ShaderFunction> maybeVertexMain = file.findFunction("vertex");
        if (maybeVertexMain.isEmpty()) {
            ErrorReporter.generateFileError(file, "could not find \"vertex\" function");
            throw new RuntimeException();
        }
        this.vertexMain = maybeVertexMain.get();
        ImmutableList<Variable> vertexParameters = this.vertexMain.getParameters();
        if (vertexParameters.size() != 1) {
            ErrorReporter.generateSpanError(this.vertexMain.getArgs(), "a basic model requires vertex function to have one argument");
            throw new RuntimeException();
        }
        Variable vertexParam = (Variable)this.vertexMain.getParameters().get(0);
        boolean namedVertex = vertexParam.type.toString().equals("Vertex");
        if (!namedVertex || vertexParam.qualifier != Variable.Qualifier.INOUT) {
            ErrorReporter.generateSpanError(vertexParam.qualifierSpan, "first parameter must be inout Vertex");
            throw new ShaderLoadingException();
        }
    }

    @Override
    public String generateFooter(FileIndex file, VertexType vertexType) {
        return "out vec4 v2f_color;\nout vec2 v2f_texCoords;\nout vec2 v2f_light;\nout float v2f_diffuse;\n\nvoid main() {\n\tVertex v = FLWCreateVertex();\n\tvertex(v);\n\tgl_Position = FLWVertex(v);\n\tv.normal = normalize(v.normal);\n\n\tv2f_color = v.color;\n\tv2f_texCoords = v.texCoords;\n\tv2f_light = v.light;\n\tv2f_diffuse = diffuse(v.normal);\n\t#if defined(DEBUG_NORMAL)\n\tv2f_color = vec4(v.normal, 1.);\n\t#endif\n}\n";
    }
}

