/*
 * Decompiled with CFR 0.152.
 */
package twilightforest;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.WallSkullBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.PacketDistributor;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotResult;
import twilightforest.TFConfig;
import twilightforest.TFSounds;
import twilightforest.TwilightForestMod;
import twilightforest.advancements.TFAdvancements;
import twilightforest.block.AbstractLightableBlock;
import twilightforest.block.AbstractSkullCandleBlock;
import twilightforest.block.GiantBlock;
import twilightforest.block.KeepsakeCasketBlock;
import twilightforest.block.SkullCandleBlock;
import twilightforest.block.TFBlocks;
import twilightforest.block.TFPortalBlock;
import twilightforest.block.WallSkullCandleBlock;
import twilightforest.block.entity.KeepsakeCasketBlockEntity;
import twilightforest.block.entity.SkullCandleBlockEntity;
import twilightforest.capabilities.CapabilityList;
import twilightforest.capabilities.shield.IShieldCapability;
import twilightforest.data.tags.BlockTagGenerator;
import twilightforest.enchantment.TFEnchantment;
import twilightforest.entity.CharmEffect;
import twilightforest.entity.IHostileMount;
import twilightforest.entity.TFEntities;
import twilightforest.entity.monster.Kobold;
import twilightforest.entity.passive.Bighorn;
import twilightforest.entity.passive.DwarfRabbit;
import twilightforest.entity.passive.Squirrel;
import twilightforest.entity.passive.TinyBird;
import twilightforest.entity.projectile.ITFProjectile;
import twilightforest.enums.BlockLoggingEnum;
import twilightforest.item.PhantomArmorItem;
import twilightforest.item.TFItems;
import twilightforest.network.AreaProtectionPacket;
import twilightforest.network.EnforceProgressionStatusPacket;
import twilightforest.network.TFPacketHandler;
import twilightforest.network.UpdateShieldPacket;
import twilightforest.potions.TFMobEffects;
import twilightforest.util.TFItemStackUtils;
import twilightforest.util.TFStats;
import twilightforest.util.WorldUtil;
import twilightforest.world.components.chunkgenerators.ChunkGeneratorTwilight;
import twilightforest.world.registration.TFFeature;
import twilightforest.world.registration.TFGenerationSettings;

@Mod.EventBusSubscriber(modid="twilightforest")
public class TFEventListener {
    public static final String CHARM_INV_TAG = "TFCharmInventory";
    private static final ImmutableSet<String> SHIELD_DAMAGE_BLACKLIST = ImmutableSet.of((Object)"inWall", (Object)"cramming", (Object)"drown", (Object)"starve", (Object)"fall", (Object)"flyIntoWall", (Object[])new String[]{"outOfWorld", "fallingBlock"});
    private static boolean isBreakingWithGiantPick = false;
    private static boolean shouldMakeGiantCobble = false;
    private static int amountOfCobbleToReplace = 0;
    private static boolean casketExpiration = false;
    private static ItemStack charmUsed;
    public static volatile boolean allowDismount;
    private static final String NBT_TAG_TWILIGHT = "twilightforest_banished";
    private static final boolean globalParry;

    @SubscribeEvent
    public static void addReach(ItemAttributeModifierEvent event) {
        Item item = event.getItemStack().m_41720_();
        if ((item == TFItems.GIANT_PICKAXE.get() || item == TFItems.GIANT_SWORD.get()) && event.getSlotType() == EquipmentSlot.MAINHAND) {
            event.addModifier((Attribute)ForgeMod.REACH_DISTANCE.get(), new AttributeModifier(TFItems.GIANT_REACH_MODIFIER, "Tool modifier", 2.5, AttributeModifier.Operation.ADDITION));
        }
    }

    @SubscribeEvent
    public static void addPrey(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        EntityType type = entity.m_6095_();
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            if (type == EntityType.f_20553_) {
                mob.f_21346_.m_25352_(1, (Goal)new NonTameRandomTargetGoal((TamableAnimal)entity, DwarfRabbit.class, false, null));
                mob.f_21346_.m_25352_(1, (Goal)new NonTameRandomTargetGoal((TamableAnimal)entity, Squirrel.class, false, null));
                mob.f_21346_.m_25352_(1, (Goal)new NonTameRandomTargetGoal((TamableAnimal)entity, TinyBird.class, false, null));
            } else if (type == EntityType.f_20505_) {
                mob.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal(mob, DwarfRabbit.class, false));
                mob.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal(mob, Squirrel.class, false));
                mob.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal(mob, TinyBird.class, false));
            } else if (type == EntityType.f_20452_) {
                mob.f_21346_.m_25352_(6, (Goal)new NearestAttackableTargetGoal(mob, DwarfRabbit.class, false));
                mob.f_21346_.m_25352_(6, (Goal)new NearestAttackableTargetGoal(mob, Squirrel.class, false));
            } else if (type == EntityType.f_20499_) {
                mob.f_21346_.m_25352_(7, (Goal)new NonTameRandomTargetGoal((TamableAnimal)entity, DwarfRabbit.class, false, null));
                mob.f_21346_.m_25352_(7, (Goal)new NonTameRandomTargetGoal((TamableAnimal)entity, Squirrel.class, false, null));
                mob.f_21346_.m_25352_(7, (Goal)new NonTameRandomTargetGoal((TamableAnimal)entity, Bighorn.class, false, null));
            }
        }
    }

    @SubscribeEvent
    public static void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        ItemStack itemStack = event.getCrafting();
        if (itemStack.m_150930_(Items.f_42647_) && itemStack.m_41613_() == 64 && event.getInventory().m_18947_(((Block)TFBlocks.GIANT_LOG.get()).m_5456_()) > 0) {
            Player player = event.getPlayer();
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)Items.f_42647_, 64));
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)Items.f_42647_, 64));
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)Items.f_42647_, 64));
        }
    }

    @SubscribeEvent
    public static void entityHurts(LivingHurtEvent event) {
        int chillLevel;
        Player player;
        int fireLevel;
        LivingEntity living = event.getEntityLiving();
        DamageSource damageSource = event.getSource();
        String damageType = damageSource.m_19385_();
        Entity trueSource = damageSource.m_7639_();
        if (living instanceof Player && (damageType.equals("mob") || damageType.equals("player")) && trueSource != null && (fireLevel = TFEnchantment.getFieryAuraLevel((player = (Player)living).m_150109_(), damageSource)) > 0 && player.m_21187_().nextInt(25) < fireLevel) {
            trueSource.m_20254_(fireLevel / 2);
        }
        if (living instanceof Player && (damageType.equals("mob") || damageType.equals("player")) && trueSource instanceof LivingEntity && (chillLevel = TFEnchantment.getChillAuraLevel((player = (Player)living).m_150109_(), damageSource)) > 0) {
            ((LivingEntity)trueSource).m_7292_(new MobEffectInstance((MobEffect)TFMobEffects.FROSTY.get(), chillLevel * 5 + 5, chillLevel));
        }
        if (damageType.equals("arrow") && trueSource instanceof Player && ((player = (Player)trueSource).m_21205_().m_41720_() == TFItems.TRIPLE_BOW.get() || player.m_21206_().m_41720_() == TFItems.TRIPLE_BOW.get())) {
            living.f_19802_ = 0;
        }
        if (living instanceof Player && TFEventListener.isRidingUnfriendly(living) && damageSource == DamageSource.f_19310_) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void createSkullCandle(PlayerInteractEvent.RightClickBlock event) {
        ItemStack stack = event.getItemStack();
        Level world = event.getWorld();
        BlockPos pos = event.getPos();
        BlockState state = world.m_8055_(pos);
        if (!((Boolean)TFConfig.COMMON_CONFIG.disableSkullCandles.get()).booleanValue() && stack.m_204117_(ItemTags.f_144319_) && stack.m_41720_().getRegistryName().m_135827_().equals("minecraft") && !event.getPlayer().m_6144_() && state.m_60734_() instanceof AbstractSkullBlock && state.m_60734_().getRegistryName().m_135827_().equals("minecraft")) {
            SkullBlock.Types type = (SkullBlock.Types)((AbstractSkullBlock)state.m_60734_()).m_48754_();
            boolean wall = state.m_60734_() instanceof WallSkullBlock;
            switch (type) {
                case SKELETON: {
                    if (wall) {
                        TFEventListener.makeWallSkull(event, (Block)TFBlocks.SKELETON_WALL_SKULL_CANDLE.get());
                        break;
                    }
                    TFEventListener.makeFloorSkull(event, (Block)TFBlocks.SKELETON_SKULL_CANDLE.get());
                    break;
                }
                case WITHER_SKELETON: {
                    if (wall) {
                        TFEventListener.makeWallSkull(event, (Block)TFBlocks.WITHER_SKELE_WALL_SKULL_CANDLE.get());
                        break;
                    }
                    TFEventListener.makeFloorSkull(event, (Block)TFBlocks.WITHER_SKELE_SKULL_CANDLE.get());
                    break;
                }
                case PLAYER: {
                    if (wall) {
                        TFEventListener.makeWallSkull(event, (Block)TFBlocks.PLAYER_WALL_SKULL_CANDLE.get());
                        break;
                    }
                    TFEventListener.makeFloorSkull(event, (Block)TFBlocks.PLAYER_SKULL_CANDLE.get());
                    break;
                }
                case ZOMBIE: {
                    if (wall) {
                        TFEventListener.makeWallSkull(event, (Block)TFBlocks.ZOMBIE_WALL_SKULL_CANDLE.get());
                        break;
                    }
                    TFEventListener.makeFloorSkull(event, (Block)TFBlocks.ZOMBIE_SKULL_CANDLE.get());
                    break;
                }
                case CREEPER: {
                    if (wall) {
                        TFEventListener.makeWallSkull(event, (Block)TFBlocks.CREEPER_WALL_SKULL_CANDLE.get());
                        break;
                    }
                    TFEventListener.makeFloorSkull(event, (Block)TFBlocks.CREEPER_SKULL_CANDLE.get());
                    break;
                }
                default: {
                    return;
                }
            }
            if (!event.getPlayer().m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            event.getPlayer().m_6674_(event.getHand());
            if (event.getPlayer() instanceof ServerPlayer) {
                event.getPlayer().m_36220_((ResourceLocation)TFStats.SKULL_CANDLES_MADE.get());
            }
            event.setCanceled(true);
        }
    }

    private static void makeFloorSkull(PlayerInteractEvent.RightClickBlock event, Block newBlock) {
        GameProfile profile = null;
        BlockEntity blockEntity = event.getWorld().m_7702_(event.getPos());
        if (blockEntity instanceof SkullBlockEntity) {
            SkullBlockEntity skull = (SkullBlockEntity)blockEntity;
            profile = skull.m_59779_();
        }
        event.getWorld().m_5594_(null, event.getPos(), SoundEvents.f_144101_, SoundSource.BLOCKS, 1.0f, 1.0f);
        event.getWorld().m_46597_(event.getPos(), (BlockState)((BlockState)newBlock.m_49966_().m_61124_((Property)AbstractSkullCandleBlock.LIGHTING, (Comparable)((Object)AbstractLightableBlock.Lighting.NONE))).m_61124_((Property)SkullCandleBlock.ROTATION, (Comparable)((Integer)event.getWorld().m_8055_(event.getPos()).m_61143_((Property)SkullBlock.f_56314_))));
        event.getWorld().m_151523_((BlockEntity)new SkullCandleBlockEntity(event.getPos(), (BlockState)((BlockState)newBlock.m_49966_().m_61124_((Property)AbstractSkullCandleBlock.LIGHTING, (Comparable)((Object)AbstractLightableBlock.Lighting.NONE))).m_61124_((Property)SkullCandleBlock.ROTATION, (Comparable)((Integer)event.getWorld().m_8055_(event.getPos()).m_61143_((Property)SkullBlock.f_56314_))), AbstractSkullCandleBlock.candleToCandleColor(event.getItemStack().m_41720_()).getValue(), 1));
        blockEntity = event.getWorld().m_7702_(event.getPos());
        if (blockEntity instanceof SkullCandleBlockEntity) {
            SkullCandleBlockEntity sc = (SkullCandleBlockEntity)blockEntity;
            sc.m_59769_(profile);
        }
    }

    private static void makeWallSkull(PlayerInteractEvent.RightClickBlock event, Block newBlock) {
        GameProfile profile = null;
        BlockEntity blockEntity = event.getWorld().m_7702_(event.getPos());
        if (blockEntity instanceof SkullBlockEntity) {
            SkullBlockEntity skull = (SkullBlockEntity)blockEntity;
            profile = skull.m_59779_();
        }
        event.getWorld().m_5594_(null, event.getPos(), SoundEvents.f_144101_, SoundSource.BLOCKS, 1.0f, 1.0f);
        event.getWorld().m_46597_(event.getPos(), (BlockState)((BlockState)newBlock.m_49966_().m_61124_((Property)AbstractSkullCandleBlock.LIGHTING, (Comparable)((Object)AbstractLightableBlock.Lighting.NONE))).m_61124_((Property)WallSkullCandleBlock.FACING, (Comparable)((Direction)event.getWorld().m_8055_(event.getPos()).m_61143_((Property)WallSkullBlock.f_58097_))));
        event.getWorld().m_151523_((BlockEntity)new SkullCandleBlockEntity(event.getPos(), (BlockState)((BlockState)newBlock.m_49966_().m_61124_((Property)AbstractSkullCandleBlock.LIGHTING, (Comparable)((Object)AbstractLightableBlock.Lighting.NONE))).m_61124_((Property)WallSkullCandleBlock.FACING, (Comparable)((Direction)event.getWorld().m_8055_(event.getPos()).m_61143_((Property)WallSkullBlock.f_58097_))), AbstractSkullCandleBlock.candleToCandleColor(event.getItemStack().m_41720_()).getValue(), 1));
        blockEntity = event.getWorld().m_7702_(event.getPos());
        if (blockEntity instanceof SkullCandleBlockEntity) {
            SkullCandleBlockEntity sc = (SkullCandleBlockEntity)blockEntity;
            sc.m_59769_(profile);
        }
    }

    private static boolean hasCharmCurio(Item item, Player player) {
        Optional slot;
        if (ModList.get().isLoaded("curios") && (slot = CuriosApi.getCuriosHelper().findFirstCurio((LivingEntity)player, stack -> stack.m_150930_(item))).isPresent()) {
            ((SlotResult)slot.get()).stack().m_41774_(1);
            return true;
        }
        return false;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void applyDeathItems(LivingDeathEvent event) {
        Player player;
        LivingEntity living;
        block7: {
            block6: {
                living = event.getEntityLiving();
                if (living.f_19853_.f_46443_ || !(living instanceof Player)) break block6;
                player = (Player)living;
                if (!(living instanceof FakePlayer) && !player.m_7500_()) break block7;
            }
            return;
        }
        if (TFEventListener.charmOfLife(player)) {
            event.setCanceled(true);
        } else if (!living.f_19853_.m_46469_().m_46207_(GameRules.f_46133_)) {
            TFEventListener.charmOfKeeping(player);
            TFEventListener.keepsakeCasket(player);
        }
    }

    private static void keepsakeCasket(Player player) {
        boolean casketConsumed = TFItemStackUtils.consumeInventoryItem(player, ((KeepsakeCasketBlock)TFBlocks.KEEPSAKE_CASKET.get()).m_5456_());
        if (casketConsumed) {
            Level world = player.m_20193_();
            BlockPos.MutableBlockPos pos = player.m_142538_().m_122032_();
            if (pos.m_123342_() < 2) {
                pos.m_142448_(2);
            } else {
                int logicalHeight = player.m_20193_().m_6042_().m_63964_();
                if (pos.m_123342_() > logicalHeight) {
                    pos.m_142448_(logicalHeight - 1);
                }
            }
            BlockPos immutablePos = pos.m_7949_();
            FluidState fluidState = world.m_6425_(immutablePos);
            if (world.m_46597_(immutablePos, (BlockState)((BlockState)((KeepsakeCasketBlock)TFBlocks.KEEPSAKE_CASKET.get()).m_49966_().m_61124_(BlockLoggingEnum.MULTILOGGED, (Comparable)((Object)BlockLoggingEnum.getFromFluid(fluidState.m_76152_())))).m_61124_((Property)KeepsakeCasketBlock.BREAKAGE, (Comparable)Integer.valueOf(TFItemStackUtils.damage)))) {
                BlockEntity te = world.m_7702_(immutablePos);
                if (te instanceof KeepsakeCasketBlockEntity) {
                    KeepsakeCasketBlockEntity casket = (KeepsakeCasketBlockEntity)te;
                    casket.playeruuid = (Boolean)TFConfig.COMMON_CONFIG.casketUUIDLocking.get() != false ? player.m_36316_().getId() : null;
                    String modifiedName = player.m_7755_().getString().length() > 12 ? player.m_7755_().getString().substring(0, 12) : player.m_7755_().getString();
                    casket.f_58622_ = player.m_7755_().getString();
                    casket.casketname = modifiedName;
                    casket.m_58638_((Component)new TextComponent(modifiedName + "'s " + (world.f_46441_.nextInt(10000) == 0 ? "Costco Casket" : casket.m_5446_().getString())));
                    int damage = (Integer)world.m_8055_(immutablePos).m_61143_((Property)KeepsakeCasketBlock.BREAKAGE);
                    if (world.f_46441_.nextFloat() <= 0.15f) {
                        if (damage >= 2) {
                            player.m_150109_().m_36071_();
                            world.m_46597_(immutablePos, Blocks.f_50016_.m_49966_());
                            casketExpiration = true;
                            TwilightForestMod.LOGGER.debug("{}'s Casket damage value was too high, alerting the player and dropping extra items", (Object)player.m_7755_().getString());
                        } else {
                            world.m_46597_(immutablePos, (BlockState)((BlockState)((KeepsakeCasketBlock)TFBlocks.KEEPSAKE_CASKET.get()).m_49966_().m_61124_(BlockLoggingEnum.MULTILOGGED, (Comparable)((Object)BlockLoggingEnum.getFromFluid(fluidState.m_76152_())))).m_61124_((Property)KeepsakeCasketBlock.BREAKAGE, (Comparable)Integer.valueOf(++damage)));
                            TwilightForestMod.LOGGER.debug("{}'s Casket was randomly damaged, applying new damage", (Object)player.m_7755_().getString());
                        }
                    }
                    int casketCapacity = casket.m_6643_();
                    ArrayList<ItemStack> list = new ArrayList<ItemStack>(casketCapacity);
                    NonNullList filler = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
                    list.addAll((Collection<ItemStack>)TFItemStackUtils.sortArmorForCasket(player));
                    player.m_150109_().f_35975_.clear();
                    list.addAll((Collection<ItemStack>)filler);
                    list.addAll((Collection<ItemStack>)player.m_150109_().f_35976_);
                    player.m_150109_().f_35976_.clear();
                    list.addAll((Collection<ItemStack>)TFItemStackUtils.sortInvForCasket(player));
                    player.m_150109_().f_35974_.clear();
                    casket.m_6520_((NonNullList<ItemStack>)NonNullList.m_122783_((Object)ItemStack.f_41583_, (Object[])list.toArray(new ItemStack[casketCapacity])));
                }
            } else {
                TwilightForestMod.LOGGER.error("Could not place Keepsake Casket at " + pos);
            }
        }
    }

    @SubscribeEvent
    public static void onCasketBreak(BlockEvent.BreakEvent event) {
        Block block = event.getState().m_60734_();
        Player player = event.getPlayer();
        BlockEntity te = event.getWorld().m_7702_(event.getPos());
        if (block == TFBlocks.KEEPSAKE_CASKET.get()) {
            UUID checker;
            if (te instanceof KeepsakeCasketBlockEntity) {
                KeepsakeCasketBlockEntity casket = (KeepsakeCasketBlockEntity)te;
                checker = casket.playeruuid;
            } else {
                checker = null;
            }
            if (!(checker == null || ((KeepsakeCasketBlockEntity)te).m_7983_() || player.m_20310_(3) && player.m_36316_().getId().equals(checker))) {
                event.setCanceled(true);
            }
        }
    }

    private static boolean charmOfLife(Player player) {
        boolean charm1;
        boolean charm2 = TFItemStackUtils.consumeInventoryItem(player, (Item)TFItems.CHARM_OF_LIFE_2.get()) || TFEventListener.hasCharmCurio((Item)TFItems.CHARM_OF_LIFE_2.get(), player);
        boolean bl = charm1 = !charm2 && (TFItemStackUtils.consumeInventoryItem(player, (Item)TFItems.CHARM_OF_LIFE_1.get()) || TFEventListener.hasCharmCurio((Item)TFItems.CHARM_OF_LIFE_1.get(), player));
        if (charm2 || charm1) {
            if (charm1) {
                player.m_21153_(8.0f);
                player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 100, 0));
            }
            if (charm2) {
                player.m_21153_(player.m_21233_());
                player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 600, 3));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 600, 0));
                player.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 600, 0));
            }
            CharmEffect effect = new CharmEffect((EntityType<? extends CharmEffect>)((EntityType)TFEntities.CHARM_EFFECT.get()), player.f_19853_, (LivingEntity)player, charm1 ? (Item)TFItems.CHARM_OF_LIFE_1.get() : (Item)TFItems.CHARM_OF_LIFE_2.get());
            player.f_19853_.m_7967_((Entity)effect);
            CharmEffect effect2 = new CharmEffect((EntityType<? extends CharmEffect>)((EntityType)TFEntities.CHARM_EFFECT.get()), player.f_19853_, (LivingEntity)player, charm1 ? (Item)TFItems.CHARM_OF_LIFE_1.get() : (Item)TFItems.CHARM_OF_LIFE_2.get());
            effect2.offset = (float)Math.PI;
            player.f_19853_.m_7967_((Entity)effect2);
            player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), TFSounds.CHARM_LIFE, player.m_5720_(), 1.0f, 1.0f);
            if (player instanceof ServerPlayer) {
                player.m_36220_((ResourceLocation)TFStats.LIFE_CHARMS_ACTIVATED.get());
            }
            return true;
        }
        return false;
    }

    public static CompoundTag getPlayerData(Player player) {
        if (!player.getPersistentData().m_128441_("PlayerPersisted")) {
            player.getPersistentData().m_128365_("PlayerPersisted", (Tag)new CompoundTag());
        }
        return player.getPersistentData().m_128469_("PlayerPersisted");
    }

    private static void charmOfKeeping(Player player) {
        int i;
        boolean tier3 = TFItemStackUtils.consumeInventoryItem(player, (Item)TFItems.CHARM_OF_KEEPING_3.get()) || TFEventListener.hasCharmCurio((Item)TFItems.CHARM_OF_KEEPING_3.get(), player);
        boolean tier2 = tier3 || TFItemStackUtils.consumeInventoryItem(player, (Item)TFItems.CHARM_OF_KEEPING_2.get()) || TFEventListener.hasCharmCurio((Item)TFItems.CHARM_OF_KEEPING_2.get(), player);
        boolean tier1 = tier2 || TFItemStackUtils.consumeInventoryItem(player, (Item)TFItems.CHARM_OF_KEEPING_1.get()) || TFEventListener.hasCharmCurio((Item)TFItems.CHARM_OF_KEEPING_1.get(), player);
        Inventory keepInventory = new Inventory(null);
        ListTag tagList = new ListTag();
        if (tier1) {
            TFEventListener.keepWholeList((NonNullList<ItemStack>)keepInventory.f_35975_, (NonNullList<ItemStack>)player.m_150109_().f_35975_);
            TFEventListener.keepWholeList((NonNullList<ItemStack>)keepInventory.f_35976_, (NonNullList<ItemStack>)player.m_150109_().f_35976_);
        }
        if (tier3) {
            TFEventListener.keepWholeList((NonNullList<ItemStack>)keepInventory.f_35974_, (NonNullList<ItemStack>)player.m_150109_().f_35974_);
            charmUsed = new ItemStack((ItemLike)TFItems.CHARM_OF_KEEPING_3.get());
        } else if (tier2) {
            for (i = 0; i < 9; ++i) {
                keepInventory.f_35974_.set(i, (Object)((ItemStack)player.m_150109_().f_35974_.get(i)).m_41777_());
                player.m_150109_().f_35974_.set(i, (Object)ItemStack.f_41583_);
            }
            charmUsed = new ItemStack((ItemLike)TFItems.CHARM_OF_KEEPING_2.get());
        } else if (tier1) {
            i = player.m_150109_().f_35977_;
            if (Inventory.m_36045_((int)i)) {
                keepInventory.f_35974_.set(i, (Object)((ItemStack)player.m_150109_().f_35974_.get(i)).m_41777_());
                player.m_150109_().f_35974_.set(i, (Object)ItemStack.f_41583_);
            }
            charmUsed = new ItemStack((ItemLike)TFItems.CHARM_OF_KEEPING_1.get());
        }
        for (i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
            ItemStack stack = (ItemStack)player.m_150109_().f_35974_.get(i);
            if (stack.m_41720_() == TFItems.TOWER_KEY.get()) {
                keepInventory.f_35974_.set(i, (Object)stack.m_41777_());
                player.m_150109_().f_35974_.set(i, (Object)ItemStack.f_41583_);
            }
            if (!(stack.m_41720_() instanceof PhantomArmorItem)) continue;
            keepInventory.f_35974_.set(i, (Object)stack.m_41777_());
            player.m_150109_().f_35974_.set(i, (Object)ItemStack.f_41583_);
        }
        for (i = 0; i < player.m_150109_().f_35975_.size(); ++i) {
            ItemStack armor = (ItemStack)player.m_150109_().f_35975_.get(i);
            if (!(armor.m_41720_() instanceof PhantomArmorItem)) continue;
            keepInventory.f_35975_.set(i, (Object)armor.m_41777_());
            player.m_150109_().f_35975_.set(i, (Object)ItemStack.f_41583_);
        }
        keepInventory.m_36026_(tagList);
        TFEventListener.getPlayerData(player).m_128365_(CHARM_INV_TAG, (Tag)tagList);
    }

    private static void keepWholeList(NonNullList<ItemStack> transferTo, NonNullList<ItemStack> transferFrom) {
        for (int i = 0; i < transferFrom.size(); ++i) {
            transferTo.set(i, (Object)((ItemStack)transferFrom.get(i)).m_41777_());
        }
        transferFrom.clear();
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getPlayer();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (event.isEndConquered()) {
            TFEventListener.updateCapabilities(serverPlayer, (Entity)serverPlayer);
        } else {
            if (casketExpiration) {
                serverPlayer.m_6352_((Component)new TranslatableComponent("block.twilightforest.casket.broken").m_130940_(ChatFormatting.DARK_RED), serverPlayer.m_142081_());
            }
            TFEventListener.returnStoredItems((Player)serverPlayer);
        }
        if (((Boolean)TFConfig.COMMON_CONFIG.DIMENSION.newPlayersSpawnInTF.get()).booleanValue() && serverPlayer.m_8961_() == null) {
            CompoundTag tagCompound = serverPlayer.getPersistentData();
            CompoundTag playerData = tagCompound.m_128469_("PlayerPersisted");
            playerData.m_128379_(NBT_TAG_TWILIGHT, false);
            tagCompound.m_128365_("PlayerPersisted", (Tag)playerData);
            TFEventListener.banishNewbieToTwilightZone((Player)serverPlayer);
        }
    }

    private static void returnStoredItems(Player player) {
        TwilightForestMod.LOGGER.debug("Player {} ({}) respawned and received items held in storage", (Object)player.m_7755_().getString(), (Object)player.m_142081_());
        CompoundTag playerData = TFEventListener.getPlayerData(player);
        if (!player.f_19853_.f_46443_ && playerData.m_128441_(CHARM_INV_TAG)) {
            ListTag tagList = playerData.m_128437_(CHARM_INV_TAG, 10);
            player.m_150109_().m_36035_(tagList);
            TFEventListener.getPlayerData(player).m_128437_(CHARM_INV_TAG, 10).clear();
            TFEventListener.getPlayerData(player).m_128473_(CHARM_INV_TAG);
        }
        if (charmUsed != null) {
            CharmEffect effect = new CharmEffect((EntityType<? extends CharmEffect>)((EntityType)TFEntities.CHARM_EFFECT.get()), player.f_19853_, (LivingEntity)player, charmUsed.m_41720_());
            player.f_19853_.m_7967_((Entity)effect);
            CharmEffect effect2 = new CharmEffect((EntityType<? extends CharmEffect>)((EntityType)TFEntities.CHARM_EFFECT.get()), player.f_19853_, (LivingEntity)player, charmUsed.m_41720_());
            effect2.offset = (float)Math.PI;
            player.f_19853_.m_7967_((Entity)effect2);
            player.f_19853_.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), TFSounds.CHARM_KEEP, player.m_5720_(), 1.5f, 1.0f);
            if (player instanceof ServerPlayer) {
                player.m_36220_((ResourceLocation)TFStats.KEEPING_CHARMS_ACTIVATED.get());
            }
            charmUsed = null;
        }
    }

    @SubscribeEvent
    public static void livingUpdate(LivingEvent.LivingUpdateEvent event) {
        event.getEntityLiving().getCapability(CapabilityList.SHIELDS).ifPresent(IShieldCapability::update);
        if (event.getEntityLiving() instanceof IHostileMount) {
            event.getEntityLiving().m_20197_().forEach(e -> e.m_20260_(false));
        }
    }

    @SubscribeEvent
    public static void preventMountDismount(EntityMountEvent event) {
        LivingEntity living;
        Entity entity;
        if (!event.getEntityBeingMounted().f_19853_.m_5776_() && !event.isMounting() && event.getEntityBeingMounted().m_6084_() && (entity = event.getEntityMounting()) instanceof LivingEntity && (living = (LivingEntity)entity).m_6084_() && TFEventListener.isRidingUnfriendly(living) && !allowDismount) {
            event.setCanceled(true);
        }
    }

    public static boolean isRidingUnfriendly(LivingEntity entity) {
        return entity.m_20159_() && entity.m_20202_() instanceof IHostileMount;
    }

    @SubscribeEvent
    public static void breakBlock(BlockEvent.BreakEvent event) {
        Level world;
        BlockState state;
        BlockPos pos;
        Player player;
        block13: {
            block12: {
                player = event.getPlayer();
                pos = event.getPos();
                state = event.getState();
                LevelAccessor levelAccessor = event.getWorld();
                if (!(levelAccessor instanceof Level)) break block12;
                world = (Level)levelAccessor;
                if (!((Level)event.getWorld()).f_46443_) break block13;
            }
            return;
        }
        if (TFEventListener.isBlockProtectedFromBreaking(world, pos) && TFEventListener.isAreaProtected(world, player, pos)) {
            event.setCanceled(true);
        } else if (!isBreakingWithGiantPick && TFEventListener.canHarvestWithGiantPick(player, state)) {
            boolean allCobble;
            isBreakingWithGiantPick = true;
            Item cobbleItem = Blocks.f_50652_.m_5456_();
            boolean bl = allCobble = state.m_60734_().m_5456_() == cobbleItem;
            if (allCobble) {
                for (BlockPos dPos : GiantBlock.getVolume(pos)) {
                    BlockState stateThere;
                    if (dPos.equals((Object)pos) || (stateThere = world.m_8055_(dPos)).m_60734_().m_5456_() == cobbleItem) continue;
                    allCobble = false;
                    break;
                }
            }
            if (allCobble && !player.m_150110_().f_35937_) {
                shouldMakeGiantCobble = true;
                amountOfCobbleToReplace = 64;
            } else {
                shouldMakeGiantCobble = false;
                amountOfCobbleToReplace = 0;
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer playerMP = (ServerPlayer)player;
                for (BlockPos dPos : GiantBlock.getVolume(pos)) {
                    if (dPos.equals((Object)pos) || state.m_60734_() != world.m_8055_(dPos).m_60734_()) continue;
                    playerMP.f_8941_.m_9280_(dPos);
                }
            }
            isBreakingWithGiantPick = false;
        }
    }

    private static boolean canHarvestWithGiantPick(Player player, BlockState state) {
        ItemStack heldStack = player.m_21205_();
        Item heldItem = heldStack.m_41720_();
        return heldItem == TFItems.GIANT_PICKAXE.get() && ForgeHooks.isCorrectToolForDrops((BlockState)state, (Player)player);
    }

    @SubscribeEvent
    public static void onPlayerRightClick(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getPlayer();
        Level world = player.f_19853_;
        if (!world.f_46443_ && TFEventListener.isBlockProtectedFromInteraction(world, event.getPos()) && TFEventListener.isAreaProtected(world, player, event.getPos())) {
            event.setUseBlock(Event.Result.DENY);
        }
    }

    private static boolean isBlockProtectedFromInteraction(Level world, BlockPos pos) {
        return world.m_8055_(pos).m_204336_(BlockTagGenerator.STRUCTURE_BANNED_INTERACTIONS);
    }

    private static boolean isBlockProtectedFromBreaking(Level world, BlockPos pos) {
        return !world.m_8055_(pos).m_60734_().getRegistryName().m_135815_().contains("grave") || !world.m_8055_(pos).m_60713_((Block)TFBlocks.KEEPSAKE_CASKET.get());
    }

    private static boolean isAreaProtected(Level world, Player player, BlockPos pos) {
        TFFeature nearbyFeature;
        StructureStart structure;
        Optional<StructureStart> struct;
        if (player.m_150110_().f_35937_ || !TFGenerationSettings.isProgressionEnforced(world) || player instanceof FakePlayer) {
            return false;
        }
        ChunkGeneratorTwilight chunkGenerator = WorldUtil.getChunkGenerator((LevelAccessor)world);
        if (chunkGenerator != null && (struct = TFGenerationSettings.locateTFStructureInRange((WorldGenLevel)((ServerLevel)world), pos, 0)).isPresent() && (structure = struct.get()).m_73601_().m_71051_((Vec3i)pos) && !(nearbyFeature = TFFeature.getFeatureAt(pos.m_123341_(), pos.m_123343_(), (WorldGenLevel)((ServerLevel)world))).doesPlayerHaveRequiredAdvancements(player)) {
            if (nearbyFeature == TFFeature.KNIGHT_STRONGHOLD && pos.m_123342_() >= 0) {
                return false;
            }
            ArrayList<BoundingBox> boxes = new ArrayList<BoundingBox>();
            structure.m_73602_().forEach(piece -> {
                if (piece.m_73547_().m_71051_((Vec3i)pos)) {
                    boxes.add(piece.m_73547_());
                }
            });
            TFEventListener.sendAreaProtectionPacket(world, pos, boxes);
            nearbyFeature.trySpawnHintMonster(world, player, pos);
            return true;
        }
        return false;
    }

    private static void sendAreaProtectionPacket(Level world, BlockPos pos, List<BoundingBox> sbb) {
        PacketDistributor.TargetPoint targetPoint = new PacketDistributor.TargetPoint((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), 64.0, world.m_46472_());
        TFPacketHandler.CHANNEL.send(PacketDistributor.NEAR.with(() -> targetPoint), (Object)new AreaProtectionPacket(sbb, pos));
    }

    @SubscribeEvent
    public static void livingAttack(LivingAttackEvent event) {
        LivingEntity living = event.getEntityLiving();
        if (!living.f_19853_.f_46443_ && living instanceof Enemy && event.getSource().m_7639_() instanceof Player && !(living instanceof Kobold) && TFEventListener.isAreaProtected(living.f_19853_, (Player)event.getSource().m_7639_(), new BlockPos((Vec3i)living.m_142538_()))) {
            event.setCanceled(true);
            return;
        }
        if (!living.f_19853_.f_46443_ && !SHIELD_DAMAGE_BLACKLIST.contains((Object)event.getSource().f_19326_)) {
            living.getCapability(CapabilityList.SHIELDS).ifPresent(cap -> {
                if (cap.shieldsLeft() > 0) {
                    cap.breakShield();
                    event.setCanceled(true);
                }
            });
        }
    }

    @SubscribeEvent
    public static void playerLogsIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.getPlayer().f_19853_.f_46443_ && event.getPlayer() instanceof ServerPlayer) {
            TFEventListener.sendEnforcedProgressionStatus((ServerPlayer)event.getPlayer(), TFGenerationSettings.isProgressionEnforced(event.getPlayer().f_19853_));
            TFEventListener.updateCapabilities((ServerPlayer)event.getPlayer(), (Entity)event.getPlayer());
            TFEventListener.banishNewbieToTwilightZone(event.getPlayer());
        }
    }

    @SubscribeEvent
    public static void playerPortals(PlayerEvent.PlayerChangedDimensionEvent event) {
        Player player;
        if (!event.getPlayer().f_19853_.f_46443_ && (player = event.getPlayer()) instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            if (TFGenerationSettings.usesTwilightChunkGenerator(player2.m_183503_())) {
                TFEventListener.sendEnforcedProgressionStatus((ServerPlayer)event.getPlayer(), TFGenerationSettings.isProgressionEnforced((Level)player2.m_183503_()));
            }
            TFEventListener.updateCapabilities(player2, (Entity)event.getPlayer());
        }
    }

    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking event) {
        TFEventListener.updateCapabilities((ServerPlayer)event.getPlayer(), event.getTarget());
    }

    private static void updateCapabilities(ServerPlayer clientTarget, Entity shielded) {
        shielded.getCapability(CapabilityList.SHIELDS).ifPresent(cap -> {
            if (cap.shieldsLeft() > 0) {
                TFPacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> clientTarget), (Object)new UpdateShieldPacket(shielded, (IShieldCapability)cap));
            }
        });
    }

    private static void sendEnforcedProgressionStatus(ServerPlayer player, boolean isEnforced) {
        TFPacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new EnforceProgressionStatusPacket(isEnforced));
    }

    private static void banishNewbieToTwilightZone(Player player) {
        CompoundTag tagCompound = player.getPersistentData();
        CompoundTag playerData = tagCompound.m_128469_("PlayerPersisted");
        boolean shouldBanishPlayer = (Boolean)TFConfig.COMMON_CONFIG.DIMENSION.newPlayersSpawnInTF.get() != false && !playerData.m_128471_(NBT_TAG_TWILIGHT);
        playerData.m_128379_(NBT_TAG_TWILIGHT, true);
        tagCompound.m_128365_("PlayerPersisted", (Tag)playerData);
        if (shouldBanishPlayer) {
            TFPortalBlock.attemptSendEntity((Entity)player, true, (Boolean)TFConfig.COMMON_CONFIG.DIMENSION.portalForNewPlayerSpawn.get());
        }
    }

    @SubscribeEvent
    public static void armorChanged(LivingEquipmentChangeEvent event) {
        LivingEntity living = event.getEntityLiving();
        if (!living.f_19853_.f_46443_ && living instanceof ServerPlayer) {
            TFAdvancements.ARMOR_CHANGED.trigger((ServerPlayer)living, event.getFrom(), event.getTo());
        }
    }

    @SubscribeEvent
    public static void throwableParry(ProjectileImpactEvent event) {
        final Projectile projectile = event.getProjectile();
        if (!projectile.m_20193_().f_46443_ && globalParry && (((Boolean)TFConfig.COMMON_CONFIG.SHIELD_INTERACTIONS.parryNonTwilightAttacks.get()).booleanValue() || projectile instanceof ITFProjectile) && event.getRayTraceResult() instanceof EntityHitResult) {
            LivingEntity entityBlocking;
            Entity entity = ((EntityHitResult)event.getRayTraceResult()).m_82443_();
            if (event.getEntity() != null && entity instanceof LivingEntity && (entityBlocking = (LivingEntity)entity).m_21275_(new DamageSource("parry_this"){

                public Vec3 m_7270_() {
                    return projectile.m_20182_();
                }
            }) && entityBlocking.m_21211_().m_41720_().m_8105_(entityBlocking.m_21211_()) - entityBlocking.m_21212_() <= (Integer)TFConfig.COMMON_CONFIG.SHIELD_INTERACTIONS.shieldParryTicksThrowable.get()) {
                Vec3 playerVec3 = entityBlocking.m_20154_();
                projectile.m_6686_(playerVec3.f_82479_, playerVec3.f_82480_, playerVec3.f_82481_, 1.1f, 0.1f);
                projectile.m_5602_((Entity)entityBlocking);
                event.setCanceled(true);
            }
        }
    }

    static {
        allowDismount = false;
        globalParry = !ModList.get().isLoaded("parry");
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<ManipulateDrops> {
        public ManipulateDrops read(ResourceLocation name, JsonObject json, LootItemCondition[] conditionsIn) {
            return new ManipulateDrops(conditionsIn);
        }

        public JsonObject write(ManipulateDrops instance) {
            return null;
        }
    }

    public static class ManipulateDrops
    extends LootModifier {
        protected ManipulateDrops(LootItemCondition[] conditionsIn) {
            super(conditionsIn);
        }

        @Nonnull
        protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
            ArrayList<ItemStack> newLoot = new ArrayList<ItemStack>();
            boolean flag = false;
            if (shouldMakeGiantCobble && generatedLoot.size() > 0 && generatedLoot.get(0).m_41720_() == Item.m_41439_((Block)Blocks.f_50652_)) {
                generatedLoot.remove(0);
                if (amountOfCobbleToReplace == 64) {
                    newLoot.add(new ItemStack((ItemLike)TFBlocks.GIANT_COBBLESTONE.get()));
                    flag = true;
                }
                if (--amountOfCobbleToReplace <= 0) {
                    shouldMakeGiantCobble = false;
                }
            }
            return flag ? newLoot : generatedLoot;
        }
    }
}

