/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.PacketDistributor;
import twilightforest.block.SpecialMagicLogBlock;
import twilightforest.client.particle.TFParticleType;
import twilightforest.network.ParticlePacket;
import twilightforest.network.TFPacketHandler;
import twilightforest.util.WorldUtil;

public class SortLogCoreBlock
extends SpecialMagicLogBlock {
    public SortLogCoreBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    @Override
    void performTreeEffect(Level world, BlockPos pos, Random rand) {
        HashMap<Container, BlockPos> inputChests = new HashMap<Container, BlockPos>();
        HashMap<Container, BlockPos> outputChests = new HashMap<Container, BlockPos>();
        for (BlockPos blockPos : WorldUtil.getAllAround(pos, 16)) {
            Block block;
            if (blockPos.equals((Object)pos) || !((block = world.m_8055_(blockPos).m_60734_()) instanceof ChestBlock)) continue;
            ChestBlock chestBlock = (ChestBlock)block;
            Container chest = ChestBlock.m_51511_((ChestBlock)chestBlock, (BlockState)world.m_8055_(blockPos), (Level)world, (BlockPos)blockPos, (boolean)true);
            BlockPos newPos = new BlockPos(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
            if (newPos.m_123314_((Vec3i)pos, 2.0)) {
                inputChests.put(chest, newPos);
                continue;
            }
            outputChests.put(chest, newPos);
        }
        if (outputChests.isEmpty()) {
            return;
        }
        block1: for (Container inputChest : inputChests.keySet()) {
            for (int i = 0; i < inputChest.m_6643_(); ++i) {
                ItemStack inputStack = inputChest.m_8020_(i);
                if (inputStack.m_41619_()) continue;
                boolean transferred = false;
                List<Container> outputChestsSorted = outputChests.keySet().stream().filter(container -> {
                    int count = container.m_18947_(inputStack.m_41720_());
                    return count > 0 && count < container.m_6643_() * inputStack.m_41741_();
                }).sorted(Comparator.comparingInt(container -> Integer.MAX_VALUE - container.m_18947_(inputStack.m_41720_()))).toList();
                for (Container outputChest : outputChestsSorted) {
                    int firstEmptyStack = -1;
                    for (int j = 0; j < outputChest.m_6643_(); ++j) {
                        ItemStack outputStack = outputChest.m_8020_(j);
                        if (outputStack.m_41619_() && firstEmptyStack == -1) {
                            firstEmptyStack = j;
                            continue;
                        }
                        if (!ItemStack.m_150942_((ItemStack)inputStack, (ItemStack)outputStack) || outputStack.m_41613_() >= outputStack.m_41741_()) continue;
                        outputStack.m_41769_(1);
                        inputStack.m_41774_(1);
                        firstEmptyStack = -1;
                        transferred = true;
                        break;
                    }
                    if (firstEmptyStack != -1) {
                        ItemStack newStack = inputStack.m_41777_();
                        newStack.m_41764_(1);
                        outputChest.m_6836_(firstEmptyStack, newStack);
                        inputStack.m_41774_(1);
                        transferred = true;
                    }
                    if (!transferred) continue;
                    Vec3 xyz = Vec3.m_82514_((Vec3i)((Vec3i)outputChests.get(outputChest)), (double)1.9);
                    Vec3 diff = Vec3.m_82514_((Vec3i)((Vec3i)inputChests.get(inputChest)), (double)1.9).m_82546_(xyz);
                    for (ServerPlayer serverplayer : ((ServerLevel)world).m_6907_()) {
                        if (!(serverplayer.m_20238_(xyz) < 4096.0)) continue;
                        ParticlePacket particlePacket = new ParticlePacket();
                        double x = diff.f_82479_ - 0.25 + rand.nextDouble() * 0.5;
                        double y = diff.f_82480_ - 1.75 + rand.nextDouble() * 0.5;
                        double z = diff.f_82481_ - 0.25 + rand.nextDouble() * 0.5;
                        particlePacket.queueParticle((ParticleOptions)TFParticleType.SORTING_PARTICLE.get(), false, xyz, new Vec3(x, y, z).m_82490_(1.0 / diff.m_82553_()));
                        TFPacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverplayer), (Object)particlePacket);
                    }
                }
                if (transferred) continue block1;
            }
        }
    }
}

