/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.model.entity;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import twilightforest.entity.ProtectionBox;

public class ProtectionBoxModel<T extends ProtectionBox>
extends ListModel<T> {
    private T entity;
    public ModelPart box;
    private int lastPixelsX;
    private int lastPixelsY;
    private int lastPixelsZ;

    public ProtectionBoxModel(ModelPart root) {
        this.box = root.m_171324_("box");
    }

    public static MeshDefinition createMesh() {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition partRoot = mesh.m_171576_();
        partRoot.m_171599_("box", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(0.0f, 0.0f, 0.0f, 16.0f, 16.0f, 16.0f), PartPose.f_171404_);
        return mesh;
    }

    public Iterable<ModelPart> m_6195_() {
        return ImmutableList.of((Object)this.box);
    }

    public void m_7695_(PoseStack stack, VertexConsumer builder, int light, int overlay, float red, float green, float blue, float alpha) {
        T boxEntity = this.entity;
        int pixelsX = ((ProtectionBox)((Object)boxEntity)).sizeX * 16 + 2;
        int pixelsY = ((ProtectionBox)((Object)boxEntity)).sizeY * 16 + 2;
        int pixelsZ = ((ProtectionBox)((Object)boxEntity)).sizeZ * 16 + 2;
        if (pixelsX != this.lastPixelsX || pixelsY != this.lastPixelsY || pixelsZ != this.lastPixelsZ) {
            this.resizeBoxElement(pixelsX, pixelsY, pixelsZ);
        }
        super.m_7695_(stack, builder, light, overlay, red, green, blue, alpha);
    }

    public void setupAnim(T entity, float v, float v1, float v2, float v3, float v4) {
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTicks) {
        this.entity = entity;
    }

    private void resizeBoxElement(int pixelsX, int pixelsY, int pixelsZ) {
        MeshDefinition mesh = ProtectionBoxModel.createMesh();
        PartDefinition partRoot = mesh.m_171576_();
        partRoot.m_171599_("box", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-1.0f, -1.0f, -1.0f, (float)pixelsX, (float)pixelsY, (float)pixelsZ), PartPose.f_171404_);
        this.box = partRoot.m_171597_("box").m_171583_(16, 16);
        this.lastPixelsX = pixelsX;
        this.lastPixelsY = pixelsY;
        this.lastPixelsZ = pixelsZ;
    }
}

