/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.boss;

import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import twilightforest.TFSounds;
import twilightforest.advancements.TFAdvancements;
import twilightforest.block.TFBlocks;
import twilightforest.entity.NoClipMoveHelper;
import twilightforest.entity.ai.PhantomAttackStartGoal;
import twilightforest.entity.ai.PhantomThrowWeaponGoal;
import twilightforest.entity.ai.PhantomUpdateFormationAndMoveGoal;
import twilightforest.entity.ai.PhantomWatchAndAttackGoal;
import twilightforest.item.TFItems;
import twilightforest.loot.TFTreasure;
import twilightforest.util.TFDamageSources;
import twilightforest.world.registration.TFFeature;
import twilightforest.world.registration.TFGenerationSettings;

public class KnightPhantom
extends FlyingMob
implements Enemy {
    private static final EntityDataAccessor<Boolean> FLAG_CHARGING = SynchedEntityData.m_135353_(KnightPhantom.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final AttributeModifier CHARGING_MODIFIER = new AttributeModifier("Charging attack boost", 7.0, AttributeModifier.Operation.ADDITION);
    private int number;
    private int ticksProgress;
    private Formation currentFormation;
    private BlockPos chargePos = BlockPos.f_121853_;
    private final List<ServerPlayer> hurtBy = new ArrayList<ServerPlayer>();
    private BlockPos homePosition = BlockPos.f_121853_;
    private float maximumHomeDistance = -1.0f;

    public KnightPhantom(EntityType<? extends KnightPhantom> type, Level world) {
        super(type, world);
        this.f_19794_ = true;
        this.m_5825_();
        this.currentFormation = Formation.HOVER;
        this.f_21364_ = 93;
        this.f_21342_ = new NoClipMoveHelper((Mob)this);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        SpawnGroupData data = super.m_6518_(worldIn, difficulty, reason, spawnDataIn, dataTag);
        this.m_6851_(difficulty);
        this.m_6850_(difficulty);
        return data;
    }

    protected void m_6851_(DifficultyInstance difficulty) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)TFItems.KNIGHTMETAL_SWORD.get()));
        this.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)TFItems.PHANTOM_CHESTPLATE.get()));
        this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)TFItems.PHANTOM_HELMET.get()));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FLAG_CHARGING, (Object)false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new PhantomWatchAndAttackGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new PhantomUpdateFormationAndMoveGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new PhantomAttackStartGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new PhantomThrowWeaponGoal(this));
        this.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 35.0).m_22268_(Attributes.f_22281_, 1.0);
    }

    public Formation getCurrentFormation() {
        return this.currentFormation;
    }

    public BlockPos getChargePos() {
        return this.chargePos;
    }

    public void setChargePos(BlockPos pos) {
        this.chargePos = pos;
    }

    public boolean m_6785_(double p_213397_1_) {
        return false;
    }

    public boolean m_6673_(DamageSource src) {
        return src == DamageSource.f_19310_ || super.m_6673_(src);
    }

    public void m_6043_() {
        if (this.f_19853_.m_46791_() == Difficulty.PEACEFUL) {
            if (this.hasHome() && this.getNumber() == 0) {
                this.f_19853_.m_46597_(this.m_21534_(), ((Block)TFBlocks.KNIGHT_PHANTOM_BOSS_SPAWNER.get()).m_49966_());
            }
            this.m_146870_();
        } else {
            super.m_6043_();
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.isChargingAtPlayer()) {
            for (int i = 0; i < 4; ++i) {
                Item particleID = this.f_19796_.nextBoolean() ? (Item)TFItems.PHANTOM_HELMET.get() : (Item)TFItems.KNIGHTMETAL_SWORD.get();
                this.f_19853_.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)particleID)), this.m_20185_() + ((double)this.f_19796_.nextFloat() - 0.5) * (double)this.m_20205_(), this.m_20186_() + (double)this.f_19796_.nextFloat() * ((double)this.m_20206_() - 0.75) + 0.5, this.m_20189_() + ((double)this.f_19796_.nextFloat() - 0.5) * (double)this.m_20205_(), 0.0, -0.1, 0.0);
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_() + ((double)this.f_19796_.nextFloat() - 0.5) * (double)this.m_20205_(), this.m_20186_() + (double)this.f_19796_.nextFloat() * ((double)this.m_20206_() - 0.75) + 0.5, this.m_20189_() + ((double)this.f_19796_.nextFloat() - 0.5) * (double)this.m_20205_(), 0.0, 0.1, 0.0);
            }
        }
    }

    protected void m_6153_() {
        super.m_6153_();
        for (int i = 0; i < 20; ++i) {
            double d0 = this.f_19796_.nextGaussian() * 0.02;
            double d1 = this.f_19796_.nextGaussian() * 0.02;
            double d2 = this.f_19796_.nextGaussian() * 0.02;
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_() + (double)(this.f_19796_.nextFloat() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_20186_() + (double)(this.f_19796_.nextFloat() * this.m_20206_()), this.m_20189_() + (double)(this.f_19796_.nextFloat() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), d0, d1, d2);
        }
    }

    public void m_6667_(DamageSource cause) {
        super.m_6667_(cause);
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.getNearbyKnights().isEmpty() && cause != DamageSource.f_19317_) {
                BlockPos treasurePos = this.hasHome() ? this.m_21534_().m_7495_() : new BlockPos((Vec3i)this.m_142538_());
                TFTreasure.STRONGHOLD_BOSS.generateChest((WorldGenLevel)serverLevel, treasurePos, Direction.NORTH, false);
                Entity entity = cause.m_7639_();
                if (entity instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)entity;
                    TFAdvancements.KILL_ALL_PHANTOMS.trigger(player);
                }
                TFGenerationSettings.markStructureConquered(this.f_19853_, treasurePos, TFFeature.KNIGHT_STRONGHOLD);
                for (ServerPlayer player : this.hurtBy) {
                    TFAdvancements.HURT_BOSS.trigger(player, (Entity)this);
                }
                for (ServerPlayer player : this.f_19853_.m_45976_(ServerPlayer.class, new AABB(this.homePosition).m_82400_(10.0))) {
                    TFAdvancements.HURT_BOSS.trigger(player, (Entity)this);
                }
            }
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        ServerPlayer player;
        Entity entity;
        if (this.m_21275_(source)) {
            this.m_5496_(SoundEvents.f_12346_, 1.0f, 0.8f + this.f_19853_.f_46441_.nextFloat() * 0.4f);
        }
        if ((entity = source.m_7639_()) instanceof ServerPlayer && !this.hurtBy.contains(player = (ServerPlayer)entity)) {
            this.hurtBy.add(player);
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_7327_(Entity entity) {
        boolean flag;
        int i;
        float f = (float)this.m_21133_(Attributes.f_22281_);
        float f1 = (float)this.m_21133_(Attributes.f_22282_);
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            f += EnchantmentHelper.m_44833_((ItemStack)this.m_21205_(), (MobType)living.m_6336_());
            f1 += (float)EnchantmentHelper.m_44894_((LivingEntity)this);
        }
        if ((i = EnchantmentHelper.m_44914_((LivingEntity)this)) > 0) {
            entity.m_20254_(i * 4);
        }
        if (flag = entity.m_6469_(TFDamageSources.haunt((LivingEntity)this), f)) {
            if (f1 > 0.0f && entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                living.m_147240_((double)(f1 * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                this.m_20256_(this.m_20184_().m_82542_(0.6, 1.0, 0.6));
            }
            if (entity instanceof Player) {
                Player player = (Player)entity;
                this.m_21424_(player, this.m_21205_(), player.m_6117_() ? player.m_21211_() : ItemStack.f_41583_);
            }
            this.m_19970_((LivingEntity)this, entity);
            this.m_21335_(entity);
        }
        return flag;
    }

    public boolean m_6094_() {
        return true;
    }

    public void m_147240_(double damage, double xRatio, double zRatio) {
        this.f_19812_ = true;
        float f = Mth.m_14116_((float)((float)(xRatio * xRatio + zRatio * zRatio)));
        float distance = 0.2f;
        this.m_20256_(new Vec3(this.m_20184_().m_7096_() / 2.0, this.m_20184_().m_7098_() / 2.0, this.m_20184_().m_7094_() / 2.0));
        this.m_20256_(new Vec3(this.m_20184_().m_7096_() - xRatio / (double)f * (double)distance, this.m_20184_().m_7098_() + (double)distance, this.m_20184_().m_7094_() - zRatio / (double)f * (double)distance));
        if (this.m_20184_().m_7098_() > (double)0.4f) {
            this.m_20334_(this.m_20184_().m_7096_(), 0.4f, this.m_20184_().m_7094_());
        }
    }

    public List<KnightPhantom> getNearbyKnights() {
        return this.f_19853_.m_6443_(KnightPhantom.class, new AABB(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_20185_() + 1.0, this.m_20186_() + 1.0, this.m_20189_() + 1.0).m_82377_(32.0, 8.0, 32.0), LivingEntity::m_6084_);
    }

    private void updateMyNumber() {
        ArrayList nums = Lists.newArrayList();
        List<KnightPhantom> knights = this.getNearbyKnights();
        for (KnightPhantom knight : knights) {
            if (knight == this) continue;
            nums.add(knight.getNumber());
            if (knight.getNumber() != 0) continue;
            this.m_21446_(knight.m_21534_(), 20);
        }
        if (nums.isEmpty()) {
            return;
        }
        int[] n = Ints.toArray((Collection)nums);
        Arrays.sort(n);
        int smallest = n[0];
        int largest = knights.size() + 1;
        int smallestUnused = largest + 1;
        if (smallest > 0) {
            smallestUnused = 0;
        } else {
            for (int i = 1; i < largest; ++i) {
                if (Arrays.binarySearch(n, i) >= 0) continue;
                smallestUnused = i;
                break;
            }
        }
        if (this.number > smallestUnused || nums.contains(this.number)) {
            this.setNumber(smallestUnused);
        }
    }

    public boolean isChargingAtPlayer() {
        return (Boolean)this.f_19804_.m_135370_(FLAG_CHARGING);
    }

    private void setChargingAtPlayer(boolean flag) {
        this.f_19804_.m_135381_(FLAG_CHARGING, (Object)flag);
        if (!this.f_19853_.f_46443_) {
            if (flag) {
                if (!this.m_21051_(Attributes.f_22281_).m_22109_(CHARGING_MODIFIER)) {
                    this.m_21051_(Attributes.f_22281_).m_22118_(CHARGING_MODIFIER);
                }
            } else {
                this.m_21051_(Attributes.f_22281_).m_22130_(CHARGING_MODIFIER);
            }
        }
    }

    protected SoundEvent m_7515_() {
        return TFSounds.PHANTOM_AMBIENT;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return TFSounds.PHANTOM_HURT;
    }

    protected SoundEvent m_5592_() {
        return TFSounds.PHANTOM_DEATH;
    }

    private void switchToFormationByNumber(int formationNumber) {
        this.currentFormation = Formation.values()[formationNumber];
        this.ticksProgress = 0;
    }

    public void switchToFormation(Formation formation) {
        this.currentFormation = formation;
        this.ticksProgress = 0;
        this.updateMyNumber();
        this.setChargingAtPlayer(this.currentFormation == Formation.ATTACK_PLAYER_START || this.currentFormation == Formation.ATTACK_PLAYER_ATTACK);
    }

    private int getFormationAsNumber() {
        return this.currentFormation.ordinal();
    }

    public int getTicksProgress() {
        return this.ticksProgress;
    }

    public void setTicksProgress(int ticksProgress) {
        this.ticksProgress = ticksProgress;
    }

    public int getMaxTicksForFormation() {
        return this.currentFormation.duration;
    }

    public boolean isSwordKnight() {
        return this.m_21205_().m_41720_() == TFItems.KNIGHTMETAL_SWORD.get();
    }

    public boolean isAxeKnight() {
        return this.m_21205_().m_41720_() == TFItems.KNIGHTMETAL_AXE.get();
    }

    public boolean isPickKnight() {
        return this.m_21205_().m_41720_() == TFItems.KNIGHTMETAL_PICKAXE.get();
    }

    public int getNumber() {
        return this.number;
    }

    public void setNumber(int number) {
        this.number = number;
        switch (number % 3) {
            case 0: {
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)TFItems.KNIGHTMETAL_SWORD.get()));
                break;
            }
            case 1: {
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)TFItems.KNIGHTMETAL_AXE.get()));
                break;
            }
            case 2: {
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)TFItems.KNIGHTMETAL_PICKAXE.get()));
            }
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.hasHome()) {
            BlockPos home = this.m_21534_();
            compound.m_128365_("Home", (Tag)this.m_20063_(new double[]{home.m_123341_(), home.m_123342_(), home.m_123343_()}));
        }
        compound.m_128405_("MyNumber", this.getNumber());
        compound.m_128405_("Formation", this.getFormationAsNumber());
        compound.m_128405_("TicksProgress", this.getTicksProgress());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128425_("Home", 9)) {
            ListTag nbttaglist = compound.m_128437_("Home", 6);
            int hx = (int)nbttaglist.m_128772_(0);
            int hy = (int)nbttaglist.m_128772_(1);
            int hz = (int)nbttaglist.m_128772_(2);
            this.m_21446_(new BlockPos(hx, hy, hz), 20);
        } else {
            this.m_21536_();
        }
        this.setNumber(compound.m_128451_("MyNumber"));
        this.switchToFormationByNumber(compound.m_128451_("Formation"));
        this.setTicksProgress(compound.m_128451_("TicksProgress"));
    }

    protected boolean m_7341_(Entity entityIn) {
        return false;
    }

    public boolean m_6063_() {
        return false;
    }

    protected float m_6108_() {
        return 1.0f;
    }

    public boolean m_6072_() {
        return false;
    }

    public boolean m_21533_() {
        return this.m_21444_(new BlockPos((Vec3i)this.m_142538_()));
    }

    public boolean m_21444_(BlockPos pos) {
        return this.maximumHomeDistance == -1.0f || this.homePosition.m_123331_((Vec3i)pos) < (double)(this.maximumHomeDistance * this.maximumHomeDistance);
    }

    public void m_21446_(BlockPos pos, int distance) {
        this.homePosition = this.chargePos = pos;
        this.maximumHomeDistance = distance;
    }

    public BlockPos m_21534_() {
        return this.homePosition;
    }

    public float m_21535_() {
        return this.maximumHomeDistance;
    }

    public boolean m_21536_() {
        this.maximumHomeDistance = -1.0f;
        return false;
    }

    public boolean hasHome() {
        return this.maximumHomeDistance != -1.0f;
    }

    public static enum Formation {
        HOVER(90),
        LARGE_CLOCKWISE(180),
        SMALL_CLOCKWISE(90),
        LARGE_ANTICLOCKWISE(180),
        SMALL_ANTICLOCKWISE(90),
        CHARGE_PLUSX(180),
        CHARGE_MINUSX(180),
        CHARGE_PLUSZ(180),
        CHARGE_MINUSZ(180),
        WAITING_FOR_LEADER(10),
        ATTACK_PLAYER_START(50),
        ATTACK_PLAYER_ATTACK(50);

        final int duration;

        private Formation(int duration) {
            this.duration = duration;
        }
    }
}

