/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;
import twilightforest.capabilities.CapabilityList;
import twilightforest.capabilities.shield.IShieldCapability;

public class UpdateShieldPacket {
    private final int entityID;
    private final int temporaryShields;
    private final int permanentShields;

    public UpdateShieldPacket(int id, IShieldCapability cap) {
        this.entityID = id;
        this.temporaryShields = cap.temporaryShieldsLeft();
        this.permanentShields = cap.permanentShieldsLeft();
    }

    public UpdateShieldPacket(Entity entity, IShieldCapability cap) {
        this(entity.m_142049_(), cap);
    }

    public UpdateShieldPacket(FriendlyByteBuf buf) {
        this.entityID = buf.readInt();
        this.temporaryShields = buf.readInt();
        this.permanentShields = buf.readInt();
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeInt(this.entityID);
        buf.writeInt(this.temporaryShields);
        buf.writeInt(this.permanentShields);
    }

    public static class Handler {
        public static boolean onMessage(final UpdateShieldPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(new Runnable(){

                @Override
                public void run() {
                    Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(message.entityID);
                    if (entity instanceof LivingEntity) {
                        entity.getCapability(CapabilityList.SHIELDS).ifPresent(cap -> {
                            cap.setShields(message2.temporaryShields, true);
                            cap.setShields(message2.permanentShields, false);
                        });
                    }
                }
            });
            return true;
        }
    }
}

