/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.chunkgenerators.warp;

import net.minecraft.Util;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.NoiseSlider;
import net.minecraft.world.level.levelgen.synth.BlendedNoise;
import twilightforest.world.components.biomesources.TFBiomeProvider;
import twilightforest.world.components.chunkgenerators.warp.NoiseModifier;
import twilightforest.world.components.chunkgenerators.warp.TFBlendedNoise;

public class TFTerrainWarp {
    private final int cellWidth;
    private final int cellHeight;
    private final int cellCountY;
    private final BiomeSource biomeSource;
    private final NoiseSettings noiseSettings;
    private final NoiseSlider topSlide;
    private final NoiseSlider bottomSlide;
    private final BlendedNoise blendedNoise;
    private final double dimensionDensityFactor;
    private final double dimensionDensityOffset;
    public final NoiseModifier caveNoiseModifier;
    protected static final float[] BIOME_WEIGHTS = (float[])Util.m_137469_((Object)new float[25], afloat -> {
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                float weight;
                afloat[x + 2 + (z + 2) * 5] = weight = 10.0f / Mth.m_14116_((float)((float)(x * x + z * z) + 0.2f));
            }
        }
    });

    public TFTerrainWarp(int width, int height, int yCount, BiomeSource source, NoiseSettings settings, BlendedNoise blend, NoiseModifier modifier) {
        double d;
        TFBiomeProvider tfsource;
        this.cellWidth = width;
        this.cellHeight = height;
        this.cellCountY = yCount;
        this.biomeSource = source;
        this.noiseSettings = settings;
        this.topSlide = settings.f_64510_();
        this.bottomSlide = settings.f_64511_();
        this.blendedNoise = blend;
        if (source instanceof TFBiomeProvider) {
            tfsource = (TFBiomeProvider)source;
            v0 = tfsource.getBaseFactor();
        } else {
            v0 = this.dimensionDensityFactor = 1.0;
        }
        if (source instanceof TFBiomeProvider) {
            tfsource = (TFBiomeProvider)source;
            d = tfsource.getBaseOffset();
        } else {
            d = 0.0;
        }
        this.dimensionDensityOffset = d;
        this.caveNoiseModifier = modifier;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void fillNoiseColumn(ChunkGenerator generator, double[] adouble, int x, int z, NoiseSettings settings, int sealevel, int min, int max) {
        BiomeSource biomeSource = this.biomeSource;
        if (!(biomeSource instanceof TFBiomeProvider)) throw new IllegalArgumentException("BiomeSource is not an instance of TFBiomeProvider");
        TFBiomeProvider source = (TFBiomeProvider)biomeSource;
        float f = 0.0f;
        float f1 = 0.0f;
        float f2 = 0.0f;
        float depth = source.getBiomeDepth(x, sealevel, z, generator.m_183403_());
        for (int offX = -2; offX <= 2; ++offX) {
            for (int offZ = -2; offZ <= 2; ++offZ) {
                Biome biome = (Biome)source.m_203407_(x + offX, sealevel, z + offZ, generator.m_183403_()).m_203334_();
                float offD = source.getBiomeDepth(biome);
                float offS = source.getBiomeScale(biome);
                float f6 = offD;
                float f7 = offS;
                float f8 = offD > depth ? 0.5f : 1.0f;
                float f9 = f8 * BIOME_WEIGHTS[offX + 2 + (offZ + 2) * 5] / (f6 + 2.0f);
                f += f7 * f9;
                f1 += f6 * f9;
                f2 += f9;
            }
        }
        float f10 = f1 / f2;
        float f11 = f / f2;
        double d6 = f10 * 0.5f - 0.125f;
        double d8 = f11 * 0.9f + 0.1f;
        double d0 = d6 * 0.265625;
        double d1 = 96.0 / d8;
        double scaleXZ = 684.412 * settings.f_64509_().f_64491_();
        double scaleY = 684.412 * settings.f_64509_().f_64492_();
        double factorXZ = scaleXZ / settings.f_64509_().f_64493_();
        double factorY = scaleY / settings.f_64509_().f_64494_();
        double density = -0.46875;
        BlendedNoise blendedNoise = this.blendedNoise;
        if (!(blendedNoise instanceof TFBlendedNoise)) throw new IllegalArgumentException("BlendedNoise is not an instance of TFBlendedNoise");
        TFBlendedNoise blend = (TFBlendedNoise)blendedNoise;
        for (int index = 0; index <= max; ++index) {
            int y = index + min;
            double noise = blend.sampleAndClampNoise(x, y, z, scaleXZ, scaleY, factorXZ, factorY);
            double totaldensity = this.computeInitialDensity(y, d0, d1, density) + noise;
            totaldensity = this.caveNoiseModifier.modifyNoise(totaldensity, y * this.cellHeight, z * this.cellWidth, x * this.cellWidth);
            adouble[index] = totaldensity = this.applySlide(totaldensity, y);
        }
    }

    protected double computeInitialDensity(int y, double offset, double factor, double density) {
        double total;
        double base = 1.0 - (double)y * 2.0 / 32.0 + density;
        double factored = base * this.dimensionDensityFactor + this.dimensionDensityOffset;
        return total * (double)((total = (factored + offset) * factor) > 0.0 ? 4 : 1);
    }

    protected double applySlide(double density, int height) {
        int i = Mth.m_14042_((int)this.noiseSettings.f_158688_(), (int)this.cellHeight);
        int j = height - i;
        density = this.topSlide.m_209638_(density, (double)(this.cellCountY - j));
        density = this.bottomSlide.m_209638_(density, (double)j);
        return density;
    }
}

