/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.trees;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.TreeFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;
import twilightforest.world.components.feature.config.TFTreeFeatureConfig;

public abstract class TFTreeGenerator<T extends TFTreeFeatureConfig>
extends Feature<T> {
    public TFTreeGenerator(Codec<T> configIn) {
        super(configIn);
    }

    public final boolean m_142674_(FeaturePlaceContext<T> context) {
        HashSet decorationSet;
        BiConsumer<BlockPos, BlockState> decorationPlacer;
        HashSet leavesSet;
        BiConsumer<BlockPos, BlockState> leavesPlacer;
        WorldGenLevel contextWorldGenLevel = context.m_159774_();
        Random contextRandom = context.m_159776_();
        BlockPos contextBlockPos = context.m_159777_();
        TFTreeFeatureConfig contextConfig = (TFTreeFeatureConfig)context.m_159778_();
        HashSet trunkSet = Sets.newHashSet();
        BiConsumer<BlockPos, BlockState> trunkPlacer = (pos, state) -> {
            trunkSet.add(pos.m_7949_());
            contextWorldGenLevel.m_7731_(pos, state, 19);
        };
        if (!(!this.generate(contextWorldGenLevel, contextRandom, contextBlockPos, trunkPlacer, leavesPlacer = (arg_0, arg_1) -> TFTreeGenerator.lambda$place$1(leavesSet = Sets.newHashSet(), contextWorldGenLevel, arg_0, arg_1), decorationPlacer = (arg_0, arg_1) -> TFTreeGenerator.lambda$place$2(decorationSet = Sets.newHashSet(), contextWorldGenLevel, arg_0, arg_1), contextConfig) || trunkSet.isEmpty() && leavesSet.isEmpty())) {
            if (!contextConfig.decorators.isEmpty()) {
                ArrayList trunkList = Lists.newArrayList((Iterable)trunkSet);
                ArrayList leavesList = Lists.newArrayList((Iterable)leavesSet);
                trunkList.sort(Comparator.comparingInt(Vec3i::m_123342_));
                leavesList.sort(Comparator.comparingInt(Vec3i::m_123342_));
                contextConfig.decorators.forEach(treeDecorator -> treeDecorator.m_142741_((LevelSimulatedReader)contextWorldGenLevel, decorationPlacer, contextRandom, trunkList, leavesList));
            }
            return BoundingBox.m_162378_((Iterable)Iterables.concat((Iterable)trunkSet, (Iterable)leavesSet, (Iterable)decorationSet)).map(boundingBox -> {
                DiscreteVoxelShape voxelShape = TreeFeature.m_67202_((LevelAccessor)contextWorldGenLevel, (BoundingBox)boundingBox, (Set)trunkSet, (Set)decorationSet);
                StructureTemplate.m_74510_((LevelAccessor)contextWorldGenLevel, (int)3, (DiscreteVoxelShape)voxelShape, (int)boundingBox.m_162395_(), (int)boundingBox.m_162396_(), (int)boundingBox.m_162398_());
                return true;
            }).orElse(false);
        }
        return false;
    }

    protected abstract boolean generate(WorldGenLevel var1, Random var2, BlockPos var3, BiConsumer<BlockPos, BlockState> var4, BiConsumer<BlockPos, BlockState> var5, BiConsumer<BlockPos, BlockState> var6, T var7);

    private static /* synthetic */ void lambda$place$2(Set decorationSet, WorldGenLevel contextWorldGenLevel, BlockPos pos, BlockState state) {
        decorationSet.add(pos.m_7949_());
        contextWorldGenLevel.m_7731_(pos, state, 19);
    }

    private static /* synthetic */ void lambda$place$1(Set leavesSet, WorldGenLevel contextWorldGenLevel, BlockPos pos, BlockState state) {
        leavesSet.add(pos.m_7949_());
        contextWorldGenLevel.m_7731_(pos, state, 19);
    }
}

