/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.trees.treeplacers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.stateproviders.WeightedStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import twilightforest.world.registration.TwilightFeatures;

public class DangleFromTreeDecorator
extends TreeDecorator {
    public static final Codec<DangleFromTreeDecorator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)0, (int)32).fieldOf("attempts_minimum").forGetter(o -> o.count), (App)Codec.intRange((int)0, (int)32).fieldOf("random_add_attempts").orElse((Object)0).forGetter(o -> o.randomAddCount), (App)Codec.intRange((int)1, (int)24).fieldOf("minimum_required_length").forGetter(o -> o.minimumRequiredLength), (App)Codec.intRange((int)1, (int)24).fieldOf("base_length").forGetter(o -> o.baseLength), (App)Codec.intRange((int)0, (int)16).fieldOf("random_add_length").orElse((Object)0).forGetter(o -> o.randomAddLength), (App)WeightedStateProvider.f_68808_.fieldOf("rope_provider").forGetter(o -> o.rope), (App)WeightedStateProvider.f_68808_.fieldOf("baggage_provider").forGetter(o -> o.baggage)).apply((Applicative)instance, DangleFromTreeDecorator::new));
    private final int count;
    private final int randomAddCount;
    private final int minimumRequiredLength;
    private final int baseLength;
    private final int randomAddLength;
    private final WeightedStateProvider rope;
    private final WeightedStateProvider baggage;

    public DangleFromTreeDecorator(int count, int randomAddCount, int minimumRequiredLength, int baseLength, int randomAddLength, WeightedStateProvider rope, WeightedStateProvider baggage) {
        this.count = count;
        this.randomAddCount = randomAddCount;
        this.minimumRequiredLength = minimumRequiredLength;
        this.baseLength = baseLength;
        this.randomAddLength = randomAddLength;
        this.rope = rope;
        this.baggage = baggage;
    }

    protected TreeDecoratorType<DangleFromTreeDecorator> m_6663_() {
        return (TreeDecoratorType)TwilightFeatures.DANGLING_DECORATOR.get();
    }

    public void m_142741_(LevelSimulatedReader worldReader, BiConsumer<BlockPos, BlockState> worldPlacer, Random random, List<BlockPos> trunkBlocks, List<BlockPos> leafBlocks) {
        if (leafBlocks.isEmpty()) {
            return;
        }
        int totalTries = this.count + random.nextInt(this.randomAddCount + 1);
        int leafTotal = leafBlocks.size();
        totalTries = Math.min(totalTries, leafTotal);
        for (int attempt = 0; attempt < totalTries; ++attempt) {
            boolean clearedOfPossibleLeaves = false;
            BlockPos pos = leafBlocks.get(random.nextInt(leafTotal));
            if (pos.m_123341_() == trunkBlocks.get(0).m_123342_() && pos.m_123343_() == trunkBlocks.get(0).m_123343_()) {
                return;
            }
            int cordLength = this.baseLength + random.nextInt(this.randomAddLength + 1);
            for (int ropeUnrolling = 1; ropeUnrolling <= cordLength; ++ropeUnrolling) {
                boolean isAir = worldReader.m_7433_(pos.m_6625_(ropeUnrolling), BlockBehaviour.BlockStateBase::m_60795_);
                if (!clearedOfPossibleLeaves && isAir) {
                    clearedOfPossibleLeaves = true;
                }
                if (!clearedOfPossibleLeaves || isAir) continue;
                cordLength = ropeUnrolling;
                break;
            }
            if (cordLength <= this.minimumRequiredLength) continue;
            BlockState rope = this.rope.m_7112_(random, pos);
            for (int ropeUnrolling = 1; ropeUnrolling < cordLength; ++ropeUnrolling) {
                if (!worldReader.m_7433_(pos = pos.m_6625_(1), BlockBehaviour.BlockStateBase::m_60795_)) continue;
                worldPlacer.accept(pos, rope);
            }
            if (!worldReader.m_7433_(pos = pos.m_6625_(1), BlockBehaviour.BlockStateBase::m_60795_)) continue;
            worldPlacer.accept(pos, this.baggage.m_7112_(random, pos));
        }
    }
}

