/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.trees.treeplacers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecorator;
import net.minecraft.world.level.levelgen.feature.treedecorators.TreeDecoratorType;
import twilightforest.TwilightForestMod;
import twilightforest.world.registration.TwilightFeatures;

public class TrunkSideDecorator
extends TreeDecorator {
    public static final Codec<TrunkSideDecorator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)0, (int)64).fieldOf("placement_count").forGetter(o -> o.count), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("probability_of_placement").forGetter(o -> Float.valueOf(o.probability)), (App)BlockStateProvider.f_68747_.fieldOf("deco_provider").forGetter(o -> o.decoration)).apply((Applicative)instance, TrunkSideDecorator::new));
    private final int count;
    private final float probability;
    private final BlockStateProvider decoration;

    public TrunkSideDecorator(int count, float probability, BlockStateProvider decorator) {
        this.count = count;
        this.probability = probability;
        this.decoration = decorator;
    }

    protected TreeDecoratorType<TrunkSideDecorator> m_6663_() {
        return (TreeDecoratorType)TwilightFeatures.TRUNKSIDE_DECORATOR.get();
    }

    public void m_142741_(LevelSimulatedReader worldReader, BiConsumer<BlockPos, BlockState> worldPlacer, Random random, List<BlockPos> trunkBlocks, List<BlockPos> leafBlocks) {
        int blockCount = trunkBlocks.size();
        if (blockCount <= 0) {
            TwilightForestMod.LOGGER.error("[TrunkSideDecorator] Trunk Blocks were empty! Why?");
            return;
        }
        for (int attempt = 0; attempt < this.count; ++attempt) {
            if (random.nextFloat() >= this.probability) continue;
            Rotation rot = Rotation.m_55956_((Random)random);
            BlockPos pos = trunkBlocks.get(random.nextInt(blockCount)).m_142300_(rot.m_55954_(Direction.NORTH));
            if (!Feature.m_65810_((LevelSimulatedReader)worldReader, (BlockPos)pos)) continue;
            worldPlacer.accept(pos, this.decoration.m_7112_(random, pos));
        }
    }
}

