/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.layer;

import net.minecraft.core.Registry;
import net.minecraft.world.level.biome.Biome;
import twilightforest.world.components.biomesources.TFBiomeProvider;
import twilightforest.world.components.layer.IThornsTransformer;
import twilightforest.world.components.layer.vanillalegacy.context.Context;
import twilightforest.world.registration.biomes.BiomeKeys;

public enum GenLayerTFThornBorder implements IThornsTransformer
{
    INSTANCE;

    private Registry<Biome> registry;

    public GenLayerTFThornBorder setup(Registry<Biome> registry) {
        this.registry = registry;
        return this;
    }

    @Override
    public int apply(Context noise, int up, int left, int down, int right, int center, int nw, int sw, int se, int ne) {
        int highlandsCenter = TFBiomeProvider.getBiomeId(BiomeKeys.FINAL_PLATEAU, this.registry);
        int thornlands = TFBiomeProvider.getBiomeId(BiomeKeys.THORNLANDS, this.registry);
        if (this.onBorder(highlandsCenter, center, right, left, up, down)) {
            return thornlands;
        }
        if (this.onBorder(highlandsCenter, center, ne, nw, se, sw)) {
            return thornlands;
        }
        return center;
    }

    private boolean onBorder(int biomeID, int center, int right, int left, int up, int down) {
        if (center == biomeID) {
            return false;
        }
        if (right == biomeID) {
            return true;
        }
        if (left == biomeID) {
            return true;
        }
        if (up == biomeID) {
            return true;
        }
        return down == biomeID;
    }
}

