/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Random;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.StructureMode;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import twilightforest.TwilightForestMod;
import twilightforest.world.components.structures.TwilightTemplateStructurePiece;

public abstract class TwilightDoubleTemplateStructurePiece
extends TwilightTemplateStructurePiece {
    protected ResourceLocation templateOverlayLocation;
    protected StructureTemplate templateOverlay;
    protected StructurePlaceSettings placeSettingsOverlay;

    public TwilightDoubleTemplateStructurePiece(StructurePieceType structurePieceType, CompoundTag compoundTag, StructurePieceSerializationContext ctx, StructurePlaceSettings rl2SettingsFunction, StructurePlaceSettings placeSettingsOverlay) {
        super(structurePieceType, compoundTag, ctx, rl2SettingsFunction);
        this.templateOverlayLocation = new ResourceLocation(compoundTag.m_128461_("TemplateOverlay"));
        this.templateOverlay = this.structureManager.m_74341_(this.templateOverlayLocation);
        this.placeSettingsOverlay = placeSettingsOverlay;
    }

    public TwilightDoubleTemplateStructurePiece(StructurePieceType type, int genDepth, StructureManager structureManager, ResourceLocation templateLocation, StructurePlaceSettings placeSettings, ResourceLocation templateOverlayLocation, StructurePlaceSettings placeSettingsOverlay, BlockPos startPosition) {
        super(type, genDepth, structureManager, templateLocation, placeSettings, startPosition);
        this.templateOverlayLocation = templateOverlayLocation;
        this.templateOverlay = this.structureManager.m_74341_(this.templateOverlayLocation);
        this.placeSettingsOverlay = placeSettingsOverlay;
    }

    @Override
    protected void m_183620_(StructurePieceSerializationContext ctx, CompoundTag structureTag) {
        super.m_183620_(ctx, structureTag);
        structureTag.m_128359_("TemplateOverlay", this.templateOverlayLocation.toString());
    }

    public void m_183269_(WorldGenLevel worldGenLevel, StructureFeatureManager structureManager, ChunkGenerator chunkGenerator, Random random, BoundingBox boundingBox, ChunkPos chunkPos, BlockPos blockPos) {
        super.m_183269_(worldGenLevel, structureManager, chunkGenerator, random, boundingBox, chunkPos, blockPos);
        if (this.templateOverlay.m_74536_((ServerLevelAccessor)worldGenLevel, this.f_73658_, blockPos, this.placeSettingsOverlay, random, 2)) {
            for (StructureTemplate.StructureBlockInfo structureBlockInfo : this.templateOverlay.m_74603_(this.f_73658_, this.placeSettingsOverlay, Blocks.f_50677_)) {
                StructureMode structureMode;
                if (structureBlockInfo.f_74677_ == null || (structureMode = StructureMode.valueOf((String)structureBlockInfo.f_74677_.m_128461_("mode"))) != StructureMode.DATA) continue;
                this.m_7756_(structureBlockInfo.f_74677_.m_128461_("metadata"), structureBlockInfo.f_74675_, (ServerLevelAccessor)worldGenLevel, random, boundingBox);
            }
            for (StructureTemplate.StructureBlockInfo structureBlockInfo : this.templateOverlay.m_74603_(this.f_73658_, this.placeSettingsOverlay, Blocks.f_50678_)) {
                if (structureBlockInfo.f_74677_ == null) continue;
                String s = structureBlockInfo.f_74677_.m_128461_("final_state");
                BlockStateParser blockStateParser = new BlockStateParser(new StringReader(s), false);
                BlockState blockState = Blocks.f_50016_.m_49966_();
                try {
                    blockStateParser.m_116806_(true);
                    BlockState parserState = blockStateParser.m_116808_();
                    if (parserState != null) {
                        blockState = parserState;
                    } else {
                        TwilightForestMod.LOGGER.error("Error while parsing blockstate {} in jigsaw block @ {}", (Object)s, (Object)structureBlockInfo.f_74675_);
                    }
                }
                catch (CommandSyntaxException commandsyntaxexception) {
                    TwilightForestMod.LOGGER.error("Error while parsing blockstate {} in jigsaw block @ {}", (Object)s, (Object)structureBlockInfo.f_74675_);
                }
                worldGenLevel.m_7731_(structureBlockInfo.f_74675_, blockState, 3);
            }
        }
    }
}

