/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.darktower;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import twilightforest.world.components.structures.TFStructureComponentOld;
import twilightforest.world.components.structures.darktower.DarkTowerPieces;
import twilightforest.world.components.structures.darktower.DarkTowerWingComponent;
import twilightforest.world.components.structures.lichtower.TowerWingComponent;
import twilightforest.world.registration.TFFeature;

public class DarkTowerBridgeComponent
extends TowerWingComponent {
    private int dSize;
    private int dHeight;

    public DarkTowerBridgeComponent(StructurePieceType piece, CompoundTag nbt) {
        super(piece, nbt);
    }

    public DarkTowerBridgeComponent(StructurePieceSerializationContext ctx, CompoundTag nbt) {
        super(DarkTowerPieces.TFDTBri, nbt);
    }

    protected DarkTowerBridgeComponent(StructurePieceType type, TFFeature feature, int i, int x, int y, int z, int pSize, int pHeight, Direction direction) {
        super(type, feature, i, x, y, z, 5, 5, direction);
        this.dSize = pSize;
        this.dHeight = pHeight;
    }

    @Override
    public void m_142537_(StructurePiece parent, StructurePieceAccessor list, Random rand) {
        if (parent != null && parent instanceof TFStructureComponentOld) {
            this.deco = ((TFStructureComponentOld)parent).deco;
        }
        this.makeTowerWing(list, rand, this.m_73548_(), 4, 1, 2, this.dSize, this.dHeight, Rotation.NONE);
    }

    @Override
    public boolean makeTowerWing(StructurePieceAccessor list, Random rand, int index, int x, int y, int z, int wingSize, int wingHeight, Rotation rotation) {
        if (wingHeight < 6) {
            return false;
        }
        Direction direction = this.getStructureRelativeRotation(rotation);
        int[] dx = this.offsetTowerCoords(x, y, z, wingSize, direction);
        if (dx[1] + wingHeight > 255) {
            return false;
        }
        DarkTowerWingComponent wing = new DarkTowerWingComponent(DarkTowerPieces.TFDTWin, this.getFeatureType(), index, dx[0], dx[1], dx[2], wingSize, wingHeight, direction);
        StructurePiece intersect = list.m_141921_(wing.m_73547_());
        if (intersect == null || intersect == this) {
            list.m_142679_((StructurePiece)wing);
            ((TowerWingComponent)wing).m_142537_(this, list, rand);
            this.addOpening(x, y, z, rotation);
            return true;
        }
        return false;
    }

    @Override
    public void m_183269_(WorldGenLevel world, StructureFeatureManager manager, ChunkGenerator generator, Random rand, BoundingBox sbb, ChunkPos chunkPosIn, BlockPos blockPos) {
        this.m_73441_(world, sbb, 0, 0, 0, this.size - 1, this.height - 1, this.size - 1, this.deco.blockState, this.deco.blockState, false);
        for (int x = 0; x < this.size; ++x) {
            this.m_73434_(world, this.deco.accentState, x, 0, 0, sbb);
            this.m_73434_(world, this.deco.accentState, x, this.height - 1, 0, sbb);
            this.m_73434_(world, this.deco.accentState, x, 0, this.size - 1, sbb);
            this.m_73434_(world, this.deco.accentState, x, this.height - 1, this.size - 1, sbb);
        }
        this.m_73535_(world, sbb, 0, 1, 1, this.size - 1, this.height - 2, this.size - 2);
    }

    public BoundingBox getWingBB() {
        int[] dest = this.offsetTowerCoords(4, 1, 2, this.dSize, this.m_73549_());
        return this.getFeatureType().getComponentToAddBoundingBox(dest[0], dest[1], dest[2], 0, 0, 0, this.dSize - 1, this.dHeight - 1, this.dSize - 1, this.m_73549_());
    }
}

