/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.mehvahdjukaar.selene.blocks.WaterBlock;
import net.mehvahdjukaar.supplementaries.common.block.BlockProperties;
import net.mehvahdjukaar.supplementaries.common.block.blocks.LightableLanternBlock;
import net.mehvahdjukaar.supplementaries.common.block.tiles.SwayingBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.tiles.WallLanternBlockTile;
import net.mehvahdjukaar.supplementaries.common.block.util.BlockUtils;
import net.mehvahdjukaar.supplementaries.common.block.util.IBlockHolder;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class WallLanternBlock
extends WaterBlock
implements EntityBlock {
    public static final VoxelShape SHAPE_SOUTH = Block.m_49796_((double)5.0, (double)2.0, (double)0.0, (double)11.0, (double)15.99, (double)10.0);
    public static final VoxelShape SHAPE_NORTH = Block.m_49796_((double)5.0, (double)2.0, (double)6.0, (double)11.0, (double)15.99, (double)16.0);
    public static final VoxelShape SHAPE_WEST = Block.m_49796_((double)6.0, (double)2.0, (double)5.0, (double)16.0, (double)15.99, (double)11.0);
    public static final VoxelShape SHAPE_EAST = Block.m_49796_((double)0.0, (double)2.0, (double)5.0, (double)10.0, (double)15.99, (double)11.0);
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<BlockProperties.BlockAttachment> ATTACHMENT = BlockProperties.BLOCK_ATTACHMENT;
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final IntegerProperty LIGHT_LEVEL = BlockProperties.LIGHT_LEVEL_0_15;

    public WallLanternBlock(BlockBehaviour.Properties properties) {
        super(properties.m_60953_(s -> (Boolean)s.m_61143_((Property)LIT) != false ? (Integer)s.m_61143_((Property)LIGHT_LEVEL) : 0));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(0))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(true)));
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        Optional<BlockState> opt;
        WallLanternBlockTile te;
        BlockState lantern;
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof WallLanternBlockTile && (lantern = (te = (WallLanternBlockTile)blockEntity).getHeldBlock()).m_60734_() instanceof LightableLanternBlock && (opt = LightableLanternBlock.toggleLight(lantern, pLevel, pPos, pPlayer, pHand)).isPresent()) {
            te.setHeldBlock(opt.get());
            int light = opt.get().m_60791_();
            pLevel.m_46597_(pPos, (BlockState)pState.m_61124_((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(light)));
            pLevel.m_7260_(pPos, pState, pState, 2);
            return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
        }
        return InteractionResult.PASS;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        if (context.m_43719_() == Direction.UP || context.m_43719_() == Direction.DOWN) {
            return null;
        }
        BlockState state = super.m_5573_(context);
        BlockPos blockpos = context.m_8083_();
        Level world = context.m_43725_();
        Direction dir = context.m_43719_();
        BlockPos relative = blockpos.m_142300_(dir.m_122424_());
        BlockState facingState = world.m_8055_(relative);
        return (BlockState)WallLanternBlock.getConnectedState(state, facingState, (LevelAccessor)world, relative, dir).m_61124_((Property)FACING, (Comparable)context.m_43719_());
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity entity2, ItemStack stack) {
        BlockEntity te = world.m_7702_(pos);
        Item i = stack.m_41720_();
        if (te instanceof IBlockHolder) {
            IBlockHolder blockHolder = (IBlockHolder)te;
            if (i instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)i;
                blockHolder.setHeldBlock(blockItem.m_40614_().m_49966_());
            }
        }
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        return facing == ((Direction)stateIn.m_61143_((Property)FACING)).m_122424_() ? (!stateIn.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : WallLanternBlock.getConnectedState(stateIn, facingState, worldIn, facingPos, facing)) : stateIn;
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        BlockPos blockpos = pos.m_142300_(direction.m_122424_());
        BlockState blockstate = level.m_8055_(blockpos);
        return BlockProperties.BlockAttachment.get(blockstate, blockpos, level, direction) != null;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.DESTROY;
    }

    public static BlockState getConnectedState(BlockState state, BlockState facingState, LevelAccessor world, BlockPos pos, Direction dir) {
        BlockProperties.BlockAttachment attachment = BlockProperties.BlockAttachment.get(facingState, pos, (LevelReader)world, dir);
        if (attachment == null) {
            return state;
        }
        return (BlockState)state.m_61124_(ATTACHMENT, (Comparable)((Object)attachment));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            default -> SHAPE_SOUTH;
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.WEST -> SHAPE_WEST;
            case Direction.EAST -> SHAPE_EAST;
        };
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof WallLanternBlockTile) {
            WallLanternBlockTile te = (WallLanternBlockTile)blockEntity;
            return new ItemStack((ItemLike)te.getHeldBlock().m_60734_());
        }
        return new ItemStack((ItemLike)Blocks.f_50681_, 1);
    }

    public boolean m_7357_(BlockState state, BlockGetter worldIn, BlockPos pos, PathComputationType type) {
        return false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{LIGHT_LEVEL, LIT, FACING, ATTACHMENT});
    }

    public void m_7458_(BlockState state, ServerLevel worldIn, BlockPos pos, Random rand) {
        super.m_7458_(state, worldIn, pos, rand);
        BlockEntity blockEntity = worldIn.m_7702_(pos);
        if (blockEntity instanceof WallLanternBlockTile) {
            WallLanternBlockTile te = (WallLanternBlockTile)blockEntity;
            if (te.isRedstoneLantern && ((Boolean)state.m_61143_((Property)LIT)).booleanValue() && !worldIn.m_46753_(pos)) {
                worldIn.m_7731_(pos, (BlockState)state.m_61122_((Property)LIT), 2);
                if (te.getHeldBlock().m_61138_((Property)LIT)) {
                    te.setHeldBlock((BlockState)te.getHeldBlock().m_61122_((Property)LIT));
                }
            }
        }
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block block2, BlockPos fromPos, boolean notify) {
        BlockEntity blockEntity;
        if (!world.f_46443_ && (blockEntity = world.m_7702_(pos)) instanceof WallLanternBlockTile) {
            boolean flag;
            WallLanternBlockTile tile = (WallLanternBlockTile)blockEntity;
            if (tile.isRedstoneLantern && (flag = ((Boolean)state.m_61143_((Property)LIT)).booleanValue()) != world.m_46753_(pos)) {
                if (flag) {
                    world.m_186460_(pos, (Block)this, 4);
                } else {
                    world.m_7731_(pos, (BlockState)state.m_61122_((Property)LIT), 2);
                    if (tile.getHeldBlock().m_61138_((Property)LIT)) {
                        tile.setHeldBlock((BlockState)tile.getHeldBlock().m_61122_((Property)LIT));
                    }
                }
            }
        }
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        Object object = builder.m_78982_(LootContextParams.f_81462_);
        if (object instanceof WallLanternBlockTile) {
            WallLanternBlockTile tile = (WallLanternBlockTile)object;
            return tile.getHeldBlock().m_60724_(builder);
        }
        return super.m_7381_(state, builder);
    }

    public void m_7100_(BlockState state, Level level, BlockPos pos, Random random) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof WallLanternBlockTile) {
            WallLanternBlockTile tile = (WallLanternBlockTile)blockEntity;
            BlockState s = tile.getHeldBlock();
            s.m_60734_().m_7100_(s, level, pos, random);
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new WallLanternBlockTile(pPos, pState);
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity2) {
        super.m_7892_(state, world, pos, entity2);
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof SwayingBlockTile) {
            SwayingBlockTile tile = (SwayingBlockTile)blockEntity;
            tile.hitByEntity(entity2, state, pos);
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return BlockUtils.getTicker(pBlockEntityType, (BlockEntityType)ModRegistry.WALL_LANTERN_TILE.get(), pLevel.f_46443_ ? SwayingBlockTile::clientTick : null);
    }

    public SoundType getSoundType(BlockState state, LevelReader world, BlockPos pos, @Nullable Entity entity2) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof WallLanternBlockTile) {
            WallLanternBlockTile te = (WallLanternBlockTile)blockEntity;
            return te.getHeldBlock().m_60827_();
        }
        return super.getSoundType(state, world, pos, entity2);
    }

    public void placeOn(BlockState lantern, BlockPos onPos, Direction face, Level world) {
        BlockState state = (BlockState)WallLanternBlock.getConnectedState(this.m_49966_(), world.m_8055_(onPos), (LevelAccessor)world, onPos, face).m_61124_((Property)FACING, (Comparable)face);
        BlockPos newPos = onPos.m_142300_(face);
        world.m_7731_(newPos, state, 3);
        BlockEntity blockEntity = world.m_7702_(newPos);
        if (blockEntity instanceof IBlockHolder) {
            IBlockHolder tile = (IBlockHolder)blockEntity;
            tile.setHeldBlock(lantern);
        }
    }
}

