/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.entities;

import java.util.EnumSet;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.common.entities.BombEntity;
import net.mehvahdjukaar.supplementaries.common.entities.goals.EquipAndRangeAttackGoal;
import net.mehvahdjukaar.supplementaries.common.entities.goals.ShowWaresGoal;
import net.mehvahdjukaar.supplementaries.common.entities.trades.VillagerTradesHandler;
import net.mehvahdjukaar.supplementaries.common.inventories.RedMerchantContainerMenu;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundSyncTradesPacket;
import net.mehvahdjukaar.supplementaries.common.network.NetworkHandler;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.LookAtTradingPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.TradeWithPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.monster.Zoglin;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;

public class RedMerchantEntity
extends AbstractVillager
implements RangedAttackMob {
    @Nullable
    private BlockPos wanderTarget;
    private int despawnDelay;
    public int attackCooldown = 0;

    public RedMerchantEntity(EntityType<? extends RedMerchantEntity> type, Level world) {
        super(type, world);
    }

    public RedMerchantEntity(Level world) {
        this((EntityType<? extends RedMerchantEntity>)((EntityType)ModRegistry.RED_MERCHANT.get()), world);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new EquipAndRangeAttackGoal(this, 0.35, 60, 10, 20, 15.0f, new ItemStack((ItemLike)ModRegistry.BOMB_ITEM.get())));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 8, true, false, mob -> mob instanceof Raider || mob instanceof Zombie || mob instanceof Zoglin));
        this.f_21345_.m_25352_(3, (Goal)new TradeWithPlayerGoal((AbstractVillager)this));
        this.f_21345_.m_25352_(3, (Goal)new LookAtTradingPlayerGoal((AbstractVillager)this));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Zombie.class, 6.0f, 0.5, 0.5));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Vex.class, 8.0f, 0.5, 0.5));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Creeper.class, 8.0f, 0.5, 0.5));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Raider.class, 11.0f, 0.5, 0.5));
        this.f_21345_.m_25352_(3, (Goal)new AvoidEntityGoal((PathfinderMob)this, Zoglin.class, 8.0f, 0.5, 0.5));
        this.f_21345_.m_25352_(4, (Goal)new ShowWaresGoal(this, 400, 1600));
        this.f_21345_.m_25352_(4, (Goal)new MoveToGoal(this, 2.0, 0.35));
        this.f_21345_.m_25352_(5, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 0.35));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.35));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    public void m_6703_(@Nullable LivingEntity entity2) {
        super.m_6703_(entity2);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel world, AgeableMob entity2) {
        return null;
    }

    public boolean m_7826_() {
        return false;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (itemstack.m_41720_() != Items.f_42601_ && this.m_6084_() && !this.m_35306_() && !this.m_6162_()) {
            if (hand == InteractionHand.MAIN_HAND) {
                player.m_36220_(Stats.f_12940_);
            }
            if (!this.m_6616_().isEmpty() && !this.f_19853_.f_46443_) {
                this.m_7189_(player);
                this.m_45301_(player, this.m_5446_(), 1);
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    public void m_7604_() {
        MerchantOffers merchantoffers = this.m_6616_();
        this.m_35277_(merchantoffers, VillagerTradesHandler.getRedMerchantTrades(), 7);
    }

    public void m_45301_(Player player, Component name, int level) {
        MerchantOffers merchantoffers;
        OptionalInt optionalint = player.m_5893_((MenuProvider)new SimpleMenuProvider((i, p, m) -> new RedMerchantContainerMenu(i, p, (Merchant)this), name));
        if (optionalint.isPresent() && player instanceof ServerPlayer && !(merchantoffers = this.m_6616_()).isEmpty()) {
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new ClientBoundSyncTradesPacket(optionalint.getAsInt(), merchantoffers, level, this.m_7809_(), this.m_7826_(), this.m_7862_()));
        }
    }

    public void m_7380_(CompoundTag p_213281_1_) {
        super.m_7380_(p_213281_1_);
        p_213281_1_.m_128405_("DespawnDelay", this.despawnDelay);
        if (this.wanderTarget != null) {
            p_213281_1_.m_128365_("WanderTarget", (Tag)NbtUtils.m_129224_((BlockPos)this.wanderTarget));
        }
    }

    public void m_7378_(CompoundTag p_70037_1_) {
        super.m_7378_(p_70037_1_);
        if (p_70037_1_.m_128425_("DespawnDelay", 99)) {
            this.despawnDelay = p_70037_1_.m_128451_("DespawnDelay");
        }
        if (p_70037_1_.m_128441_("WanderTarget")) {
            this.wanderTarget = NbtUtils.m_129239_((CompoundTag)p_70037_1_.m_128469_("WanderTarget"));
        }
        this.m_146762_(Math.max(0, this.m_146764_()));
    }

    public boolean m_6785_(double p_213397_1_) {
        return false;
    }

    protected void m_8058_(MerchantOffer p_213713_1_) {
        if (p_213713_1_.m_45383_()) {
            int i = 3 + this.f_19796_.nextInt(4);
            this.f_19853_.m_7967_((Entity)new ExperienceOrb(this.f_19853_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), i));
        }
    }

    protected SoundEvent m_7515_() {
        return this.m_35306_() ? SoundEvents.f_12538_ : SoundEvents.f_12582_;
    }

    protected SoundEvent m_7975_(DamageSource p_184601_1_) {
        return SoundEvents.f_12587_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12583_;
    }

    protected SoundEvent m_7838_(ItemStack p_213351_1_) {
        Item item2 = p_213351_1_.m_41720_();
        return item2 == Items.f_42455_ ? SoundEvents.f_12585_ : SoundEvents.f_12586_;
    }

    protected SoundEvent m_6068_(boolean p_213721_1_) {
        return p_213721_1_ ? SoundEvents.f_12539_ : SoundEvents.f_12588_;
    }

    public SoundEvent m_7596_() {
        return SoundEvents.f_12539_;
    }

    public void setDespawnDelay(int p_213728_1_) {
        this.despawnDelay = p_213728_1_;
    }

    public int getDespawnDelay() {
        return this.despawnDelay;
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_) {
            if (this.attackCooldown > 0) {
                --this.attackCooldown;
            }
            this.maybeDespawn();
        }
    }

    private void maybeDespawn() {
        if (this.despawnDelay > 0 && !this.m_35306_() && --this.despawnDelay == 0) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public void setWanderTarget(@Nullable BlockPos p_213726_1_) {
        this.wanderTarget = p_213726_1_;
    }

    @Nullable
    private BlockPos getWanderTarget() {
        return this.wanderTarget;
    }

    public void m_6504_(LivingEntity target, float power) {
        Vec3 vector3d = target.m_20184_();
        double d0 = target.m_20185_() + vector3d.f_82479_ - this.m_20185_();
        double d1 = target.m_20188_() - 3.5 - this.m_20186_();
        double d2 = target.m_20189_() + vector3d.f_82481_ - this.m_20189_();
        float f = Mth.m_14116_((float)((float)(d0 * d0 + d2 * d2)));
        BombEntity bomb = new BombEntity(this.f_19853_, (LivingEntity)this, BombEntity.BombType.NORMAL);
        bomb.m_6686_(d0, d1 + (double)(f * 0.24f), d2, 1.25f, 0.9f);
        if (!this.m_20067_()) {
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12553_, this.m_5720_(), 1.0f, 0.8f + this.f_19796_.nextFloat() * 0.4f);
        }
        this.f_19853_.m_7967_((Entity)bomb);
    }

    protected float m_6515_(DamageSource source, float amount) {
        amount = super.m_6515_(source, amount);
        if (source.m_7639_() == this) {
            amount = 0.0f;
        }
        if (source.m_19372_()) {
            amount = (float)((double)amount * 0.2);
        }
        return amount;
    }

    class MoveToGoal
    extends Goal {
        final RedMerchantEntity trader;
        final double stopDistance;
        final double speedModifier;

        MoveToGoal(RedMerchantEntity p_i50459_2_, double p_i50459_3_, double p_i50459_5_) {
            this.trader = p_i50459_2_;
            this.stopDistance = p_i50459_3_;
            this.speedModifier = p_i50459_5_;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public void m_8041_() {
            this.trader.setWanderTarget(null);
            RedMerchantEntity.this.f_21344_.m_26573_();
        }

        public boolean m_8036_() {
            BlockPos blockpos = this.trader.getWanderTarget();
            return blockpos != null && this.isTooFarAway(blockpos, this.stopDistance);
        }

        public void m_8037_() {
            BlockPos blockpos = this.trader.getWanderTarget();
            if (blockpos != null && RedMerchantEntity.this.f_21344_.m_26571_()) {
                if (this.isTooFarAway(blockpos, 10.0)) {
                    Vec3 vector3d = new Vec3((double)blockpos.m_123341_() - this.trader.m_20185_(), (double)blockpos.m_123342_() - this.trader.m_20186_(), (double)blockpos.m_123343_() - this.trader.m_20189_()).m_82541_();
                    Vec3 vector3d1 = vector3d.m_82490_(10.0).m_82520_(this.trader.m_20185_(), this.trader.m_20186_(), this.trader.m_20189_());
                    RedMerchantEntity.this.f_21344_.m_26519_(vector3d1.f_82479_, vector3d1.f_82480_, vector3d1.f_82481_, this.speedModifier);
                } else {
                    RedMerchantEntity.this.f_21344_.m_26519_((double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_(), this.speedModifier);
                }
            }
        }

        private boolean isTooFarAway(BlockPos p_220846_1_, double p_220846_2_) {
            return !p_220846_1_.m_203195_((Position)this.trader.m_20182_(), p_220846_2_);
        }
    }
}

