/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.items;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import net.mehvahdjukaar.supplementaries.common.items.ItemsUtil;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.quark.QuarkPlugin;
import net.mehvahdjukaar.supplementaries.integration.quark.QuarkTooltipPlugin;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class SackItem
extends BlockItem {
    public SackItem(Block blockIn, Item.Properties builder) {
        super(blockIn, builder);
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        ServerPlayer player;
        super.m_6883_(stack, worldIn, entityIn, itemSlot, isSelected);
        if (!ServerConfigs.cached.SACK_PENALTY) {
            return;
        }
        if (worldIn.m_46467_() % 20L == 0L && entityIn instanceof ServerPlayer && !(player = (ServerPlayer)entityIn).m_7500_() && !entityIn.m_5833_()) {
            int inc;
            Collection effects = player.m_21220_();
            for (MobEffectInstance effect : effects) {
                if (effect.m_19544_() != MobEffects.f_19597_) continue;
                return;
            }
            int i = 0;
            AtomicReference reference = new AtomicReference();
            entityIn.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(reference::set);
            if (reference.get() != null) {
                for (int _idx = 0; _idx < ((IItemHandler)reference.get()).getSlots(); ++_idx) {
                    ItemStack slotItem = ((IItemHandler)reference.get()).getStackInSlot(_idx);
                    if (!(slotItem.m_41720_() instanceof SackItem)) continue;
                    ++i;
                }
                if (CompatHandler.quark) {
                    ItemStack backpack = player.m_6844_(EquipmentSlot.CHEST);
                    i += QuarkPlugin.getSacksInBackpack(backpack);
                }
            }
            if (i > (inc = ServerConfigs.cached.SACK_INCREMENT)) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 80, i / (inc + 1)));
            }
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        CompoundTag tag;
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (!(CompatHandler.quark && QuarkTooltipPlugin.canRenderTooltip() || (tag = stack.m_41737_("BlockEntityTag")) == null)) {
            if (tag.m_128425_("LootTable", 8)) {
                tooltip.add((Component)new TextComponent("???????").m_130940_(ChatFormatting.GRAY));
            }
            if (tag.m_128425_("Items", 9)) {
                NonNullList nonnulllist = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);
                ContainerHelper.m_18980_((CompoundTag)tag, (NonNullList)nonnulllist);
                int i = 0;
                int j = 0;
                for (ItemStack itemstack : nonnulllist) {
                    if (itemstack.m_41619_()) continue;
                    ++j;
                    if (i > 4) continue;
                    ++i;
                    MutableComponent component = itemstack.m_41786_().m_6881_();
                    component.m_130946_(" x").m_130946_(String.valueOf(itemstack.m_41613_()));
                    tooltip.add((Component)component.m_130940_(ChatFormatting.GRAY));
                }
                if (j - i > 0) {
                    tooltip.add((Component)new TranslatableComponent("container.shulkerBox.more", new Object[]{j - i}).m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY));
                }
            }
        }
        if (!ClientConfigs.cached.TOOLTIP_HINTS || !flagIn.m_7050_()) {
            return;
        }
        tooltip.add((Component)new TranslatableComponent("message.supplementaries.sack").m_130940_(ChatFormatting.ITALIC).m_130940_(ChatFormatting.GRAY));
    }

    public boolean m_142095_() {
        return false;
    }

    public void m_142023_(ItemEntity pItemEntity) {
        CompoundTag compoundtag = pItemEntity.m_32055_().m_41783_();
        if (compoundtag != null) {
            ListTag listtag = compoundtag.m_128469_("BlockEntityTag").m_128437_("Items", 10);
            ItemUtils.m_150952_((ItemEntity)pItemEntity, listtag.stream().map(CompoundTag.class::cast).map(ItemStack::m_41712_));
        }
    }

    public boolean m_142305_(ItemStack stack, ItemStack incoming, Slot slot, ClickAction action, Player player, SlotAccess accessor) {
        return ItemsUtil.tryInteractingWithContainerItem(stack, incoming, slot, action, player, true);
    }

    public boolean m_142207_(ItemStack stack, Slot slot, ClickAction action, Player player) {
        return ItemsUtil.tryInteractingWithContainerItem(stack, slot.m_7993_(), slot, action, player, false);
    }

    public Optional<TooltipComponent> m_142422_(ItemStack pStack) {
        CompoundTag cmp;
        if (CompatHandler.quark && QuarkTooltipPlugin.canRenderTooltip() && (cmp = pStack.m_41737_("BlockEntityTag")) != null && !cmp.m_128441_("LootTable")) {
            return Optional.of(new ItemsUtil.InventoryTooltip(cmp, (Item)this, ServerConfigs.cached.SACK_SLOTS));
        }
        return Optional.empty();
    }

    private void playRemoveOneSound(Entity p_186343_) {
        p_186343_.m_5496_(SoundEvents.f_184216_, 0.8f, 0.8f + p_186343_.m_183503_().m_5822_().nextFloat() * 0.4f);
    }

    private void playInsertSound(Entity p_186352_) {
        p_186352_.m_5496_(SoundEvents.f_184215_, 0.8f, 0.8f + p_186352_.m_183503_().m_5822_().nextFloat() * 0.4f);
    }
}

