/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.setup;

import java.util.HashMap;
import java.util.Map;
import net.mehvahdjukaar.selene.block_set.wood.WoodType;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber
public class RemapHandler {
    private static final Map<String, ResourceLocation> itemReMap = new HashMap<String, ResourceLocation>();
    private static final Map<String, ResourceLocation> fullReMap = new HashMap<String, ResourceLocation>();

    @SubscribeEvent
    public static void onRemapBlocks(RegistryEvent.MissingMappings<Block> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings("supplementaries")) {
            String k = mapping.key.m_135815_();
            if (fullReMap.containsKey(k)) {
                ResourceLocation i = fullReMap.get(k);
                try {
                    Supplementaries.LOGGER.warn("Remapping block '{}' to '{}'", (Object)mapping.key, (Object)i);
                    mapping.remap((IForgeRegistryEntry)((Block)ForgeRegistries.BLOCKS.getValue(i)));
                }
                catch (Throwable t) {
                    Supplementaries.LOGGER.warn("Remapping block '{}' to '{}' failed: {}", (Object)mapping.key, (Object)i, (Object)t);
                }
                continue;
            }
            if (!k.contains("hanging_sign")) continue;
            try {
                Block newBlock = (Block)RemapHandler.getNewBlock(ModRegistry.HANGING_SIGNS, k);
                if (newBlock == null) {
                    newBlock = (Block)ModRegistry.HANGING_SIGNS.get(WoodType.OAK_WOOD_TYPE);
                }
                mapping.remap((IForgeRegistryEntry)newBlock);
            }
            catch (Exception ex) {
                Supplementaries.LOGGER.warn("Remapping block '{}' failed: {}", (Object)mapping.key, (Object)ex);
            }
        }
    }

    public static void onRemapTiles(RegistryEvent.MissingMappings<BlockEntityType<?>> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings("supplementaries")) {
            String k = mapping.key.m_135815_();
            if (!fullReMap.containsKey(k)) continue;
            ResourceLocation i = fullReMap.get(k);
            try {
                Supplementaries.LOGGER.warn("Remapping tile entity '{}' to '{}'", (Object)mapping.key, (Object)i);
                mapping.remap((IForgeRegistryEntry)((BlockEntityType)ForgeRegistries.BLOCK_ENTITIES.getValue(i)));
            }
            catch (Throwable t) {
                Supplementaries.LOGGER.warn("Remapping  tile entity '{}' to '{}' failed: {}", (Object)mapping.key, (Object)i, (Object)t);
            }
        }
    }

    @SubscribeEvent
    public static void onRemapItems(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings("supplementaries")) {
            Item newBlock;
            String k = mapping.key.m_135815_();
            if (itemReMap.containsKey(k)) {
                ResourceLocation i = itemReMap.get(k);
                try {
                    Supplementaries.LOGGER.warn("Remapping item '{}' to '{}'", (Object)mapping.key, (Object)i);
                    mapping.remap((IForgeRegistryEntry)((Item)ForgeRegistries.ITEMS.getValue(i)));
                }
                catch (Throwable t) {
                    Supplementaries.LOGGER.warn("Remapping item '{}' to '{}' failed: {}", (Object)mapping.key, (Object)i, (Object)t);
                }
                continue;
            }
            if (k.contains("hanging_sign")) {
                try {
                    newBlock = RemapHandler.getNewBlock(ModRegistry.HANGING_SIGNS_ITEMS, k);
                    if (newBlock == null) {
                        newBlock = ModRegistry.HANGING_SIGNS_ITEMS.get(WoodType.OAK_WOOD_TYPE);
                    }
                    mapping.remap((IForgeRegistryEntry)newBlock);
                }
                catch (Exception ex) {
                    Supplementaries.LOGGER.warn("Remapping block '{}' failed: {}", (Object)mapping.key, (Object)ex);
                }
                continue;
            }
            if (!k.contains("sign_post")) continue;
            try {
                newBlock = RemapHandler.getNewBlock(ModRegistry.SIGN_POST_ITEMS, k);
                if (newBlock == null) {
                    newBlock = ModRegistry.SIGN_POST_ITEMS.get(WoodType.OAK_WOOD_TYPE);
                }
                mapping.remap((IForgeRegistryEntry)newBlock);
            }
            catch (Exception ex) {
                Supplementaries.LOGGER.warn("Remapping block '{}' failed: {}", (Object)mapping.key, (Object)ex);
            }
        }
    }

    public static void onRemapEntityTypes(RegistryEvent.MissingMappings<EntityType<?>> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getMappings("supplementaries")) {
            if (!fullReMap.containsKey(mapping.key.m_135815_())) continue;
            try {
                Supplementaries.LOGGER.warn("Remapping entity '{}' to '{}'", (Object)mapping.key, (Object)fullReMap.get(mapping.key.m_135815_()));
                mapping.remap((IForgeRegistryEntry)((EntityType)ForgeRegistries.ENTITIES.getValue(fullReMap.get(mapping.key.m_135815_()))));
            }
            catch (Throwable t) {
                Supplementaries.LOGGER.warn("Remapping entity '{}' to '{}' failed: {}", (Object)mapping.key, (Object)fullReMap.get(mapping.key.m_135815_()), (Object)t);
            }
        }
    }

    @Deprecated
    public static String getLegacyWoodTypeAppendableID(WoodType wood) {
        String l = RemapHandler.getLegacyAbbreviation(wood.getNamespace());
        return l != null ? "_" + wood.getWoodName() + l : "_" + wood.getAppendableId();
    }

    @Nullable
    public static String getLegacyAbbreviation(String modName) {
        return switch (modName) {
            default -> null;
            case "minecraft", "tofucraft", "betterendforge", "malum", "mowziesmobs", "ars_nouveau", "the_bumblezone", "undergarden", "endergetic", "omni", "byg", "mysticalworld", "bamboo_blocks", "good_nights_sleep", "pokecube", "simplytea", "outer_end", "upgrade_aquatic", "atmospheric", "domum_ornamentum", "architects_palette", "botania", "enhanced_mushrooms", "druidcraft", "silentgear", "eidolon", "greekfantasy", "forbidden_arcanus", "pokecube_legends" -> "";
            case "habitat" -> "_hbt";
            case "abundance" -> "_ab";
            case "biomesoplenty" -> "_bop";
            case "biomemakeover" -> "_bm";
            case "terraincognita" -> "_te";
            case "bayou_blues" -> "_bb";
            case "extendedmushrooms" -> "_em";
            case "rediscovered" -> "_red";
            case "autumnity" -> "_aut";
            case "unnamedanimalmod" -> "_un";
            case "premium_wood" -> "_pw";
            case "environmental" -> "_env";
            case "desolation" -> "_de";
            case "morecraft" -> "_mc";
            case "atum" -> "_atum";
            case "traverse" -> "_tr";
            case "lotr" -> "_lotr";
            case "terraqueous" -> "_ter";
            case "twilightforest" -> "_tf";
        };
    }

    @Nullable
    private static <T extends ForgeRegistryEntry<?>> T getNewBlock(Map<WoodType, T> newEntries, String oldPath) {
        for (ForgeRegistryEntry b : newEntries.values()) {
            String abb;
            String match;
            String path = b.getRegistryName().m_135815_();
            String[] modId = path.split("/");
            if (modId.length != 2 || !oldPath.equals(match = modId[1] + (abb = RemapHandler.getLegacyAbbreviation(modId[0])))) continue;
            return (T)b;
        }
        return null;
    }

    static {
        fullReMap.put("jar_tinted", Supplementaries.res("jar"));
    }
}

