/*
 * Decompiled with CFR 0.152.
 */
package fr.raksrinana.fallingtree.forge.common;

import fr.raksrinana.fallingtree.common.FallingTreeCommon;
import fr.raksrinana.fallingtree.common.leaf.LeafBreakingHandler;
import fr.raksrinana.fallingtree.common.wrapper.DirectionCompat;
import fr.raksrinana.fallingtree.common.wrapper.IBlock;
import fr.raksrinana.fallingtree.common.wrapper.IBlockPos;
import fr.raksrinana.fallingtree.common.wrapper.IBlockState;
import fr.raksrinana.fallingtree.common.wrapper.IComponent;
import fr.raksrinana.fallingtree.common.wrapper.IEnchantment;
import fr.raksrinana.fallingtree.common.wrapper.IItem;
import fr.raksrinana.fallingtree.common.wrapper.ILevel;
import fr.raksrinana.fallingtree.common.wrapper.IPlayer;
import fr.raksrinana.fallingtree.forge.common.wrapper.BlockWrapper;
import fr.raksrinana.fallingtree.forge.common.wrapper.ComponentWrapper;
import fr.raksrinana.fallingtree.forge.common.wrapper.EnchantmentWrapper;
import fr.raksrinana.fallingtree.forge.common.wrapper.ItemWrapper;
import fr.raksrinana.fallingtree.forge.event.BlockBreakListener;
import fr.raksrinana.fallingtree.forge.event.FallingTreeBlockBreakEvent;
import fr.raksrinana.fallingtree.forge.event.FallingTreeEnchantments;
import fr.raksrinana.fallingtree.forge.event.LeafBreakingListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;

public class FallingTreeCommonsImpl
extends FallingTreeCommon<Direction> {
    private final LeafBreakingHandler leafBreakingHandler = new LeafBreakingHandler(this);
    private Collection<IEnchantment> chopperEnchantments = new ArrayList<IEnchantment>();

    @Override
    @NotNull
    public IComponent translate(@NotNull String key, Object ... objects) {
        return new ComponentWrapper((MutableComponent)new TranslatableComponent(key, objects));
    }

    @Override
    @NotNull
    public Stream<IBlock> getBlock(@NotNull String name) {
        try {
            boolean isTag = name.startsWith("#");
            if (isTag) {
                name = name.substring(1);
            }
            ResourceLocation resourceLocation = new ResourceLocation(name);
            if (isTag) {
                TagKey tag = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)resourceLocation);
                return this.getRegistryTagContent((Registry)Registry.f_122824_, (TagKey)tag).map(BlockWrapper::new);
            }
            return Stream.of((Block)ForgeRegistries.BLOCKS.getValue(resourceLocation)).filter(Objects::nonNull).map(BlockWrapper::new);
        }
        catch (Exception e) {
            return Stream.empty();
        }
    }

    @Override
    @NotNull
    public Stream<IItem> getItem(@NotNull String name) {
        try {
            boolean isTag = name.startsWith("#");
            if (isTag) {
                name = name.substring(1);
            }
            ResourceLocation resourceLocation = new ResourceLocation(name);
            if (isTag) {
                TagKey tag = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)resourceLocation);
                return this.getRegistryTagContent((Registry)Registry.f_122827_, (TagKey)tag).map(ItemWrapper::new);
            }
            return Stream.of((Item)ForgeRegistries.ITEMS.getValue(resourceLocation)).filter(Objects::nonNull).map(ItemWrapper::new);
        }
        catch (Exception e) {
            return Stream.empty();
        }
    }

    @Override
    public boolean isLeafBlock(@NotNull IBlock block) {
        boolean isAllowedBlock;
        boolean bl = isAllowedBlock = this.registryTagContains((Registry)Registry.f_122824_, (TagKey)BlockTags.f_13035_, (Object)((Block)block.getRaw())) || this.getConfiguration().getTrees().getAllowedLeaveBlocks(this).stream().anyMatch(leaf -> leaf.equals(block));
        if (isAllowedBlock) {
            boolean isDeniedBlock = this.getConfiguration().getTrees().getDeniedLeaveBlocks(this).stream().anyMatch(leaf -> leaf.equals(block));
            return !isDeniedBlock;
        }
        return false;
    }

    @Override
    public boolean isLogBlock(@NotNull IBlock block) {
        boolean isAllowedBlock;
        boolean bl = isAllowedBlock = this.getConfiguration().getTrees().getDefaultLogsBlocks(this).stream().anyMatch(log -> log.equals(block)) || this.getConfiguration().getTrees().getAllowedLogBlocks(this).stream().anyMatch(log -> log.equals(block));
        if (isAllowedBlock) {
            boolean isDeniedBlock = this.getConfiguration().getTrees().getDeniedLogBlocks(this).stream().anyMatch(log -> log.equals(block));
            return !isDeniedBlock;
        }
        return false;
    }

    @Override
    @NotNull
    public Set<IBlock> getAllNonStrippedLogsBlocks() {
        return this.getRegistryTagContent((Registry)Registry.f_122824_, (TagKey)BlockTags.f_13106_).filter(block -> Optional.ofNullable(ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block)).map(ResourceLocation::m_135815_).map(name -> name.startsWith("stripped")).orElse(false) == false).map(BlockWrapper::new).collect(Collectors.toSet());
    }

    @Override
    @NotNull
    public DirectionCompat asDirectionCompat(@NotNull Direction dir) {
        return DirectionCompat.valueOf(dir.name());
    }

    @Override
    @NotNull
    public Direction asDirection(@NotNull DirectionCompat dir) {
        return Direction.valueOf((String)dir.name());
    }

    @Override
    public boolean isNetherWartOrShroomlight(@NotNull IBlock block) {
        return this.registryTagContains((Registry)Registry.f_122824_, (TagKey)BlockTags.f_13078_, (Object)((Block)block.getRaw())) || Blocks.f_50701_.equals(block.getRaw());
    }

    @Override
    public boolean checkCanBreakBlock(@NotNull ILevel level, @NotNull IBlockPos blockPos, @NotNull IBlockState blockState, @NotNull IPlayer player) {
        return !MinecraftForge.EVENT_BUS.post((Event)new FallingTreeBlockBreakEvent((Level)level.getRaw(), (BlockPos)blockPos.getRaw(), (BlockState)blockState.getRaw(), (Player)player.getRaw()));
    }

    @Override
    protected void performDefaultEnchantRegister() {
        FallingTreeEnchantments.registerDefault();
    }

    @Override
    protected void performSpecificEnchantRegister() {
        FallingTreeEnchantments.registerSpecific();
    }

    @Override
    protected void performCommitEnchantRegister() {
        FallingTreeEnchantments.commit(FMLJavaModLoadingContext.get().getModEventBus());
        Stream.of(FallingTreeEnchantments.CHOPPER_ENCHANTMENT, FallingTreeEnchantments.CHOPPER_INSTANTANEOUS_ENCHANTMENT, FallingTreeEnchantments.CHOPPER_SHIFT_DOWN_ENCHANTMENT).filter(Objects::nonNull).map(EnchantmentWrapper::new).forEach(this.chopperEnchantments::add);
    }

    @NotNull
    private <T> Stream<T> getRegistryTagContent(@NotNull Registry<T> registry, @NotNull TagKey<T> tag) {
        return registry.m_203431_(tag).stream().flatMap(a -> a.m_203614_().map(Holder::m_203334_));
    }

    private <T> boolean registryTagContains(@NotNull Registry<T> registry, @NotNull TagKey<T> tag, @NotNull T element) {
        return this.getRegistryTagContent(registry, tag).anyMatch(element::equals);
    }

    public void registerForge(@NotNull IEventBus eventBus) {
        eventBus.register((Object)new BlockBreakListener(this));
        eventBus.register((Object)new LeafBreakingListener(this));
    }

    @Override
    public LeafBreakingHandler getLeafBreakingHandler() {
        return this.leafBreakingHandler;
    }

    @Override
    public Collection<IEnchantment> getChopperEnchantments() {
        return this.chopperEnchantments;
    }
}

