/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.stalwartdungeons.init;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.mcreator.stalwartdungeons.world.features.AwfulDungeonsFeature;
import net.mcreator.stalwartdungeons.world.features.EndDungeonFeature;
import net.mcreator.stalwartdungeons.world.features.KeepingCastleFeature;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber
public class StalwartDungeonsModFeatures {
    public static final DeferredRegister<Feature<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"stalwart_dungeons");
    private static final List<FeatureRegistration> FEATURE_REGISTRATIONS = new ArrayList<FeatureRegistration>();
    public static final RegistryObject<Feature<?>> END_DUNGEON = StalwartDungeonsModFeatures.register("end_dungeon", EndDungeonFeature::feature, new FeatureRegistration(GenerationStep.Decoration.SURFACE_STRUCTURES, EndDungeonFeature.GENERATE_BIOMES, EndDungeonFeature::placedFeature));
    public static final RegistryObject<Feature<?>> AWFUL_DUNGEONS = StalwartDungeonsModFeatures.register("awful_dungeons", AwfulDungeonsFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_STRUCTURES, AwfulDungeonsFeature.GENERATE_BIOMES, AwfulDungeonsFeature::placedFeature));
    public static final RegistryObject<Feature<?>> KEEPING_CASTLE = StalwartDungeonsModFeatures.register("keeping_castle", KeepingCastleFeature::feature, new FeatureRegistration(GenerationStep.Decoration.UNDERGROUND_STRUCTURES, KeepingCastleFeature.GENERATE_BIOMES, KeepingCastleFeature::placedFeature));

    private static RegistryObject<Feature<?>> register(String registryname, Supplier<Feature<?>> feature, FeatureRegistration featureRegistration) {
        FEATURE_REGISTRATIONS.add(featureRegistration);
        return REGISTRY.register(registryname, feature);
    }

    @SubscribeEvent
    public static void addFeaturesToBiomes(BiomeLoadingEvent event) {
        for (FeatureRegistration registration : FEATURE_REGISTRATIONS) {
            if (registration.biomes() != null && !registration.biomes().contains(event.getName())) continue;
            event.getGeneration().getFeatures(registration.stage()).add(registration.placedFeature().get());
        }
    }

    private record FeatureRegistration(GenerationStep.Decoration stage, Set<ResourceLocation> biomes, Supplier<Holder<PlacedFeature>> placedFeature) {
    }
}

