/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.resourcepack.asset_generators;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.StringUtils;

public class LangBuilder {
    private final Map<String, String> entries = new LinkedHashMap<String, String>();

    public static String getReadableName(String name) {
        return Arrays.stream(name.replace(":", "_").split("_")).map(StringUtils::capitalize).collect(Collectors.joining(" "));
    }

    public void addGenericEntry(String key, String translation) {
        this.entries.put(key, translation);
    }

    public void addEntry(Block block, String translation) {
        this.entries.put(block.m_7705_(), translation);
    }

    public void addEntry(Item item, String translation) {
        this.entries.put(item.m_5524_(), translation);
    }

    public void addEntry(EntityType<?> entityType, String translation) {
        this.entries.put(entityType.m_20675_(), translation);
    }

    public JsonElement build() {
        JsonObject json = new JsonObject();
        for (Map.Entry<String, String> e : this.entries.entrySet()) {
            json.addProperty(e.getKey(), e.getValue());
        }
        return json;
    }
}

