/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene.resourcepack.asset_generators.textures;

import com.mojang.blaze3d.platform.NativeImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import net.mehvahdjukaar.selene.resourcepack.asset_generators.textures.PaletteColor;
import net.mehvahdjukaar.selene.resourcepack.asset_generators.textures.SpriteUtils;
import org.jetbrains.annotations.Nullable;

public class Palette {
    private static final Comparator<PaletteColor> COMPARATOR = (a, b) -> Float.compare(a.luminance, b.luminance);
    private final ArrayList<PaletteColor> internal = new ArrayList();

    public int size() {
        return this.internal.size();
    }

    public List<PaletteColor> getValues() {
        return this.internal;
    }

    private void sort() {
        this.internal.sort(COMPARATOR);
    }

    public Palette(Collection<PaletteColor> colors) {
        this.internal.addAll(colors);
        this.sort();
    }

    public void add(PaletteColor color) {
        this.internal.add(color);
        this.sort();
    }

    public void add(int index, PaletteColor color) {
        this.internal.add(index, color);
        this.sort();
    }

    public void set(int index, PaletteColor color) {
        this.internal.set(index, color);
    }

    public PaletteColor get(int index) {
        return this.internal.get(index);
    }

    public PaletteColor getDarkest() {
        return this.get(0);
    }

    public PaletteColor getLightest() {
        return this.get(this.internal.size() - 1);
    }

    public void remove(int index) {
        this.internal.remove(index);
        this.sort();
    }

    public void remove(PaletteColor color) {
        this.internal.remove(color);
        this.sort();
    }

    public int calculateAverage() {
        return SpriteUtils.averageColors((Integer[])this.internal.stream().map(c -> c.color).toArray(Integer[]::new));
    }

    public static Palette fromImage(NativeImage image) {
        return Palette.fromImage(image, null);
    }

    public static Palette fromImage(NativeImage image, @Nullable NativeImage mask) {
        HashMap<Integer, PaletteColor> map = new HashMap<Integer, PaletteColor>();
        for (int x = 0; x < image.m_84982_(); ++x) {
            for (int y = 0; y < image.m_85084_(); ++y) {
                int color;
                if (mask != null && NativeImage.m_84983_((int)mask.m_84985_(x, y)) != 0 || NativeImage.m_84983_((int)(color = image.m_84985_(x, y))) == 0) continue;
                int finalX = x;
                int finalY = y;
                PaletteColor paletteColor = map.computeIfAbsent(color, p -> new PaletteColor(finalX, finalY, color));
                ++paletteColor.occurrence;
            }
        }
        if (map.size() == 0) {
            throw new UnsupportedOperationException("Palette mask must not cover the whole image");
        }
        return new Palette(map.values());
    }

    public void matchSize(int targetSize) {
        if (this.size() <= 0 || targetSize <= 0) {
            throw new UnsupportedOperationException("Palette size can't be 0");
        }
        this.maybeReducePalette(targetSize);
        this.maybeIncreasePalette(targetSize);
    }

    private void maybeReducePalette(int targetSize) {
        while (this.internal.size() > targetSize) {
            PaletteColor toRemove = this.internal.get(0);
            for (PaletteColor p : this.internal) {
                if (p.occurrence >= toRemove.occurrence) continue;
                toRemove = p;
            }
            this.internal.remove(toRemove);
        }
        this.sort();
    }

    private void maybeIncreasePalette(int targetSize) {
        while (this.internal.size() < targetSize) {
            float lastLum = 0.0f;
            int ind = 0;
            for (int i = 1; i < this.internal.size(); ++i) {
                float d = this.internal.get((int)i).luminance - this.internal.get((int)(i - 1)).luminance;
                if (!(d > lastLum)) continue;
                lastLum = d;
                ind = i;
            }
            int newColor = SpriteUtils.averageColors(this.internal.get((int)(ind - 1)).color, this.internal.get((int)ind).color);
            this.internal.add(new PaletteColor(0, 0, newColor));
            this.sort();
        }
    }

    public void increaseUp() {
        PaletteColor lightest = this.getLightest();
        PaletteColor secondLightest = this.get(this.size() - 2);
        float[] h1 = SpriteUtils.RGBtoHSV(lightest.color);
        float[] h2 = SpriteUtils.RGBtoHSV(secondLightest.color);
        float v1 = h1[2];
        float v2 = h2[2];
        float dv = v2 - v1;
        float hue1 = h1[0];
        float hue2 = h2[0];
        float dh = hue2 - hue1;
        float sat1 = h1[1];
        float sat2 = h2[1];
        float ds = sat2 - sat1;
        float newHue = hue1 + dh / dv * 2.0f * dv;
        float newSat = sat1 + ds / dv * 2.0f * dv;
        float newVal = v1 + dv;
        this.add(new PaletteColor(SpriteUtils.HSVtoRGB(newHue, newSat, newVal)));
    }

    public void increaseDown() {
        PaletteColor darkest = this.getDarkest();
        PaletteColor secondDarkest = this.get(1);
        float[] h2 = SpriteUtils.RGBtoHSV(darkest.color);
        float[] h1 = SpriteUtils.RGBtoHSV(secondDarkest.color);
        float v1 = h1[2];
        float v2 = h2[2];
        float dv = v2 - v1;
        float hue1 = h1[0];
        float hue2 = h2[0];
        float dh = hue2 - hue1;
        float sat1 = h1[1];
        float sat2 = h2[1];
        float ds = sat2 - sat1;
        float newHue = hue2 - dh * dv;
        float newSat = sat2 - ds * dv;
        float newVal = v2 + dv;
        this.add(new PaletteColor(SpriteUtils.HSVtoRGB(newHue, newSat, newVal)));
    }
}

