/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.entity.container;

import dev.murad.shipping.entity.accessor.DataAccessor;
import dev.murad.shipping.entity.container.AbstractItemHandlerContainer;
import dev.murad.shipping.entity.custom.train.locomotive.AbstractLocomotiveEntity;
import dev.murad.shipping.network.LocomotivePacketHandler;
import dev.murad.shipping.network.SetLocomotiveEnginePacket;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public abstract class AbstractLocomotiveContainer<T extends DataAccessor>
extends AbstractItemHandlerContainer {
    public static final ResourceLocation EMPTY_LOCO_ROUTE = new ResourceLocation("littlelogistics", "item/empty_loco_route");
    public static final ResourceLocation EMPTY_ENERGY = new ResourceLocation("littlelogistics", "item/empty_energy");
    public static final ResourceLocation EMPTY_ATLAS_LOC = InventoryMenu.f_39692_;
    protected T data;
    protected AbstractLocomotiveEntity locomotiveEntity;

    public AbstractLocomotiveContainer(@Nullable MenuType<?> containerType, int windowId, Level world, T data, Inventory playerInventory, Player player) {
        super(containerType, windowId, playerInventory, player);
        this.locomotiveEntity = (AbstractLocomotiveEntity)world.m_6815_(((DataAccessor)data).getEntityUUID());
        this.data = data;
        this.layoutPlayerInventorySlots(8, 84);
        this.m_38884_((ContainerData)data);
        this.m_38897_(new SlotItemHandler((IItemHandler)this.locomotiveEntity.getLocoRouteItemHandler(), 0, 98, 57).setBackground(EMPTY_ATLAS_LOC, EMPTY_LOCO_ROUTE));
    }

    @Override
    protected int getSlotNum() {
        return 2;
    }

    public abstract boolean isOn();

    public abstract int routeSize();

    public abstract int visitedSize();

    public void setEngine(boolean state) {
        LocomotivePacketHandler.INSTANCE.sendToServer((Object)new SetLocomotiveEnginePacket(this.locomotiveEntity.m_142049_(), state));
    }

    public String getRouteText() {
        return this.visitedSize() + "/" + this.routeSize();
    }

    public boolean m_6875_(Player p_75145_1_) {
        return this.locomotiveEntity.m_6542_(p_75145_1_);
    }
}

