/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.entity.custom;

import dev.murad.shipping.entity.custom.VesselEntity;
import dev.murad.shipping.entity.custom.tug.AbstractTugEntity;
import dev.murad.shipping.setup.ModEntityTypes;
import dev.murad.shipping.setup.ModItems;
import dev.murad.shipping.util.EntitySpringAPI;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;

public class SpringEntity
extends Entity
implements IEntityAdditionalSpawnData {
    public static final EntityDataAccessor<Integer> DOMINANT_ID = SynchedEntityData.m_135353_(SpringEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DOMINATED_ID = SynchedEntityData.m_135353_(SpringEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Nullable
    private CompoundTag dominantNBT;
    @Nullable
    private CompoundTag dominatedNBT;
    @Nullable
    private VesselEntity dominant;
    @Nullable
    private VesselEntity dominated;

    public VesselEntity getDominant() {
        return this.dominant;
    }

    public void setDominant(VesselEntity dominant) {
        if (this.dominated != null && dominant != null) {
            dominant.setDominated(this.dominated, this);
            this.dominated.setDominant(dominant, this);
        }
        this.dominant = dominant;
    }

    public void setDominated(VesselEntity dominated) {
        if (dominated != null && this.dominant != null) {
            this.dominant.setDominated(dominated, this);
            dominated.setDominant(this.dominant, this);
        }
        this.dominated = dominated;
    }

    public Entity getDominated() {
        return this.dominant;
    }

    public SpringEntity(EntityType<? extends Entity> type, Level worldIn) {
        super(type, worldIn);
        this.m_20242_(true);
        this.f_19794_ = true;
    }

    public SpringEntity(@Nonnull VesselEntity dominant, @Nonnull VesselEntity dominatedEntity) {
        super((EntityType)ModEntityTypes.SPRING.get(), dominant.m_20193_());
        this.setDominant(dominant);
        this.setDominated(dominatedEntity);
        this.m_6034_((dominant.m_20185_() + this.dominated.m_20185_()) / 2.0, (dominant.m_20186_() + this.dominated.m_20186_()) / 2.0, (dominant.m_20189_() + this.dominated.m_20189_()) / 2.0);
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(DOMINANT_ID, (Object)-1);
        this.m_20088_().m_135372_(DOMINATED_ID, (Object)-1);
    }

    public static Vec3 calculateAnchorPosition(VesselEntity entity, SpringSide side) {
        return EntitySpringAPI.calculateAnchorPosition((Entity)entity, side);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (this.f_19853_.f_46443_) {
            VesselEntity potential;
            if (DOMINANT_ID.equals(key) && (potential = (VesselEntity)this.f_19853_.m_6815_(((Integer)this.m_20088_().m_135370_(DOMINANT_ID)).intValue())) != null) {
                this.setDominant(potential);
            }
            if (DOMINATED_ID.equals(key) && (potential = (VesselEntity)this.f_19853_.m_6815_(((Integer)this.m_20088_().m_135370_(DOMINATED_ID)).intValue())) != null) {
                this.setDominated(potential);
            }
        }
    }

    public Direction m_6350_() {
        return this.dominated.m_6350_();
    }

    public void m_6075_() {
        this.m_20334_(0.0, 0.0, 0.0);
        super.m_6075_();
        if (this.tryLoadAndCalculate()) {
            return;
        }
        this.syncClient();
    }

    private void syncClient() {
        if (this.dominant != null && this.dominated != null) {
            if (!this.f_19853_.f_46443_) {
                this.f_19804_.m_135381_(DOMINANT_ID, (Object)this.dominant.m_142049_());
                this.f_19804_.m_135381_(DOMINATED_ID, (Object)this.dominated.m_142049_());
            }
        } else {
            if (this.dominant == null) {
                this.m_7350_(DOMINANT_ID);
            }
            if (this.dominated == null) {
                this.m_7350_(DOMINATED_ID);
            }
        }
        if (this.f_19853_.f_46443_) {
            if (this.dominant != null && !this.dominant.m_6084_()) {
                this.m_7350_(DOMINANT_ID);
            }
            if (this.dominated != null && !this.dominated.m_6084_()) {
                this.m_7350_(DOMINATED_ID);
            }
        }
    }

    private boolean tryLoadAndCalculate() {
        if (!this.f_19853_.f_46443_) {
            if (this.dominant != null && this.dominated != null && this.dominant.shouldApplySpringPhysics()) {
                if (this.dominated.m_20270_((Entity)this.dominant) > 20.0f) {
                    this.dominated.removeDominant();
                    this.m_6074_();
                    return true;
                }
                if (!this.dominant.m_6084_() || !this.dominated.m_6084_()) {
                    this.m_6074_();
                    return true;
                }
                this.m_6034_((this.dominant.m_20185_() + this.dominated.m_20185_()) / 2.0, (this.dominant.m_20186_() + this.dominated.m_20186_()) / 2.0, (this.dominant.m_20189_() + this.dominated.m_20189_()) / 2.0);
                double distSq = this.dominant.m_20280_((Entity)this.dominated);
                double maxDstSq = this.dominant.getTrain().getTug().map(tug -> ((AbstractTugEntity)tug).isDocked() ? 1.0 : 1.2).orElse(1.2);
                Vec3 frontAnchor = SpringEntity.calculateAnchorPosition(this.dominant, SpringSide.DOMINATED);
                Vec3 backAnchor = SpringEntity.calculateAnchorPosition(this.dominated, SpringSide.DOMINANT);
                double dist = Math.sqrt(distSq);
                double dx = (frontAnchor.f_82479_ - backAnchor.f_82479_) / dist;
                double dy = (frontAnchor.f_82480_ - backAnchor.f_82480_) / dist;
                double dz = (frontAnchor.f_82481_ - backAnchor.f_82481_) / dist;
                double alpha = 0.5;
                float targetYaw = this.computeTargetYaw(Float.valueOf(this.dominated.m_146908_()), frontAnchor, backAnchor);
                this.dominated.m_146922_((float)((0.5 * (double)this.dominated.m_146908_() + (double)targetYaw * 0.5) % 360.0));
                this.m_146922_(this.dominated.m_146908_());
                double k = this.dominant instanceof AbstractTugEntity ? 0.2 : 0.13;
                double l0 = maxDstSq;
                this.dominated.m_20334_(k * (dist - l0) * dx, k * (dist - l0) * dy, k * (dist - l0) * dz);
                this.dominated.m_20101_();
            } else {
                if (this.dominantNBT != null && this.dominatedNBT != null) {
                    this.tryToLoadFromNBT(this.dominantNBT).ifPresent(e -> {
                        this.setDominant((VesselEntity)e);
                        this.f_19804_.m_135381_(DOMINANT_ID, (Object)e.m_142049_());
                    });
                    this.tryToLoadFromNBT(this.dominatedNBT).ifPresent(e -> {
                        this.setDominated((VesselEntity)e);
                        this.f_19804_.m_135381_(DOMINATED_ID, (Object)e.m_142049_());
                    });
                }
                this.updateClient();
            }
        }
        return false;
    }

    private void updateClient() {
        if (this.f_19853_.f_46443_) {
            Entity potential_dominated;
            Entity potential;
            if (this.dominant == null && (potential = this.f_19853_.m_6815_(((Integer)this.m_20088_().m_135370_(DOMINANT_ID)).intValue())) != null) {
                this.setDominant((VesselEntity)potential);
            }
            if (this.dominated == null && (potential_dominated = this.f_19853_.m_6815_(((Integer)this.m_20088_().m_135370_(DOMINATED_ID)).intValue())) != null) {
                this.setDominated((VesselEntity)potential_dominated);
            }
        }
    }

    private float computeTargetYaw(Float currentYaw, Vec3 anchorPos, Vec3 otherAnchorPos) {
        float idealYaw = (float)(Math.atan2(otherAnchorPos.f_82479_ - anchorPos.f_82479_, -(otherAnchorPos.f_82481_ - anchorPos.f_82481_)) * 57.29577951308232);
        float closestDistance = Float.POSITIVE_INFINITY;
        float closest = idealYaw;
        for (int sign : Arrays.asList(-1, 0, 1)) {
            float potentialYaw = idealYaw + (float)sign * 360.0f;
            float distance = Math.abs(potentialYaw - currentYaw.floatValue());
            if (!(distance < closestDistance)) continue;
            closestDistance = distance;
            closest = potentialYaw;
        }
        return closest;
    }

    private Optional<VesselEntity> tryToLoadFromNBT(CompoundTag compound) {
        try {
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            pos.m_122178_(compound.m_128451_("X"), compound.m_128451_("Y"), compound.m_128451_("Z"));
            String uuid = compound.m_128461_("UUID");
            AABB searchBox = new AABB((double)(pos.m_123341_() - 2), (double)(pos.m_123342_() - 2), (double)(pos.m_123343_() - 2), (double)(pos.m_123341_() + 2), (double)(pos.m_123342_() + 2), (double)(pos.m_123343_() + 2));
            List entities = this.f_19853_.m_6249_((Entity)this, searchBox, e -> e.m_20149_().equals(uuid));
            return entities.stream().findFirst().map(e -> (VesselEntity)e);
        }
        catch (Exception e2) {
            return Optional.empty();
        }
    }

    protected void m_7378_(CompoundTag compound) {
        this.dominantNBT = compound.m_128469_(SpringSide.DOMINANT.name());
        this.dominatedNBT = compound.m_128469_(SpringSide.DOMINATED.name());
    }

    protected void m_7380_(CompoundTag compound) {
        if (this.dominant != null && this.dominated != null) {
            this.writeNBT(SpringSide.DOMINANT, (Entity)this.dominant, compound);
            this.writeNBT(SpringSide.DOMINATED, (Entity)this.dominated, compound);
        } else {
            if (this.dominantNBT != null) {
                compound.m_128365_(SpringSide.DOMINANT.name(), (Tag)this.dominantNBT);
            }
            if (this.dominatedNBT != null) {
                compound.m_128365_(SpringSide.DOMINATED.name(), (Tag)this.dominatedNBT);
            }
        }
    }

    private void writeNBT(SpringSide side, Entity entity, CompoundTag globalCompound) {
        CompoundTag compound = new CompoundTag();
        compound.m_128405_("X", (int)Math.floor(entity.m_20185_()));
        compound.m_128405_("Y", (int)Math.floor(entity.m_20186_()));
        compound.m_128405_("Z", (int)Math.floor(entity.m_20189_()));
        compound.m_128359_("UUID", entity.m_142081_().toString());
        globalCompound.m_128365_(side.name(), (Tag)compound);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        if (this.dominated != null && this.dominant != null) {
            buffer.writeBoolean(true);
            buffer.writeInt(this.dominant.m_142049_());
            buffer.writeInt(this.dominated.m_142049_());
            CompoundTag dominatedNBT = new CompoundTag();
            this.writeNBT(SpringSide.DOMINATED, (Entity)this.dominated, dominatedNBT);
            CompoundTag dominantNBT = new CompoundTag();
            this.writeNBT(SpringSide.DOMINANT, (Entity)this.dominant, dominantNBT);
            buffer.m_130079_(dominantNBT);
            buffer.m_130079_(dominatedNBT);
        } else {
            buffer.writeBoolean(false);
        }
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        if (additionalData.readBoolean()) {
            int frontID = additionalData.readInt();
            int backID = additionalData.readInt();
            this.setDominant((VesselEntity)this.f_19853_.m_6815_(frontID));
            this.setDominated((VesselEntity)this.f_19853_.m_6815_(backID));
            this.dominantNBT = additionalData.m_130260_();
            this.dominatedNBT = additionalData.m_130260_();
        }
    }

    public static void createSpring(VesselEntity dominantEntity, VesselEntity dominatedEntity) {
        SpringEntity link = new SpringEntity(dominantEntity, dominatedEntity);
        Level world = dominantEntity.m_20193_();
        world.m_7967_((Entity)link);
    }

    public AABB m_6921_() {
        return BlockEntity.INFINITE_EXTENT_AABB;
    }

    public InteractionResult m_7111_(Player player, Vec3 vec, InteractionHand hand) {
        return super.m_7111_(player, vec, hand);
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_142687_(Entity.RemovalReason r) {
        super.m_142687_(r);
        if (this.dominant != null) {
            this.dominant.removeDominated();
        }
        if (!this.f_19853_.f_46443_) {
            Containers.m_18992_((Level)this.f_19853_, (double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_(), (ItemStack)new ItemStack((ItemLike)ModItems.SPRING.get()));
        }
    }

    public static enum SpringSide {
        DOMINANT,
        DOMINATED;

    }
}

