/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.entity.custom.train.locomotive;

import dev.murad.shipping.ShippingConfig;
import dev.murad.shipping.block.rail.MultiShapeRail;
import dev.murad.shipping.block.rail.blockentity.LocomotiveDockTileEntity;
import dev.murad.shipping.capability.StallingCapability;
import dev.murad.shipping.entity.accessor.DataAccessor;
import dev.murad.shipping.entity.custom.train.AbstractTrainCarEntity;
import dev.murad.shipping.entity.custom.tug.VehicleFrontPart;
import dev.murad.shipping.entity.navigation.LocomotiveNavigator;
import dev.murad.shipping.item.LocoRouteItem;
import dev.murad.shipping.setup.ModBlocks;
import dev.murad.shipping.setup.ModSounds;
import dev.murad.shipping.util.ItemHandlerVanillaContainerWrapper;
import dev.murad.shipping.util.LinkableEntityHead;
import dev.murad.shipping.util.LocoRoute;
import dev.murad.shipping.util.RailHelper;
import dev.murad.shipping.util.Train;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PoweredRailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;

public abstract class AbstractLocomotiveEntity
extends AbstractTrainCarEntity
implements LinkableEntityHead<AbstractTrainCarEntity>,
ItemHandlerVanillaContainerWrapper {
    protected boolean engineOn = false;
    private boolean doflip = false;
    private boolean independentMotion = false;
    private boolean docked = false;
    private static double LOCO_SPEED = (Double)ShippingConfig.Server.LOCO_BASE_SPEED.get();
    private final VehicleFrontPart frontHitbox;
    private int speedRecomputeCooldown = 0;
    private double speedLimit = -1.0;
    private int collisionCheckCooldown = 0;
    private int remainingStallTime = 0;
    private boolean forceStallCheck = false;
    private BlockPos currentHorizontalBlockPos;
    @Nullable
    private BlockPos oldHorizontalBlockPos;
    private static final String LOCO_ROUTE_INV_TAG = "locoRouteInv";
    protected ItemStackHandler locoRouteItemHandler = this.createLocoRouteItemHandler();
    private static final String NAVIGATOR_TAG = "navigator";
    protected LocomotiveNavigator navigator = new LocomotiveNavigator(this);
    private static final EntityDataAccessor<Boolean> INDEPENDENT_MOTION = SynchedEntityData.m_135353_(AbstractLocomotiveEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int dockCheckCooldown = 0;
    protected final StallingCapability stalling = new StallingCapability(){

        @Override
        public boolean isDocked() {
            return AbstractLocomotiveEntity.this.docked;
        }

        @Override
        public void dock(double x, double y, double z) {
            AbstractLocomotiveEntity.this.docked = true;
            AbstractLocomotiveEntity.this.m_20256_(Vec3.f_82478_);
            AbstractLocomotiveEntity.this.m_6027_(x, y, z);
        }

        @Override
        public void undock() {
            AbstractLocomotiveEntity.this.docked = false;
        }

        @Override
        public boolean isStalled() {
            return AbstractLocomotiveEntity.this.remainingStallTime <= 0;
        }

        @Override
        public void stall() {
            AbstractLocomotiveEntity.this.remainingStallTime = 20;
        }

        @Override
        public void unstall() {
            AbstractLocomotiveEntity.this.remainingStallTime = 0;
        }

        @Override
        public boolean isFrozen() {
            return AbstractLocomotiveEntity.super.isFrozen();
        }

        @Override
        public void freeze() {
            AbstractLocomotiveEntity.this.setFrozen(true);
        }

        @Override
        public void unfreeze() {
            AbstractLocomotiveEntity.this.setFrozen(false);
        }
    };
    private final LazyOptional<StallingCapability> stallingOpt = LazyOptional.of(() -> this.stalling);

    public AbstractLocomotiveEntity(EntityType<?> type, Level world) {
        super(type, world);
        this.frontHitbox = new VehicleFrontPart((Entity)this);
    }

    public AbstractLocomotiveEntity(EntityType<?> type, Level level, Double x, Double y, Double z) {
        super(type, level, x, y, z);
        this.frontHitbox = new VehicleFrontPart((Entity)this);
    }

    @Override
    public boolean allowDockInterface() {
        return this.docked;
    }

    @Override
    public void m_142687_(Entity.RemovalReason r) {
        if (!this.f_19853_.f_46443_) {
            this.m_19983_(this.locoRouteItemHandler.getStackInSlot(0));
        }
        super.m_142687_(r);
    }

    public InteractionResult m_6096_(Player pPlayer, InteractionHand pHand) {
        if (!pHand.equals((Object)InteractionHand.MAIN_HAND)) {
            return InteractionResult.PASS;
        }
        if (!this.f_19853_.f_46443_) {
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)pPlayer), (MenuProvider)this.createContainerProvider(), this.getDataAccessor()::write);
        }
        return InteractionResult.CONSUME;
    }

    private ItemStackHandler createLocoRouteItemHandler() {
        return new ItemStackHandler(1){

            protected int getStackLimit(int slot, @Nonnull ItemStack stack) {
                return 1;
            }

            protected void onContentsChanged(int slot) {
                AbstractLocomotiveEntity.this.updateNavigatorFromItem();
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return stack.m_41720_() instanceof LocoRouteItem;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    protected abstract MenuProvider createContainerProvider();

    public abstract DataAccessor getDataAccessor();

    protected abstract boolean tickFuel();

    @Override
    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (this.f_19853_.f_46443_ && INDEPENDENT_MOTION.equals(key)) {
            this.independentMotion = (Boolean)this.f_19804_.m_135370_(INDEPENDENT_MOTION);
        }
    }

    @Override
    public void m_8119_() {
        super.tickLoad();
        if (!this.f_19853_.f_46443_) {
            this.tickOldBlockPos();
            if (this.remainingStallTime <= 0) {
                this.navigator.serverTick();
            }
        }
        this.tickYRot();
        float yrot = this.m_146908_();
        this.tickVanilla();
        this.m_146922_(yrot);
        if (this.dominated.isEmpty() && this.m_20184_().m_82553_() > 0.05) {
            this.m_146922_(RailHelper.directionFromVelocity(this.m_20184_()).m_122435_());
        }
        if (!this.f_19853_.f_46443_) {
            this.tickDockCheck();
            this.tickMovement();
        }
        if (this.f_19853_.f_46443_ && this.independentMotion) {
            this.doMovementEffect();
        }
        this.frontHitbox.updatePosition((Entity)this);
    }

    private void tickOldBlockPos() {
        if (this.oldHorizontalBlockPos == null || this.currentHorizontalBlockPos == null) {
            this.oldHorizontalBlockPos = this.getBlockPos();
            this.currentHorizontalBlockPos = this.getBlockPos();
        } else if (this.currentHorizontalBlockPos.m_123341_() != this.m_146903_() || this.currentHorizontalBlockPos.m_123343_() != this.m_146907_()) {
            this.oldHorizontalBlockPos = this.currentHorizontalBlockPos;
            this.currentHorizontalBlockPos = this.getBlockPos();
        }
    }

    @Override
    public float getMaxCartSpeedOnRail() {
        return (float)(TRAIN_SPEED * 0.8);
    }

    public void flip() {
        this.m_146922_(this.m_6350_().m_122424_().m_122435_());
    }

    protected void doMovementEffect() {
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(INDEPENDENT_MOTION, (Object)false);
    }

    private void tickMovement() {
        if (this.remainingStallTime > 0) {
            --this.remainingStallTime;
            if (this.remainingStallTime == 0) {
                this.forceStallCheck = true;
            }
        } else if (this.collisionCheckCooldown <= 0 || this.forceStallCheck) {
            Optional<Integer> result = this.railHelper.traverse(this.m_20097_().m_7494_(), this.f_19853_, this.m_6350_(), (dir, pos) -> this.checkCollision((BlockPos)pos) || this.checkStopSign((BlockPos)pos, (Direction)dir), 4);
            if (result.isPresent()) {
                this.remainingStallTime = 40;
                if (result.get() < 2) {
                    this.m_20334_(0.0, this.m_20184_().f_82480_, 0.0);
                } else {
                    this.m_20334_(this.m_20184_().f_82479_ * 0.05, this.m_20184_().f_82480_, this.m_20184_().f_82481_ * 0.05);
                }
            }
            this.collisionCheckCooldown = 4;
            this.forceStallCheck = false;
        } else {
            --this.collisionCheckCooldown;
        }
        if (!this.docked && this.engineOn && this.remainingStallTime <= 0 && !this.forceStallCheck && !this.shouldFreezeTrain() && this.tickFuel()) {
            this.tickSpeedLimit();
            this.f_19804_.m_135381_(INDEPENDENT_MOTION, (Object)true);
            this.accelerate();
        } else if (RailHelper.getRail(this.m_20097_().m_7494_(), this.f_19853_).map(this.railHelper::getShape).map(Enum::name).map(s -> s.contains("ASCENDING")).orElse(true).booleanValue() && this.tickFuel()) {
            this.m_20256_(Vec3.f_82478_);
            this.f_19804_.m_135381_(INDEPENDENT_MOTION, (Object)true);
            this.m_6034_(this.f_19790_, this.f_19791_, this.f_19792_);
        } else {
            this.f_19804_.m_135381_(INDEPENDENT_MOTION, (Object)false);
        }
        if (this.shouldFreezeTrain()) {
            this.train.asList().forEach(t -> t.m_20334_(0.0, 0.0, 0.0));
        }
    }

    private boolean checkStopSign(BlockPos pos, Direction prevExitTaken) {
        return RailHelper.getRail(pos, this.f_19853_).flatMap(block -> {
            Block patt10204$temp = this.f_19853_.m_8055_(block).m_60734_();
            if (patt10204$temp instanceof MultiShapeRail) {
                MultiShapeRail r = (MultiShapeRail)patt10204$temp;
                if (!this.f_19853_.m_6443_(Entity.class, new AABB(pos), e -> e.equals((Object)this) || e.equals((Object)this.frontHitbox)).isEmpty()) {
                    return Optional.empty();
                }
                return r.getPriorityDirectionsToCheck(this.f_19853_.m_8055_(block), prevExitTaken.m_122424_()).stream().map(p -> this.railHelper.traverse(pos.m_142300_(p), this.f_19853_, (Direction)p, (dir, f) -> this.checkLocoCollision((BlockPos)f), 2)).map(Optional::isPresent).reduce(Boolean::logicalOr);
            }
            return Optional.of(false);
        }).orElse(false);
    }

    private boolean checkCollision(BlockPos pos) {
        AABB aabb = new AABB(pos);
        return !this.f_19853_.m_6443_(Entity.class, aabb, e -> {
            if (e instanceof AbstractTrainCarEntity) {
                AbstractTrainCarEntity t = (AbstractTrainCarEntity)e;
                return t.getTrain().getTug().map(f -> !f.m_142081_().equals(this.m_142081_())).orElse(true);
            }
            if (e instanceof AbstractMinecart) {
                return true;
            }
            if (e instanceof VehicleFrontPart) {
                VehicleFrontPart p = (VehicleFrontPart)((Object)e);
                return !p.m_7306_((Entity)this);
            }
            return false;
        }).isEmpty();
    }

    private boolean checkLocoCollision(BlockPos pos) {
        AABB aabb = new AABB(pos);
        return !this.f_19853_.m_6443_(Entity.class, aabb, e -> {
            if (e instanceof AbstractLocomotiveEntity) {
                AbstractLocomotiveEntity t = (AbstractLocomotiveEntity)e;
                return t.getTrain().getTug().map(f -> !f.m_142081_().equals(this.m_142081_())).orElse(true);
            }
            if (e instanceof VehicleFrontPart) {
                VehicleFrontPart p = (VehicleFrontPart)((Object)e);
                return !p.m_7306_((Entity)this);
            }
            return false;
        }).isEmpty();
    }

    public PartEntity<?>[] getParts() {
        return new PartEntity[]{this.frontHitbox};
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public boolean isPoweredCart() {
        return true;
    }

    public void m_141965_(ClientboundAddEntityPacket p_149572_) {
        super.m_141965_(p_149572_);
        this.frontHitbox.m_20234_(p_149572_.m_131496_());
    }

    protected void onDock() {
        this.m_5496_((SoundEvent)ModSounds.TUG_DOCKING.get(), 0.6f, 1.0f);
    }

    protected void onUndock() {
        this.m_5496_((SoundEvent)ModSounds.TUG_UNDOCKING.get(), 0.6f, 1.5f);
    }

    private void tickDockCheck() {
        this.getCapability(StallingCapability.STALLING_CAPABILITY).ifPresent(cap -> {
            boolean changedUndock;
            int x = (int)Math.floor(this.m_20185_());
            int y = (int)Math.floor(this.m_20186_());
            int z = (int)Math.floor(this.m_20189_());
            boolean docked = cap.isDocked();
            if (docked && this.dockCheckCooldown > 0) {
                --this.dockCheckCooldown;
                this.m_20256_(Vec3.f_82478_);
                this.m_6027_((double)x + 0.5, this.m_20186_(), (double)z + 0.5);
                return;
            }
            Function<Double, Double> prepCord = d -> Math.abs(d - (double)d.intValue());
            Predicate<Double> aroundCentre = i -> (Double)prepCord.apply((Double)i) < 0.65 && (Double)prepCord.apply((Double)i) > 0.35;
            if (!aroundCentre.test(this.m_20185_()) || !aroundCentre.test(this.m_20189_())) {
                return;
            }
            boolean shouldDock = Optional.ofNullable(this.f_19853_.m_7702_(this.m_20097_().m_7494_())).filter(entity -> entity instanceof LocomotiveDockTileEntity).map(entity -> (LocomotiveDockTileEntity)((Object)((Object)entity))).map(dock -> dock.hold(this, this.m_6350_())).orElse(false);
            boolean changedDock = !docked && shouldDock;
            boolean bl = changedUndock = docked && !shouldDock;
            if (shouldDock) {
                this.dockCheckCooldown = 20;
                cap.dock((double)x + 0.5, this.m_20186_(), (double)z + 0.5);
            } else {
                this.dockCheckCooldown = 0;
                cap.undock();
            }
            if (changedDock) {
                this.onDock();
            }
            if (changedUndock) {
                this.onUndock();
            }
        });
    }

    private double getSpeedModifier() {
        BlockState state = this.f_19853_.m_8055_(this.m_20097_().m_7494_());
        if (state.m_60713_(Blocks.f_50030_)) {
            if (!((Boolean)state.m_61143_((Property)PoweredRailBlock.f_55215_)).booleanValue()) {
                return 0.0;
            }
            return 0.005;
        }
        return this.getRailShape().map(shape -> switch (shape) {
            case RailShape.NORTH_SOUTH, RailShape.EAST_WEST -> 0.07;
            case RailShape.SOUTH_WEST, RailShape.NORTH_WEST, RailShape.SOUTH_EAST, RailShape.NORTH_EAST -> 0.03;
            default -> 0.07;
        }).orElse(0.0);
    }

    private void tickSpeedLimit() {
        if (this.speedRecomputeCooldown < 0 || this.speedLimit < 0.0) {
            Integer dist = RailHelper.getRail(this.m_20097_().m_7494_(), this.f_19853_).flatMap(pos -> this.railHelper.traverse((BlockPos)pos, this.f_19853_, this.m_6350_(), (direction, p) -> {
                Optional<BlockPos> railoc = RailHelper.getRail(p, this.f_19853_);
                if (railoc.isEmpty()) {
                    return true;
                }
                RailShape shape = this.railHelper.getShape(railoc.get());
                BlockState block = this.f_19853_.m_8055_(railoc.get());
                return !shape.equals((Object)RailShape.EAST_WEST) && !shape.equals((Object)RailShape.NORTH_SOUTH) || block.m_60713_((Block)ModBlocks.LOCOMOTIVE_DOCK_RAIL.get()) || block.m_60734_() instanceof MultiShapeRail;
            }, 12)).orElse(12);
            double minimum = LOCO_SPEED * 0.35;
            double modifier = (double)dist.intValue() / 12.0;
            this.speedLimit = minimum + LOCO_SPEED * 0.65 * modifier;
            this.speedRecomputeCooldown = 10;
        } else {
            --this.speedRecomputeCooldown;
        }
    }

    public boolean shouldFreezeTrain() {
        return this.train.asList().stream().anyMatch(AbstractTrainCarEntity::isFrozen);
    }

    private void accelerate() {
        Direction dir = this.m_6350_();
        if (Math.abs(this.m_20184_().f_82479_) < this.speedLimit && Math.abs(this.m_20184_().f_82481_) < this.speedLimit) {
            double mod = this.getSpeedModifier();
            this.m_5997_((double)dir.m_122429_() * mod, 0.0, (double)dir.m_122431_() * mod);
        }
    }

    @Override
    public void setDominated(AbstractTrainCarEntity entity) {
        this.dominated = Optional.of(entity);
    }

    @Override
    public void setDominant(AbstractTrainCarEntity entity) {
    }

    @Override
    public void removeDominated() {
        this.dominated = Optional.empty();
        this.train.setTail(this);
    }

    @Override
    public void removeDominant() {
    }

    @Override
    public void setTrain(Train train) {
        this.train = train;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap) {
        if (cap == StallingCapability.STALLING_CAPABILITY) {
            return this.stallingOpt.cast();
        }
        return super.getCapability(cap);
    }

    private void updateNavigatorFromItem() {
        ItemStack stack = this.locoRouteItemHandler.getStackInSlot(0);
        if (stack.m_41720_() instanceof LocoRouteItem) {
            this.navigator.updateWithLocoRouteItem(LocoRouteItem.getRoute(stack));
        } else {
            this.navigator.updateWithLocoRouteItem(new LocoRoute());
        }
    }

    @Override
    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_("eo")) {
            this.engineOn = compound.m_128471_("eo");
        }
        this.locoRouteItemHandler.deserializeNBT(compound.m_128469_(LOCO_ROUTE_INV_TAG));
        this.navigator.loadFromNbt(compound.m_128469_(NAVIGATOR_TAG));
        this.updateNavigatorFromItem();
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("eo", this.engineOn);
        compound.m_128365_(LOCO_ROUTE_INV_TAG, (Tag)this.locoRouteItemHandler.serializeNBT());
        compound.m_128365_(NAVIGATOR_TAG, (Tag)this.navigator.saveToNbt());
    }

    public boolean m_6542_(Player pPlayer) {
        if (this.m_146910_()) {
            return false;
        }
        return !(this.m_20280_((Entity)pPlayer) > 64.0);
    }

    public void setEngineOn(boolean engineOn) {
        this.engineOn = engineOn;
    }

    public void setDoflip(boolean doflip) {
        this.doflip = doflip;
    }

    @Nullable
    public BlockPos getOldHorizontalBlockPos() {
        return this.oldHorizontalBlockPos;
    }

    public ItemStackHandler getLocoRouteItemHandler() {
        return this.locoRouteItemHandler;
    }
}

