/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.entity.custom.tug;

import dev.murad.shipping.ShippingConfig;
import dev.murad.shipping.block.dock.TugDockTileEntity;
import dev.murad.shipping.block.guiderail.TugGuideRailBlock;
import dev.murad.shipping.capability.StallingCapability;
import dev.murad.shipping.entity.accessor.DataAccessor;
import dev.murad.shipping.entity.custom.SpringEntity;
import dev.murad.shipping.entity.custom.VesselEntity;
import dev.murad.shipping.entity.custom.tug.VehicleFrontPart;
import dev.murad.shipping.entity.navigation.TugPathNavigator;
import dev.murad.shipping.item.TugRouteItem;
import dev.murad.shipping.setup.ModBlocks;
import dev.murad.shipping.setup.ModItems;
import dev.murad.shipping.setup.ModSounds;
import dev.murad.shipping.util.LinkableEntityHead;
import dev.murad.shipping.util.SpringableEntity;
import dev.murad.shipping.util.Train;
import dev.murad.shipping.util.TugRoute;
import dev.murad.shipping.util.TugRouteNode;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundAddMobPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;

public abstract class AbstractTugEntity
extends VesselEntity
implements LinkableEntityHead<VesselEntity>,
SpringableEntity,
Container,
WorldlyContainer {
    protected final ItemStackHandler itemHandler = this.createHandler();
    protected final LazyOptional<IItemHandler> handler = LazyOptional.of(() -> this.itemHandler);
    protected boolean contentsChanged = false;
    protected boolean docked = false;
    protected boolean stalled = false;
    private int dockCheckCooldown = 0;
    private boolean independentMotion = false;
    private int pathfindCooldown = 0;
    private VehicleFrontPart frontHitbox;
    private static final EntityDataAccessor<Boolean> INDEPENDENT_MOTION = SynchedEntityData.m_135353_(AbstractTugEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private TugRoute path;
    private int nextStop;
    private final StallingCapability stalling = new StallingCapability(){

        @Override
        public boolean isDocked() {
            return AbstractTugEntity.this.docked;
        }

        @Override
        public void dock(double x, double y, double z) {
            AbstractTugEntity.this.docked = true;
            AbstractTugEntity.this.m_20256_(Vec3.f_82478_);
            AbstractTugEntity.this.m_6027_(x, y, z);
        }

        @Override
        public void undock() {
            AbstractTugEntity.this.docked = false;
        }

        @Override
        public boolean isStalled() {
            return AbstractTugEntity.this.stalled;
        }

        @Override
        public void stall() {
            AbstractTugEntity.this.stalled = true;
        }

        @Override
        public void unstall() {
            AbstractTugEntity.this.stalled = false;
        }

        @Override
        public boolean isFrozen() {
            return AbstractTugEntity.super.isFrozen();
        }

        @Override
        public void freeze() {
            AbstractTugEntity.this.setFrozen(true);
        }

        @Override
        public void unfreeze() {
            AbstractTugEntity.this.setFrozen(false);
        }
    };
    private final LazyOptional<StallingCapability> stallingOpt = LazyOptional.of(() -> this.stalling);

    @Override
    public boolean allowDockInterface() {
        return this.isDocked();
    }

    public AbstractTugEntity(EntityType<? extends WaterAnimal> type, Level world) {
        super(type, world);
        this.f_19850_ = true;
        this.train = new Train<AbstractTugEntity>(this);
        this.path = new TugRoute();
        this.frontHitbox = new VehicleFrontPart((Entity)this);
    }

    public AbstractTugEntity(EntityType type, Level worldIn, double x, double y, double z) {
        this((EntityType<? extends WaterAnimal>)type, worldIn);
        this.m_6034_(x, y, z);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    public void m_21455_(boolean p_110160_1_, boolean p_110160_2_) {
        this.f_21344_.m_26569_();
        super.m_21455_(p_110160_1_, p_110160_2_);
    }

    public abstract DataAccessor getDataAccessor();

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    public boolean m_6063_() {
        return true;
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(1 + this.getNonRouteItemSlots()){

            protected void onContentsChanged(int slot) {
                AbstractTugEntity.this.contentsChanged = true;
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                switch (slot) {
                    case 0: {
                        return stack.m_41720_() == ModItems.TUG_ROUTE.get();
                    }
                }
                return AbstractTugEntity.this.isTugSlotItemValid(slot, stack);
            }

            public int getSlotLimit(int slot) {
                switch (slot) {
                    case 0: {
                        return 1;
                    }
                }
                return AbstractTugEntity.this.getTugSlotLimit(slot);
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                if (!this.isItemValid(slot, stack)) {
                    return stack;
                }
                return super.insertItem(slot, stack, simulate);
            }
        };
    }

    protected abstract int getNonRouteItemSlots();

    protected boolean isTugSlotItemValid(int slot, @Nonnull ItemStack stack) {
        return false;
    }

    protected int getTugSlotLimit(int slot) {
        return 0;
    }

    protected abstract MenuProvider createContainerProvider();

    @Override
    public void m_7378_(CompoundTag compound) {
        this.itemHandler.deserializeNBT(compound.m_128469_("inv"));
        this.nextStop = compound.m_128441_("next_stop") ? compound.m_128451_("next_stop") : 0;
        this.contentsChanged = true;
        super.m_7378_(compound);
    }

    public void m_7380_(CompoundTag compound) {
        compound.m_128365_("inv", (Tag)this.itemHandler.serializeNBT());
        compound.m_128405_("next_stop", this.nextStop);
        super.m_7380_(compound);
    }

    private void tickRouteCheck() {
        if (this.contentsChanged) {
            ItemStack stack = this.itemHandler.getStackInSlot(0);
            this.setPath(TugRouteItem.getRoute(stack));
            this.contentsChanged = false;
        }
        if (this.nextStop >= this.path.size()) {
            this.nextStop = 0;
        }
    }

    protected abstract boolean tickFuel();

    public static AttributeSupplier.Builder setCustomAttributes() {
        return VesselEntity.setCustomAttributes().m_22268_(Attributes.f_22277_, 200.0);
    }

    protected void onDock() {
        this.m_5496_((SoundEvent)ModSounds.TUG_DOCKING.get(), 0.6f, 1.0f);
    }

    protected void onUndock() {
        this.m_5496_((SoundEvent)ModSounds.TUG_UNDOCKING.get(), 0.6f, 1.5f);
    }

    private List<Direction> getSideDirections() {
        return this.m_6350_() == Direction.NORTH || this.m_6350_() == Direction.SOUTH ? Arrays.asList(Direction.EAST, Direction.WEST) : Arrays.asList(Direction.NORTH, Direction.SOUTH);
    }

    private void tickCheckDock() {
        this.getCapability(StallingCapability.STALLING_CAPABILITY).ifPresent(cap -> {
            boolean changedUndock;
            int x = (int)Math.floor(this.m_20185_());
            int y = (int)Math.floor(this.m_20186_());
            int z = (int)Math.floor(this.m_20189_());
            boolean docked = cap.isDocked();
            if (docked && this.dockCheckCooldown > 0) {
                --this.dockCheckCooldown;
                this.m_20256_(Vec3.f_82478_);
                this.m_6027_((double)x + 0.5, this.m_20186_(), (double)z + 0.5);
                return;
            }
            boolean shouldDock = this.getSideDirections().stream().map(curr -> Optional.ofNullable(this.f_19853_.m_7702_(new BlockPos(x + curr.m_122429_(), y, z + curr.m_122431_()))).filter(entity -> entity instanceof TugDockTileEntity).map(entity -> (TugDockTileEntity)((Object)((Object)((Object)entity)))).map(dock -> dock.hold(this, (Direction)curr)).orElse(false)).reduce(false, (acc, curr) -> acc != false || curr != false);
            boolean changedDock = !docked && shouldDock;
            boolean bl = changedUndock = docked && !shouldDock;
            if (shouldDock) {
                this.dockCheckCooldown = 20;
                cap.dock((double)x + 0.5, this.m_20186_(), (double)z + 0.5);
            } else {
                this.dockCheckCooldown = 0;
                cap.undock();
            }
            if (changedDock) {
                this.onDock();
            }
            if (changedUndock) {
                this.onUndock();
            }
        });
    }

    public boolean m_6040_() {
        return true;
    }

    protected void makeSmoke() {
        Level world = this.f_19853_;
        if (world != null) {
            BlockPos blockpos = this.m_20097_().m_7494_().m_7494_();
            Random random = world.f_46441_;
            if ((double)random.nextFloat() < (Double)ShippingConfig.Client.TUG_SMOKE_MODIFIER.get()) {
                for (int i = 0; i < random.nextInt(2) + 2; ++i) {
                    AbstractTugEntity.makeParticles(world, blockpos, true, false);
                }
            }
        }
    }

    public static void makeParticles(Level p_220098_0_, BlockPos p_220098_1_, boolean p_220098_2_, boolean p_220098_3_) {
        Random random = p_220098_0_.m_5822_();
        Supplier<Boolean> h = () -> random.nextDouble() < 0.5;
        SimpleParticleType basicparticletype = p_220098_2_ ? ParticleTypes.f_123778_ : ParticleTypes.f_123777_;
        double xdrift = (double)(h.get() != false ? 1 : -1) * random.nextDouble() * 2.0;
        double zdrift = (double)(h.get() != false ? 1 : -1) * random.nextDouble() * 2.0;
        p_220098_0_.m_6485_((ParticleOptions)basicparticletype, true, (double)p_220098_1_.m_123341_() + 0.5 + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), (double)p_220098_1_.m_123342_() + random.nextDouble() + random.nextDouble(), (double)p_220098_1_.m_123343_() + 0.5 + random.nextDouble() / 3.0 * (double)(random.nextBoolean() ? 1 : -1), 0.007 * xdrift, 0.05, 0.007 * zdrift);
    }

    protected PathNavigation m_6037_(Level p_175447_1_) {
        return new TugPathNavigator((Mob)this, p_175447_1_);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (!player.f_19853_.m_5776_()) {
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)this.createContainerProvider(), this.getDataAccessor()::write);
        }
        return InteractionResult.CONSUME;
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        super.m_7350_(key);
        if (this.f_19853_.f_46443_ && INDEPENDENT_MOTION.equals(key)) {
            this.independentMotion = (Boolean)this.f_19804_.m_135370_(INDEPENDENT_MOTION);
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new MovementGoal());
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public PartEntity<?>[] getParts() {
        return new PartEntity[]{this.frontHitbox};
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_21224_() && !this.m_21525_()) {
            this.frontHitbox.updatePosition((Entity)this);
        }
    }

    public void m_142223_(ClientboundAddMobPacket p_149572_) {
        super.m_142223_(p_149572_);
        this.frontHitbox.m_20234_(p_149572_.m_131552_());
    }

    @Override
    public void m_8119_() {
        if (this.f_19853_.f_46443_ && this.independentMotion) {
            this.makeSmoke();
        }
        super.m_8119_();
    }

    private void followGuideRail() {
        StallingCapability cap;
        LazyOptional<StallingCapability> dockcap = this.getCapability(StallingCapability.STALLING_CAPABILITY);
        if (dockcap.isPresent() && dockcap.resolve().isPresent() && ((cap = (StallingCapability)dockcap.resolve().get()).isDocked() || cap.isFrozen() || cap.isStalled())) {
            return;
        }
        List<BlockState> belowList = Arrays.asList(this.f_19853_.m_8055_(this.m_20097_().m_7495_()), this.f_19853_.m_8055_(this.m_20097_().m_7495_().m_7495_()));
        BlockState water = this.f_19853_.m_8055_(this.m_20097_());
        for (BlockState below : belowList) {
            if (!below.m_60713_((Block)ModBlocks.GUIDE_RAIL_TUG.get()) || !water.m_60713_(Blocks.f_49990_)) continue;
            Direction arrows = TugGuideRailBlock.getArrowsDirection(below);
            this.m_146922_(arrows.m_122435_());
            double modifier = 0.03;
            this.m_20256_(this.m_20184_().m_82549_(new Vec3((double)arrows.m_122429_() * modifier, 0.0, (double)arrows.m_122431_() * modifier)));
        }
    }

    protected void m_8024_() {
        super.m_8024_();
    }

    private void followPath() {
        --this.pathfindCooldown;
        if (!(this.path.isEmpty() || this.docked || this.stalled || this.shouldFreezeTrain() || !this.tickFuel())) {
            TugRouteNode stop = (TugRouteNode)this.path.get(this.nextStop);
            if (this.f_21344_.m_26570_() == null || this.f_21344_.m_26570_().m_77392_()) {
                if (this.pathfindCooldown < 0 || this.f_21344_.m_26570_() != null) {
                    this.f_21344_.m_26519_(stop.getX(), this.m_20186_(), stop.getZ(), 0.3);
                    this.pathfindCooldown = 20;
                } else {
                    return;
                }
            }
            double distance = Math.abs(Math.hypot(this.m_20185_() - (stop.getX() + 0.5), this.m_20189_() - (stop.getZ() + 0.5)));
            this.independentMotion = true;
            this.f_19804_.m_135381_(INDEPENDENT_MOTION, (Object)true);
            if (distance < 0.9) {
                this.incrementStop();
            }
        } else {
            this.f_19804_.m_135381_(INDEPENDENT_MOTION, (Object)false);
            this.f_21344_.m_26573_();
            if (this.path.isEmpty()) {
                this.nextStop = 0;
            }
        }
    }

    public boolean shouldFreezeTrain() {
        return this.train.asList().stream().anyMatch(VesselEntity::isFrozen);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(INDEPENDENT_MOTION, (Object)false);
    }

    public void setPath(TugRoute path) {
        if (!this.path.isEmpty() && !this.path.equals(path)) {
            this.nextStop = 0;
        }
        this.path = path;
    }

    private void incrementStop() {
        if (this.path.size() == 1) {
            this.nextStop = 0;
        } else if (!this.path.isEmpty()) {
            this.nextStop = (this.nextStop + 1) % this.path.size();
        }
    }

    @Override
    public void setDominated(VesselEntity entity) {
        this.dominated = Optional.of(entity);
    }

    @Override
    public void setDominatedSpring(SpringEntity spring) {
        this.dominatedS = Optional.of(spring);
    }

    @Override
    public void setDominant(VesselEntity entity) {
    }

    @Override
    public void setDominantSpring(SpringEntity entity) {
    }

    @Override
    public void removeDominated() {
        this.dominated = Optional.empty();
        this.train.setTail(this);
    }

    @Override
    public void removeDominant() {
    }

    @Override
    public void setTrain(Train train) {
        this.train = train;
    }

    public boolean m_6469_(DamageSource p_70097_1_, float p_70097_2_) {
        if (this.m_6673_(p_70097_1_)) {
            return false;
        }
        if (!this.f_19853_.f_46443_ && !this.m_146910_()) {
            this.m_19998_((ItemLike)this.getDropItem());
            this.m_142687_(Entity.RemovalReason.KILLED);
            return true;
        }
        return true;
    }

    public void m_142687_(Entity.RemovalReason r) {
        if (!this.f_19853_.f_46443_) {
            Containers.m_18998_((Level)this.f_19853_, (Entity)this, (Container)this);
        }
        this.handleLinkableKill();
        super.m_142687_(r);
    }

    public ItemStack m_8020_(int p_70301_1_) {
        return this.itemHandler.getStackInSlot(p_70301_1_);
    }

    public ItemStack m_7407_(int p_70298_1_, int p_70298_2_) {
        return null;
    }

    public ItemStack m_8016_(int p_70304_1_) {
        return null;
    }

    public boolean m_7013_(int p_94041_1_, ItemStack p_94041_2_) {
        return true;
    }

    public void m_6596_() {
        this.contentsChanged = true;
    }

    public boolean m_6542_(Player p_70300_1_) {
        if (this.m_146910_()) {
            return false;
        }
        return !(p_70300_1_.m_20280_((Entity)this) > 64.0);
    }

    public void m_6211_() {
    }

    public boolean m_7157_(int p_180461_1_, ItemStack p_180461_2_, Direction p_180461_3_) {
        return false;
    }

    public int[] m_7071_(Direction p_180463_1_) {
        return IntStream.range(1, this.m_6643_()).toArray();
    }

    public boolean m_7155_(int p_180462_1_, ItemStack p_180462_2_, @Nullable Direction p_180462_3_) {
        return this.isDocked();
    }

    public int m_6643_() {
        return 1 + this.getNonRouteItemSlots();
    }

    public boolean m_6573_(Player p_184652_1_) {
        return true;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap) {
        if (cap == StallingCapability.STALLING_CAPABILITY) {
            return this.stallingOpt.cast();
        }
        return super.getCapability(cap);
    }

    public boolean isDocked() {
        return this.docked;
    }

    public boolean isStalled() {
        return this.stalled;
    }

    class MovementGoal
    extends Goal {
        MovementGoal() {
        }

        public boolean m_8036_() {
            return AbstractTugEntity.this.path != null;
        }

        public void m_8037_() {
            if (!AbstractTugEntity.this.f_19853_.f_46443_) {
                AbstractTugEntity.this.tickRouteCheck();
                AbstractTugEntity.this.tickCheckDock();
                AbstractTugEntity.this.followPath();
                AbstractTugEntity.this.followGuideRail();
            }
        }
    }
}

