/*
 * Decompiled with CFR 0.152.
 */
package dev.murad.shipping.util;

import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class LocoRouteNode {
    private static final String NAME_TAG = "name";
    private static final String X_TAG = "x";
    private static final String Y_TAG = "y";
    private static final String Z_TAG = "z";
    private static final String COORDS_TAG = "coordinates";
    @Nullable
    private String name;
    private final double x;
    private final double y;
    private final double z;

    public LocoRouteNode(@Nullable String name, double x, double y, double z) {
        this.name = name;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public LocoRouteNode(double x, double y, double z) {
        this(null, x, y, z);
    }

    public void setName(@Nullable String name) {
        this.name = name;
    }

    public boolean hasCustomName() {
        return this.name != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocoRouteNode that = (LocoRouteNode)o;
        return Double.compare(that.x, this.x) == 0 && Double.compare(that.y, this.y) == 0 && Double.compare(that.z, this.z) == 0 && Objects.equals(this.name, that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.x, this.y, this.z);
    }

    public CompoundTag toNBT() {
        CompoundTag tag = new CompoundTag();
        if (this.hasCustomName()) {
            tag.m_128359_(NAME_TAG, this.getName());
        }
        CompoundTag coords = new CompoundTag();
        coords.m_128347_(X_TAG, this.x);
        coords.m_128347_(Y_TAG, this.y);
        coords.m_128347_(Z_TAG, this.z);
        tag.m_128365_(COORDS_TAG, (Tag)coords);
        return tag;
    }

    public static LocoRouteNode fromNBT(CompoundTag tag) {
        String name = null;
        if (tag.m_128441_(NAME_TAG)) {
            name = tag.m_128461_(NAME_TAG);
        }
        CompoundTag coords = tag.m_128469_(COORDS_TAG);
        double x = coords.m_128459_(X_TAG);
        double y = coords.m_128459_(Y_TAG);
        double z = coords.m_128459_(Z_TAG);
        return new LocoRouteNode(name, x, y, z);
    }

    public static LocoRouteNode fromBlocKPos(BlockPos pos) {
        return new LocoRouteNode(null, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public BlockPos toBlockPos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public boolean isAt(BlockPos pos) {
        return this.x == (double)pos.m_123341_() && this.y == (double)pos.m_123342_() && this.z == (double)pos.m_123343_();
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }
}

