/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud;

import dlovin.inventoryhud.InvClientThings;
import dlovin.inventoryhud.config.InvConfig;
import dlovin.inventoryhud.events.CuriosIntegration;
import dlovin.inventoryhud.events.InvEvents;
import dlovin.inventoryhud.events.UpdateNotificationEvent;
import dlovin.inventoryhud.gui.InventoryGui;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="inventoryhud")
public class InventoryHUD {
    public static InventoryHUD instance;
    public static final String modid = "inventoryhud";
    public static final Logger logger;
    private static InvConfig CONFIG;
    public static boolean isActive;
    public static boolean armorHUD;
    public static boolean potionHUD;
    public static boolean isCuriosMod;
    public static boolean curiosLoaded;
    private InventoryGui inventoryGui;

    public InventoryHUD() {
        if (FMLEnvironment.dist.isDedicatedServer()) {
            return;
        }
        CONFIG = new InvConfig();
        instance = this;
        CONFIG.register(ModLoadingContext.get());
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        if (ModList.get().isLoaded("curios")) {
            isCuriosMod = true;
        }
        bus.addListener(this::clientRegistries);
        InvClientThings.initClient();
    }

    public static InvConfig getConfig() {
        return CONFIG;
    }

    public static InvConfig.Client getClient() {
        return CONFIG.getClient();
    }

    public InventoryGui getInventoryGui() {
        return this.inventoryGui;
    }

    public static InventoryHUD getInstance() {
        return instance;
    }

    private void clientRegistries(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new InventoryGui());
        MinecraftForge.EVENT_BUS.register((Object)new InvEvents());
        MinecraftForge.EVENT_BUS.register((Object)new UpdateNotificationEvent());
        if (isCuriosMod) {
            MinecraftForge.EVENT_BUS.register((Object)new CuriosIntegration());
        }
    }

    public void setInvGui(InventoryGui inventoryGui) {
        this.inventoryGui = inventoryGui;
    }

    static {
        logger = LogManager.getLogger((String)modid);
        isActive = false;
        armorHUD = false;
        potionHUD = true;
        isCuriosMod = false;
        curiosLoaded = false;
    }
}

