/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dlovin.inventoryhud.InventoryHUD;
import dlovin.inventoryhud.config.InvConfig;
import dlovin.inventoryhud.gui.renderers.ArmorRenderer;
import dlovin.inventoryhud.gui.renderers.BlockArmorRenderer;
import dlovin.inventoryhud.gui.renderers.CuriosRenderer;
import dlovin.inventoryhud.gui.renderers.EachArmorRenderer;
import dlovin.inventoryhud.gui.renderers.HorizontalMiniPotionRenderer;
import dlovin.inventoryhud.gui.renderers.HorizontalPotionRenderer;
import dlovin.inventoryhud.gui.renderers.HotBarArmorRenderer;
import dlovin.inventoryhud.gui.renderers.PotionRenderer;
import dlovin.inventoryhud.gui.renderers.VerticalMiniPotionRenderer;
import dlovin.inventoryhud.gui.renderers.VerticalPotionRenderer;
import dlovin.inventoryhud.utils.CuriosSaveUtils;
import dlovin.inventoryhud.utils.EachItem;
import dlovin.inventoryhud.utils.WidgetAligns;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.screens.inventory.ContainerScreen;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class InventoryGui
extends Gui {
    private final ItemRenderer itemRenderer;
    private final Font fontRenderer;
    private final Minecraft minecraft = Minecraft.m_91087_();
    public static int invX;
    public static int invY;
    public static WidgetAligns InvAligns;
    public static float invAlpha;
    public static boolean invMini;
    public static boolean invVert;
    public static boolean animated;
    public static boolean hideBackground;
    private static final ResourceLocation INVBG;
    public ArmorRenderer armorRenderer;
    public PotionRenderer potionRenderer;
    public CuriosRenderer curiosRenderer;

    public InventoryGui() {
        super(Minecraft.m_91087_());
        this.itemRenderer = this.minecraft.m_91291_();
        this.fontRenderer = this.minecraft.f_91062_;
        WidgetAligns ArmAligns = new WidgetAligns((WidgetAligns.HAlign)((Object)InventoryHUD.getClient().armHalign.get()), (WidgetAligns.VAlign)((Object)InventoryHUD.getClient().armValign.get()));
        int armX = (Integer)InventoryHUD.getClient().xArmPos.get();
        int armY = (Integer)InventoryHUD.getClient().yArmPos.get();
        this.armorRenderer = (Boolean)InventoryHUD.getClient().moveAll.get() == false ? new EachArmorRenderer(this.minecraft) : (ArmAligns.HorAlign == WidgetAligns.HAlign.MIDDLE && ArmAligns.VertAlign == WidgetAligns.VAlign.BOTTOM && armY <= 90 && Math.abs(armX) <= 90 ? new HotBarArmorRenderer(this.minecraft) : new BlockArmorRenderer(this.minecraft));
        if (InventoryHUD.isCuriosMod) {
            this.curiosRenderer = new CuriosRenderer(this.minecraft, CuriosSaveUtils.loadFromFile());
        }
        this.setupArmorRenderer();
        this.potionRenderer = (Boolean)InventoryHUD.getClient().potHor.get() != false ? ((Boolean)InventoryHUD.getClient().potMini.get() != false ? new HorizontalMiniPotionRenderer(this.minecraft) : new HorizontalPotionRenderer(this.minecraft)) : ((Boolean)InventoryHUD.getClient().potMini.get() != false ? new VerticalMiniPotionRenderer(this.minecraft) : new VerticalPotionRenderer(this.minecraft));
        this.setupPotionRenderer();
        InventoryHUD.isActive = (Boolean)InventoryHUD.getClient().byDefault.get();
        InventoryHUD.armorHUD = (Boolean)InventoryHUD.getClient().ArmorDamage.get();
        InventoryHUD.potionHUD = (Boolean)InventoryHUD.getClient().Potions.get();
        invX = (Integer)InventoryHUD.getClient().xPos.get();
        invY = (Integer)InventoryHUD.getClient().yPos.get();
        InvAligns = new WidgetAligns((WidgetAligns.HAlign)((Object)InventoryHUD.getClient().invHalign.get()), (WidgetAligns.VAlign)((Object)InventoryHUD.getClient().invValign.get()));
        invMini = (Boolean)InventoryHUD.getClient().invMini.get();
        invVert = (Boolean)InventoryHUD.getClient().invVert.get();
        animated = (Boolean)InventoryHUD.getClient().animatedInv.get();
        hideBackground = (Boolean)InventoryHUD.getClient().hideBackground.get();
        invAlpha = (float)((Integer)InventoryHUD.getClient().invAlpha.get()).intValue() / 100.0f;
        InventoryHUD.getInstance().setInvGui(this);
    }

    private void setupPotionRenderer() {
        this.potionRenderer.potX = (Integer)InventoryHUD.getClient().xPotionPos.get();
        this.potionRenderer.potY = (Integer)InventoryHUD.getClient().yPotionPos.get();
        this.potionRenderer.PotAligns = new WidgetAligns((WidgetAligns.HAlign)((Object)InventoryHUD.getClient().potHalign.get()), (WidgetAligns.VAlign)((Object)InventoryHUD.getClient().potValign.get()));
        this.potionRenderer.potMini = (Boolean)InventoryHUD.getClient().potMini.get();
        this.potionRenderer.potGap = (Integer)InventoryHUD.getClient().potGap.get();
        this.potionRenderer.barDuration = (Integer)InventoryHUD.getClient().barDuration.get() * 20;
        this.potionRenderer.PotPosChanged();
        switch (this.potionRenderer.PotAligns.VertAlign) {
            case TOP: {
                this.potionRenderer.potVert = 1;
                break;
            }
            case CENTER: {
                if (this.potionRenderer.potY - 12 < this.minecraft.m_91268_().m_85446_() / 2) {
                    this.potionRenderer.potVert = -1;
                    break;
                }
                this.potionRenderer.potVert = 1;
                break;
            }
            case BOTTOM: {
                this.potionRenderer.potVert = -1;
            }
        }
        this.potionRenderer.potAlpha = (float)((Integer)InventoryHUD.getClient().potAlpha.get()).intValue() / 100.0f;
    }

    private void setupArmorRenderer() {
        this.armorRenderer.armX = (Integer)InventoryHUD.getClient().xArmPos.get();
        this.armorRenderer.armY = (Integer)InventoryHUD.getClient().yArmPos.get();
        this.armorRenderer.ArmAligns = new WidgetAligns((WidgetAligns.HAlign)((Object)InventoryHUD.getClient().armHalign.get()), (WidgetAligns.VAlign)((Object)InventoryHUD.getClient().armValign.get()));
        this.armorRenderer.armAbove = (Integer)InventoryHUD.getClient().armAbove.get();
        this.armorRenderer.armScale = (Integer)InventoryHUD.getClient().armScale.get();
        this.armorRenderer.showArmor = (Boolean)InventoryHUD.getClient().showArmor.get();
        this.armorRenderer.showMain = (Boolean)InventoryHUD.getClient().showMain.get();
        this.armorRenderer.showOff = (Boolean)InventoryHUD.getClient().showOff.get();
        this.armorRenderer.showArrows = (Boolean)InventoryHUD.getClient().showArrows.get();
        this.armorRenderer.showInv = (Boolean)InventoryHUD.getClient().showInv.get();
        this.armorRenderer.showEmpty = (Boolean)InventoryHUD.getClient().showEmpty.get();
        this.armorRenderer.showCount = (Boolean)InventoryHUD.getClient().showCount.get();
        this.armorRenderer.armView = (InvConfig.ArmorView)((Object)InventoryHUD.getClient().armView.get());
        this.armorRenderer.armBars = (Boolean)InventoryHUD.getClient().armBars.get();
        if (InventoryHUD.isCuriosMod) {
            this.curiosRenderer.armAbove = this.armorRenderer.armAbove;
            this.curiosRenderer.armScale = this.armorRenderer.armScale;
            this.curiosRenderer.showEmpty = this.armorRenderer.showEmpty;
            this.curiosRenderer.armView = this.armorRenderer.armView;
            this.curiosRenderer.armBars = this.armorRenderer.armBars;
            this.curiosRenderer.showCount = this.armorRenderer.showCount;
        }
        this.armorRenderer.items[0] = new EachItem((Integer)InventoryHUD.getClient().helmPosX.get(), (Integer)InventoryHUD.getClient().helmPosY.get(), new WidgetAligns((WidgetAligns.HAlign)((Object)InventoryHUD.getClient().helmHal.get()), (WidgetAligns.VAlign)((Object)InventoryHUD.getClient().helmVal.get())));
        this.armorRenderer.items[1] = new EachItem((Integer)InventoryHUD.getClient().chestPosX.get(), (Integer)InventoryHUD.getClient().chestPosY.get(), new WidgetAligns((WidgetAligns.HAlign)((Object)InventoryHUD.getClient().chestHal.get()), (WidgetAligns.VAlign)((Object)InventoryHUD.getClient().chestVal.get())));
        this.armorRenderer.items[2] = new EachItem((Integer)InventoryHUD.getClient().legPosX.get(), (Integer)InventoryHUD.getClient().legPosY.get(), new WidgetAligns((WidgetAligns.HAlign)((Object)InventoryHUD.getClient().legHal.get()), (WidgetAligns.VAlign)((Object)InventoryHUD.getClient().legVal.get())));
        this.armorRenderer.items[3] = new EachItem((Integer)InventoryHUD.getClient().bootPosX.get(), (Integer)InventoryHUD.getClient().bootPosY.get(), new WidgetAligns((WidgetAligns.HAlign)((Object)InventoryHUD.getClient().bootHal.get()), (WidgetAligns.VAlign)((Object)InventoryHUD.getClient().bootVal.get())));
        this.armorRenderer.items[4] = new EachItem((Integer)InventoryHUD.getClient().offPosX.get(), (Integer)InventoryHUD.getClient().offPosY.get(), new WidgetAligns((WidgetAligns.HAlign)((Object)InventoryHUD.getClient().offHal.get()), (WidgetAligns.VAlign)((Object)InventoryHUD.getClient().offVal.get())));
        this.armorRenderer.items[5] = new EachItem((Integer)InventoryHUD.getClient().mainPosX.get(), (Integer)InventoryHUD.getClient().mainPosY.get(), new WidgetAligns((WidgetAligns.HAlign)((Object)InventoryHUD.getClient().mainHal.get()), (WidgetAligns.VAlign)((Object)InventoryHUD.getClient().mainVal.get())));
        this.armorRenderer.items[6] = new EachItem((Integer)InventoryHUD.getClient().invPosX.get(), (Integer)InventoryHUD.getClient().invPosY.get(), new WidgetAligns((WidgetAligns.HAlign)((Object)InventoryHUD.getClient().invHal.get()), (WidgetAligns.VAlign)((Object)InventoryHUD.getClient().invVal.get())));
        this.armorRenderer.items[7] = new EachItem((Integer)InventoryHUD.getClient().arrPosX.get(), (Integer)InventoryHUD.getClient().arrPosY.get(), new WidgetAligns((WidgetAligns.HAlign)((Object)InventoryHUD.getClient().arrHal.get()), (WidgetAligns.VAlign)((Object)InventoryHUD.getClient().arrVal.get())));
        this.changeArmorOffset();
    }

    @SubscribeEvent
    public void onPreLayer(RenderGameOverlayEvent.PreLayer event) {
        if (event.getOverlay().equals(ForgeIngameGui.POTION_ICONS_ELEMENT) && InventoryHUD.potionHUD) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onPreRenderGui(RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        PoseStack mat = event.getMatrixStack();
        int width = this.minecraft.m_91268_().m_85445_();
        int height = this.minecraft.m_91268_().m_85446_();
        mat.m_85836_();
        if (InventoryHUD.armorHUD) {
            this.armorRenderer.render(mat, width, height);
            if (InventoryHUD.isCuriosMod && InventoryHUD.curiosLoaded) {
                this.curiosRenderer.render(mat, width, height);
            }
        }
        if (InventoryHUD.potionHUD) {
            this.potionRenderer.render(mat, width, height);
        }
        if (InventoryHUD.isActive && !(this.minecraft.f_91080_ instanceof ContainerScreen)) {
            this.RenderInventory(mat, width, height, event.getPartialTicks());
        }
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mat.m_85849_();
    }

    private void RenderInventory(PoseStack mat, int width, int height, float partialTicks) {
        int iMax = invVert ? 3 : 9;
        int jMax = invVert ? 9 : 3;
        float scale = invMini ? 0.75f : 1.0f;
        int px = this.getX(width, (int)((float)(iMax * 18 - 2) * scale), invX, InventoryGui.InvAligns.HorAlign);
        int py = this.getY(height, (int)((float)(jMax * 18 - 2) * scale), invY, InventoryGui.InvAligns.VertAlign);
        ArrayList<Runnable> items = new ArrayList<Runnable>();
        for (int i = 0; i < iMax; ++i) {
            for (int j = 0; j < jMax; ++j) {
                int index = invVert ? (3 - i) * 9 + j : i + (j + 1) * 9;
                ItemStack item = (ItemStack)this.minecraft.f_91074_.m_150109_().f_35974_.get(index);
                PoseStack matr = RenderSystem.m_157191_();
                if (item == null || item.m_41720_().equals(Items.f_41852_)) continue;
                int finalI = i;
                int finalJ = j;
                items.add(() -> {
                    float f = (float)item.m_41612_() - partialTicks;
                    matr.m_85836_();
                    matr.m_85837_((double)px, (double)py, 0.0);
                    matr.m_85841_(scale, scale, 1.0f);
                    if (animated && f > 0.0f) {
                        matr.m_85836_();
                        float f1 = 1.0f + f / 5.0f;
                        matr.m_85837_((double)(finalI * 18 + 12), (double)(finalJ * 18 + 12), 0.0);
                        matr.m_85841_((f1 + 1.0f) / 2.0f, (f1 + 1.0f) / 2.0f, 1.0f);
                        matr.m_85837_((double)(-(finalI * 18 + 12)), (double)(-(finalJ * 18 + 12)), 0.0);
                    }
                    RenderSystem.m_157182_();
                    this.itemRenderer.m_115203_(item, finalI * 18, finalJ * 18);
                    if (animated && f > 0.0f) {
                        matr.m_85849_();
                    }
                    this.itemRenderer.m_115174_(this.fontRenderer, item, finalI * 18, finalJ * 18, null);
                    matr.m_85849_();
                    RenderSystem.m_157182_();
                });
            }
        }
        if (hideBackground && items.size() == 0) {
            return;
        }
        mat.m_85836_();
        mat.m_85837_((double)px, (double)py, -255.0);
        mat.m_85841_(scale, scale, scale);
        RenderSystem.m_69478_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)invAlpha);
        RenderSystem.m_157456_((int)0, (ResourceLocation)INVBG);
        InventoryGui.m_93160_((PoseStack)mat, (int)-8, (int)-8, (int)(iMax * 18 + 14), (int)(jMax * 18 + 14), (float)0.0f, (float)(jMax == 3 ? 0.0f : 68.0f), (int)(iMax * 18 + 14), (int)(jMax * 18 + 14), (int)256, (int)256);
        RenderSystem.m_69461_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        items.forEach(r -> r.run());
        mat.m_85849_();
    }

    private int getX(int width, int itemWidth, int x, WidgetAligns.HAlign hal) {
        int result = 0;
        switch (hal) {
            case LEFT: {
                result = x;
                break;
            }
            case MIDDLE: {
                result = width / 2 - itemWidth / 2 - x;
                break;
            }
            case RIGHT: {
                result = width - x;
            }
        }
        if (result < 0) {
            result = 0;
        } else if (result > width - itemWidth) {
            result = width - itemWidth;
        }
        return result;
    }

    private int getY(int height, int itemHeight, int y, WidgetAligns.VAlign val) {
        int result = 0;
        switch (val) {
            case TOP: {
                result = y;
                break;
            }
            case CENTER: {
                result = height / 2 - itemHeight / 2 - y;
                break;
            }
            case BOTTOM: {
                result = height - y;
            }
        }
        if (result < 0) {
            result = 0;
        } else if (result > height - itemHeight) {
            result = height - itemHeight;
        }
        return result;
    }

    public void changeArmorPos(WidgetAligns armal, int ax, int ay) {
        float scale = (float)this.armorRenderer.armScale / 100.0f;
        if (armal.HorAlign == WidgetAligns.HAlign.MIDDLE && armal.VertAlign == WidgetAligns.VAlign.BOTTOM && (float)ay <= 70.0f * scale + 5.0f && Math.abs(ax) <= 90) {
            if (!(this.armorRenderer instanceof HotBarArmorRenderer)) {
                this.armorRenderer = new HotBarArmorRenderer(this.minecraft);
                this.setupArmorRenderer();
            }
        } else if (this.armorRenderer instanceof HotBarArmorRenderer) {
            this.armorRenderer = new BlockArmorRenderer(this.minecraft);
            this.setupArmorRenderer();
        }
        this.armorRenderer.ArmAligns = armal;
        this.armorRenderer.armY = ay;
        this.armorRenderer.armX = ax;
        if (this.armorRenderer instanceof BlockArmorRenderer) {
            ((BlockArmorRenderer)this.armorRenderer).changeOffset();
        }
    }

    public void changeArmorOffset() {
        if (this.armorRenderer instanceof BlockArmorRenderer) {
            ((BlockArmorRenderer)this.armorRenderer).changeOffset();
        }
    }

    public void changeMoveAll(Boolean bd) {
        WidgetAligns ArmAligns = new WidgetAligns((WidgetAligns.HAlign)((Object)InventoryHUD.getClient().armHalign.get()), (WidgetAligns.VAlign)((Object)InventoryHUD.getClient().armValign.get()));
        int armX = (Integer)InventoryHUD.getClient().xArmPos.get();
        int armY = (Integer)InventoryHUD.getClient().yArmPos.get();
        this.armorRenderer = bd == false ? new EachArmorRenderer(this.minecraft) : (ArmAligns.HorAlign == WidgetAligns.HAlign.MIDDLE && ArmAligns.VertAlign == WidgetAligns.VAlign.BOTTOM && armY <= 90 && Math.abs(armX) <= 90 ? new HotBarArmorRenderer(this.minecraft) : new BlockArmorRenderer(this.minecraft));
        this.setupArmorRenderer();
    }

    public void changePotionMini(boolean mini) {
        this.changePotion(mini, (Boolean)InventoryHUD.getClient().potHor.get());
        this.setupPotionRenderer();
    }

    public void changePotionHor(boolean hor) {
        this.changePotion((Boolean)InventoryHUD.getClient().potMini.get(), hor);
    }

    private void changePotion(boolean mini, boolean hor) {
        this.potionRenderer = hor ? (mini ? new HorizontalMiniPotionRenderer(this.minecraft) : new HorizontalPotionRenderer(this.minecraft)) : (mini ? new VerticalMiniPotionRenderer(this.minecraft) : new VerticalPotionRenderer(this.minecraft));
        this.setupPotionRenderer();
    }

    static {
        INVBG = new ResourceLocation("inventoryhud", "textures/gui/inv_bg.png");
    }
}

