/*
 * Decompiled with CFR 0.152.
 */
package dlovin.inventoryhud.gui.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import dlovin.inventoryhud.armorstatus.ArmorStatus;
import dlovin.inventoryhud.config.InvConfig;
import dlovin.inventoryhud.gui.renderers.ArmorRenderer;
import dlovin.inventoryhud.gui.widgets.CuriosIconUtils;
import dlovin.inventoryhud.utils.CuriosSlot;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class CuriosRenderer
extends ArmorRenderer {
    public HashMap<String, CuriosSlot> slots;

    public CuriosRenderer(Minecraft mc) {
        super(mc);
    }

    public CuriosRenderer(Minecraft mc, HashMap<String, CuriosSlot> slots) {
        super(mc);
        this.slots = slots;
    }

    @Override
    public void render(PoseStack mat, int width, int height) {
        float scale = (float)this.armScale / 100.0f;
        mat.m_85836_();
        mat.m_85837_(0.0, 0.0, -320.0);
        CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)this.mc.f_91074_).ifPresent(handler -> handler.getCurios().forEach((id, stacksHandler) -> {
            CuriosSlot slot = this.slots.get(id);
            if (slot != null && slot.enabled) {
                IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                for (int j = 0; j < stackHandler.getSlots(); ++j) {
                    ItemStack stack = stackHandler.getStackInSlot(j);
                    int x = this.getX(width, (int)(16.0f * scale), slot.x, slot.aligns.HorAlign);
                    int y = this.getY(height, (int)(16.0f * scale), slot.y, slot.aligns.VertAlign);
                    boolean right = this.getRight(slot.x, slot.aligns.HorAlign);
                    int Damage = ArmorStatus.GetDamage(stack);
                    String text = null;
                    if (Damage >= 0 && Damage <= this.armAbove) {
                        if (!this.armView.equals((Object)InvConfig.ArmorView.OFF)) {
                            switch (this.armView) {
                                case PERCENTAGE: {
                                    text = this.getDamageText(String.valueOf(Damage), Damage);
                                    break;
                                }
                                case DAMAGE: {
                                    text = this.getDamageText(String.valueOf(stack.m_41773_()), Damage);
                                    break;
                                }
                                case DAMAGE_LEFT: {
                                    text = this.getDamageText(String.valueOf(stack.m_41776_() - stack.m_41773_()), Damage);
                                }
                            }
                        }
                        this.pushAndRender(mat, x, (int)((float)y + (float)(j * 18) * scale), !right, null, stack, text, this.armBars, scale);
                        continue;
                    }
                    if (Damage == -2) {
                        this.pushAndRender(mat, x, (int)((float)y + (float)(j * 18) * scale), !right, null, stack, null, true, scale);
                        continue;
                    }
                    if (!this.showEmpty) continue;
                    ResourceLocation res = CuriosIconUtils.getRealResourceLocation(id, CuriosApi.getIconHelper().getIcon(id));
                    this.pushAndRender(mat, x, (int)((float)y + (float)(j * 18) * scale), !right, res, null, null, false, scale);
                }
            }
        }));
        mat.m_85849_();
    }

    private void pushAndRender(PoseStack mat, int x, int y, boolean right, ResourceLocation resourceLocation, ItemStack itemStack, String text, boolean over, float scale) {
        mat.m_85836_();
        mat.m_85837_((double)x, (double)y, 0.0);
        mat.m_85841_(scale, scale, 1.0f);
        this.renderElement(mat, x, y, scale, right, resourceLocation, itemStack, text, over);
        mat.m_85849_();
    }
}

